/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.network.ClientBoundRecipePipePayload;
import jagm.classicpipes.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class RecipePipeBlock
extends NetworkedPipeBlock {
    public RecipePipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RecipePipeEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.RECIPE_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).m_7702_(pos)) instanceof RecipePipeEntity) {
            RecipePipeEntity craftingPipe = (RecipePipeEntity)blockEntity;
            craftingPipe.dropHeldItems(serverLevel, pos);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pipePos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = level.m_7702_(pipePos)) instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)blockEntity;
            Services.LOADER_SERVICE.openMenu((ServerPlayer)player, recipePipe, new ClientBoundRecipePipePayload(recipePipe.getSlotDirections(), recipePipe.getDirectionsForButtons(state), pipePos, recipePipe.isBlockingMode()), ClientBoundRecipePipePayload.HANDLER);
        }
        return InteractionResult.SUCCESS;
    }
}

