/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class ShelfBlock
extends BaseBlock {
    public static final EnumProperty<Connection> CONNECTION = EnumProperty.m_61587_((String)"connection", Connection.class);

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
        consumer.accept((Property<?>)CONNECTION);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_SHELF.isIn(blockState)) {
            return HitBoxes.NORDIC.shelf(this, blockState);
        }
        if (AllBlocks.DUNMER_SHELF.isIn(blockState)) {
            return HitBoxes.DUNMER.shelf(this, blockState);
        }
        if (AllBlocks.VENTHYR_SHELF.isIn(blockState)) {
            return HitBoxes.VENTHYR.shelf(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_SHELF.isIn(blockState) || AllBlocks.BONE_WITHER_SHELF.isIn(blockState)) {
            return HitBoxes.BONE.shelf(this, blockState);
        }
        if (AllBlocks.ROYAL_SHELF.isIn(blockState)) {
            return HitBoxes.ROYAL.shelf(this, blockState);
        }
        if (AllBlocks.NECROLORD_SHELF.isIn(blockState)) {
            return HitBoxes.NECROLORD.shelf(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingBlockState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        blockState = super.m_7417_(blockState, facing, facingBlockState, level, pos, facingPos);
        return ShelfBlock.getBlockState(level, pos, blockState, this);
    }

    @Nullable
    protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
        if ((placementBlockState = super.modifyPlacementState(placementBlockState, ctx)) != null) {
            placementBlockState = ShelfBlock.getBlockState((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), placementBlockState, this);
        }
        return placementBlockState;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(blockState, level, pos, block, fromPos, isMoving);
        ShelfBlock.updateConnectionBlockState((LevelAccessor)level, pos, blockState, this);
    }

    public static void updateConnectionBlockState(LevelAccessor level, BlockPos pos, BlockState blockState, ShelfBlock shelf) {
        BlockState newBlockState = ShelfBlock.getBlockState(level, pos, blockState, shelf);
        if (newBlockState != blockState) {
            level.m_7731_(pos, newBlockState, 3);
        }
    }

    public static BlockState getBlockState(LevelAccessor level, BlockPos pos, BlockState blockState, ShelfBlock shelf) {
        if (blockState.m_61138_(CONNECTION)) {
            Connection connection = ShelfBlock.getConnection(level, pos, blockState, shelf);
            return (BlockState)blockState.m_61124_(CONNECTION, (Comparable)((Object)connection));
        }
        return blockState;
    }

    public static Connection getConnection(LevelAccessor level, BlockPos pos, BlockState blockState, ShelfBlock shelf) {
        Direction facing = ShelfBlock.getFacing((BlockState)blockState);
        Connection connection = blockState.m_61145_(CONNECTION).orElse(Connection.SINGLE);
        BlockPos leftPos = pos.m_121945_(facing.m_122428_());
        BlockPos rightPos = pos.m_121945_(facing.m_122427_());
        BlockState leftBlockState = level.m_8055_(leftPos);
        BlockState rightBlockState = level.m_8055_(rightPos);
        boolean isLeft = ShelfBlock.isSideConnection(leftBlockState, facing, connection, shelf);
        boolean isRight = ShelfBlock.isSideConnection(rightBlockState, facing, connection, shelf);
        if (isLeft && isRight) {
            return Connection.CENTER;
        }
        if (isLeft) {
            return Connection.LEFT;
        }
        if (isRight) {
            return Connection.RIGHT;
        }
        return Connection.SINGLE;
    }

    public static boolean isSideConnection(BlockState side, Direction facing, Connection connection, ShelfBlock shelf) {
        if (!side.m_60713_((Block)shelf)) {
            return false;
        }
        if (ShelfBlock.getFacing((BlockState)side) == facing) {
            return true;
        }
        Connection sideConnection = side.m_61145_(CONNECTION).orElse(Connection.SINGLE);
        return sideConnection == Connection.CENTER;
    }

    public static enum Connection implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right"),
        CENTER("center"),
        SINGLE("single");

        public final String serializedName;

        private Connection(String serializedName) {
            this.serializedName = serializedName;
        }

        public String m_7912_() {
            return this.serializedName;
        }
    }

    public static class Dyeable
    extends ShelfBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            MapColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Override
        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

