/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.particle.AdvancedTerrainParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.TerrainParticleData;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.bluff.EntityBluff;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityEarthSpike
extends EntityGeomancyBase {
    private boolean emerged = false;
    private int damageDelay = -1;
    protected MowzieAnimationController<EntityEarthSpike> controller = new MowzieAnimationController<EntityEarthSpike>(this, "controller", 0, this::predicate, 0.0);
    private static RawAnimation EMERGE = RawAnimation.begin().thenPlay("emerge");

    public EntityEarthSpike(EntityType<? extends EntityMagicEffect> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityEarthSpike(EntityType<? extends EntityMagicEffect> type, Level worldIn, LivingEntity caster, BlockState blockState) {
        super(type, worldIn, caster, blockState, null);
        this.setDeathTime(180);
        this.setTier(EntityGeomancyBase.GeomancyTier.SMALL);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.damageDelay >= 0) {
            --this.damageDelay;
        }
        if (!this.emerged) {
            this.emerged = true;
            this.damageDelay = 2;
            this.m_5496_((SoundEvent)MMSounds.ENTITY_BLUFF_SPIKE_EMERGE.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            if (this.m_9236_().m_5776_()) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 offset = new Vec3(0.6 + (double)this.f_19796_.m_188501_() * 0.2, 0.1, 0.0).m_82524_(this.f_19796_.m_188501_() * (float)Math.PI * 2.0f);
                    Vec3 vel = offset.m_82541_().m_82490_(this.f_19796_.m_188583_() * 0.12).m_82524_(this.f_19796_.m_188501_() * 0.2f - 0.1f).m_82520_(0.0, this.f_19796_.m_188500_() * 0.45 + 0.2, 0.0).m_82549_(this.m_20156_().m_82490_(0.1));
                    AdvancedTerrainParticle.spawnTerrainParticle(this.m_9236_(), (ParticleType<TerrainParticleData>)((ParticleType)ParticleHandler.TERRAIN.get()), this.m_20185_() + offset.f_82479_, this.m_20186_(), this.m_20189_() + offset.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_, 0.0, (double)0.4f + this.f_19796_.m_188583_() * 0.3, 0.94f, 25.0f + this.f_19796_.m_188501_() * 10.0f, this.getBlock(), new ParticleComponent[]{new ParticleComponent.Gravity(1.0f)});
                }
            }
        }
        if (this.damageDelay == 0 && !this.m_9236_().m_5776_()) {
            this.damageDelay = -1;
            List entitiesHit = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.4), e -> e.m_271807_() && e != this.getCaster());
            double damage = 10.0;
            if (this.getCaster() != null && this.getCaster() instanceof EntityBluff) {
                AttributeInstance attrib = this.getCaster().m_21051_(Attributes.f_22281_);
                if (attrib != null) {
                    damage = attrib.m_22135_();
                }
                damage *= ((Double)ConfigHandler.COMMON.MOBS.BLUFF.combatConfig.attackMultiplier.get()).doubleValue();
            }
            for (Entity entity : entitiesHit) {
                if (this.getCaster() instanceof EntityBluff && entity instanceof EntityBluff || entity instanceof ItemEntity) continue;
                entity.m_6469_(this.m_269291_().m_269299_((Entity)this, this.getCaster()), (float)damage);
                float applyKnockbackResistance = 0.0f;
                if (entity instanceof LivingEntity) {
                    applyKnockbackResistance = (float)((LivingEntity)entity).m_21051_(Attributes.f_22278_).m_22135_();
                }
                double y = 0.0;
                if (entity.m_20096_()) {
                    y += 0.15 * (double)(1.0f - applyKnockbackResistance);
                }
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, y, 0.0));
                if (!(entity instanceof ServerPlayer)) continue;
                ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController[]{this.controller});
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.emerged = compound.m_128471_("emerged");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("emerged", this.emerged);
    }

    protected <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(EMERGE);
        return PlayState.CONTINUE;
    }

    @Override
    protected void explode() {
        super.explode();
    }
}

