/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.render;

import com.davenonymous.libnonymous.render.TintedBakedQuad;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class MultiblockBakedModel
implements IDynamicBakedModel {
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final MultiblockBlockModel model;
    private final ItemOverrides overrides;
    private final ItemTransforms itemTransforms;
    private final List<BakedQuad> cache = new ArrayList<BakedQuad>();
    private static Map<MultiblockBlockModel, MultiblockBakedModel> bakeCache = new HashMap<MultiblockBlockModel, MultiblockBakedModel>();
    public static final ResourceLocation PARTICLE_TEXTURE = new ResourceLocation("minecraft", "block/stone");
    public static final Material PARTICLE_MATERIAL = ForgeHooksClient.getBlockMaterial((ResourceLocation)PARTICLE_TEXTURE);

    public static MultiblockBakedModel of(MultiblockBlockModel model) {
        if (!bakeCache.containsKey(model)) {
            bakeCache.put(model, new MultiblockBakedModel(model));
        }
        return bakeCache.get(model);
    }

    private MultiblockBakedModel(MultiblockBlockModel model) {
        this.spriteGetter = material -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(material.m_119193_());
        this.model = model;
        this.overrides = ItemOverrides.f_111734_;
        this.itemTransforms = ItemTransforms.f_111786_;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState inputBlockState, @Nullable Direction pSide, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType layer) {
        if (pSide != null) {
            return Collections.emptyList();
        }
        if (this.cache.isEmpty()) {
            BlockModelShaper shaper = Minecraft.m_91087_().m_91289_().m_110907_();
            for (BlockPos pos : this.model.getRelevantPositions()) {
                BlockState state = this.model.blocks.get(pos);
                BakedModel blockModel = shaper.m_110893_(state);
                ArrayList<Direction> sides = new ArrayList<Direction>(List.of(Direction.values()));
                sides.add(null);
                for (Direction side : sides) {
                    List modelQuads = blockModel.m_213637_(state, side, rand);
                    Transformation translate = new Transformation(new Matrix4f().translate((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()));
                    IQuadTransformer quadTransformer = QuadTransformers.applying((Transformation)translate);
                    List transformedQuads = quadTransformer.process(modelQuads);
                    for (BakedQuad quad : transformedQuads) {
                        this.cache.add(TintedBakedQuad.of(quad, state, pos));
                    }
                }
            }
        }
        return this.cache;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(PARTICLE_MATERIAL);
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public ItemTransforms m_7442_() {
        return this.itemTransforms;
    }
}

