/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentHelper {
    private Map<ResourceLocation, Integer> enchantments;

    private void buildEnchantmentMap(ListTag enchantments) {
        this.enchantments = new HashMap<ResourceLocation, Integer>();
        if (enchantments != null) {
            for (Tag enchantment : enchantments) {
                CompoundTag enchantmentTag;
                if (!(enchantment instanceof CompoundTag) || !(enchantmentTag = (CompoundTag)enchantment).m_128441_("id")) continue;
                ResourceLocation id = new ResourceLocation(enchantmentTag.m_128461_("id"));
                short levelValue = enchantmentTag.m_128448_("lvl");
                this.enchantments.put(id, Integer.valueOf(levelValue));
            }
        }
    }

    public EnchantmentHelper(ListTag enchantments) {
        this.buildEnchantmentMap(enchantments);
    }

    public EnchantmentHelper(ItemStack stack) {
        if (stack.m_41720_() instanceof EnchantedBookItem) {
            this.buildEnchantmentMap(EnchantedBookItem.m_41163_((ItemStack)stack));
            return;
        }
        if (stack.m_41793_()) {
            this.buildEnchantmentMap(stack.m_41785_());
            return;
        }
        this.buildEnchantmentMap(null);
    }

    public boolean hasAny(Enchantment ... enchantments) {
        for (Enchantment enchantment : enchantments) {
            if (!this.has(enchantment)) continue;
            return true;
        }
        return false;
    }

    public boolean has(Enchantment enchantment) {
        ResourceLocation rLoc = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        return this.has(rLoc);
    }

    public boolean has(ResourceLocation enchantment) {
        return this.enchantments.containsKey(enchantment);
    }

    public int getLevel(Enchantment enchantment) {
        ResourceLocation rLoc = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        return this.getLevel(rLoc);
    }

    public int getLevel(ResourceLocation registryName) {
        return this.has(registryName) ? this.enchantments.get(registryName) : 0;
    }

    public static List<ItemStack> getEnchantmentBooks(Enchantment enchantment) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int level = enchantment.m_44702_(); level <= enchantment.m_6586_(); ++level) {
            result.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level)));
        }
        return result;
    }

    public static boolean hasAny(@Nonnull ListTag enchantments, Enchantment ... wanted) {
        HashMap<ResourceLocation, Boolean> enchantmentHash = new HashMap<ResourceLocation, Boolean>();
        for (Tag enchantment : enchantments) {
            CompoundTag enchantmentTag;
            if (!(enchantment instanceof CompoundTag) || !(enchantmentTag = (CompoundTag)enchantment).m_128441_("id")) continue;
            ResourceLocation id = new ResourceLocation(enchantmentTag.m_128461_("id"));
            enchantmentHash.put(id, true);
        }
        for (Enchantment enchantment : wanted) {
            ResourceLocation rLoc = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
            if (!enchantmentHash.containsKey(rLoc)) continue;
            return true;
        }
        return false;
    }

    public static boolean has(@Nonnull ListTag enchantments, @Nonnull Enchantment enchantment) {
        ResourceLocation rLoc = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        return EnchantmentHelper.has(enchantments, rLoc);
    }

    public static boolean has(@Nonnull ListTag enchantments, @Nonnull ResourceLocation wanted) {
        for (Tag enchantment : enchantments) {
            CompoundTag enchantmentTag;
            String id;
            if (!(enchantment instanceof CompoundTag) || !(id = (enchantmentTag = (CompoundTag)enchantment).m_128461_("id")).equals(wanted.toString())) continue;
            return true;
        }
        return false;
    }

    public static int getLevel(@Nonnull ListTag enchantments, @Nonnull Enchantment enchantment) {
        ResourceLocation rLoc = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        return EnchantmentHelper.getLevel(enchantments, rLoc);
    }

    public static int getLevel(@Nonnull ListTag enchantments, @Nonnull ResourceLocation enchantmentId) {
        int level = 0;
        for (Tag enchantment : enchantments) {
            if (!(enchantment instanceof CompoundTag)) continue;
            CompoundTag enchantmentTag = (CompoundTag)enchantment;
            String id = enchantmentTag.m_128461_("id");
            short levelValue = enchantmentTag.m_128448_("lvl");
            if (!id.equals(enchantmentId.toString())) continue;
            level += levelValue;
        }
        return level;
    }
}

