/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.event.ValueChangedEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetSpriteSelect;
import com.davenonymous.libnonymous.helper.RedstoneMode;
import com.davenonymous.libnonymous.helper.Translatable;

public class WidgetRedstoneMode
extends WidgetSpriteSelect<RedstoneMode> {
    public static final Translatable REDSTONE_IGNORE = new Translatable("libnonymous", "button.redstone.tooltip.ignore");
    public static final Translatable REDSTONE_REQUIRED = new Translatable("libnonymous", "button.redstone.tooltip.required");
    public static final Translatable REDSTONE_REJECTED = new Translatable("libnonymous", "button.redstone.tooltip.rejected");

    public WidgetRedstoneMode() {
        this(RedstoneMode.IGNORE_POWER);
    }

    public WidgetRedstoneMode(RedstoneMode initial) {
        this.addChoiceWithSprite(RedstoneMode.IGNORE_POWER, new WidgetSpriteSelect.SpriteData(GUI.tabIcons, 26, 84, 10, 10));
        this.addChoiceWithSprite(RedstoneMode.REQUIRE_POWER, new WidgetSpriteSelect.SpriteData(GUI.tabIcons, 36, 84, 4, 11));
        this.addChoiceWithSprite(RedstoneMode.REJECT_POWER, new WidgetSpriteSelect.SpriteData(GUI.tabIcons, 40, 84, 2, 11));
        this.setValue(initial);
        this.updateToolTips();
        this.addListener(ValueChangedEvent.class, (event, widget) -> {
            this.updateToolTips();
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public void updateToolTips() {
        if (this.getValue() == RedstoneMode.IGNORE_POWER) {
            this.setTooltipLines(REDSTONE_IGNORE);
        } else if (this.getValue() == RedstoneMode.REJECT_POWER) {
            this.setTooltipLines(REDSTONE_REJECTED);
        } else if (this.getValue() == RedstoneMode.REQUIRE_POWER) {
            this.setTooltipLines(REDSTONE_REQUIRED);
        }
    }
}

