/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public final class TurtleUpgradeRecipe
extends CustomRecipe {
    public TurtleUpgradeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean m_8004_(int x, int y) {
        return x >= 3 && y >= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ((TurtleItem)ModRegistry.Items.TURTLE_NORMAL.get()).create(-1, null, -1, null, null, 0, null);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        return !this.assemble(inventory, world.m_9598_()).m_41619_();
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess registryAccess) {
        ItemStack leftItem = ItemStack.f_41583_;
        ItemStack turtle = ItemStack.f_41583_;
        ItemStack rightItem = ItemStack.f_41583_;
        for (int y = 0; y < inventory.m_39346_(); ++y) {
            if (turtle.m_41619_()) {
                boolean finishedRow = false;
                for (int x = 0; x < inventory.m_39347_(); ++x) {
                    ItemStack item = inventory.m_8020_(x + y * inventory.m_39347_());
                    if (!item.m_41619_()) {
                        if (finishedRow) {
                            return ItemStack.f_41583_;
                        }
                        if (item.m_41720_() instanceof TurtleItem) {
                            if (turtle.m_41619_()) {
                                turtle = item;
                                continue;
                            }
                            return ItemStack.f_41583_;
                        }
                        if (turtle.m_41619_() && leftItem.m_41619_()) {
                            leftItem = item;
                            continue;
                        }
                        if (!turtle.m_41619_() && rightItem.m_41619_()) {
                            rightItem = item;
                            continue;
                        }
                        return ItemStack.f_41583_;
                    }
                    if (leftItem.m_41619_() && turtle.m_41619_()) continue;
                    finishedRow = true;
                }
                if (!turtle.m_41619_() || leftItem.m_41619_() && rightItem.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            for (int x = 0; x < inventory.m_39347_(); ++x) {
                ItemStack item = inventory.m_8020_(x + y * inventory.m_39347_());
                if (item.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        if (turtle.m_41619_() || leftItem.m_41619_() && rightItem.m_41619_()) {
            return ItemStack.f_41583_;
        }
        TurtleItem itemTurtle = (TurtleItem)turtle.m_41720_();
        UpgradeData[] upgrades = new UpgradeData[]{itemTurtle.getUpgradeWithData(turtle, TurtleSide.LEFT), itemTurtle.getUpgradeWithData(turtle, TurtleSide.RIGHT)};
        ItemStack[] items = new ItemStack[]{rightItem, leftItem};
        for (int i = 0; i < 2; ++i) {
            if (items[i].m_41619_()) continue;
            UpgradeData<ITurtleUpgrade> itemUpgrade = TurtleUpgrades.instance().get(items[i]);
            if (itemUpgrade == null || upgrades[i] != null) {
                return ItemStack.f_41583_;
            }
            upgrades[i] = itemUpgrade;
        }
        int computerID = itemTurtle.getComputerID(turtle);
        String label = itemTurtle.getLabel(turtle);
        int fuelLevel = itemTurtle.getFuelLevel(turtle);
        int colour = itemTurtle.getColour(turtle);
        ResourceLocation overlay = itemTurtle.getOverlay(turtle);
        return itemTurtle.create(computerID, label, colour, upgrades[0], upgrades[1], fuelLevel, overlay);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE_UPGRADE.get();
    }
}

