/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import com.mojang.serialization.DynamicOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalBlockPosition;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.TunnelPosition;
import dev.compactmods.machines.api.tunnels.capability.CapabilityTunnel;
import dev.compactmods.machines.api.tunnels.lifecycle.InstancedTunnel;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelInstance;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelTeardownHandler;
import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.machine.graph.legacy.LegacyMachineLocationsGraph;
import dev.compactmods.machines.tunnel.BaseTunnelWallData;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import dev.compactmods.machines.tunnel.Tunnels;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import dev.compactmods.machines.wall.Walls;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TunnelWallEntity
extends BlockEntity {
    private static final String NBT_LEGACY_MACHINE_KEY = "machine";
    @Deprecated(forRemoval=true)
    private int legacyMachineId = -1;
    private LevelBlockPosition connectedMachine;
    private TunnelDefinition tunnelType;
    @javax.annotation.Nullable
    private TunnelInstance tunnel;

    public TunnelWallEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Tunnels.TUNNEL_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        BaseTunnelWallData baseData = (BaseTunnelWallData)BaseTunnelWallData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).getOrThrow(true, arg_0 -> ((Logger)CompactMachines.LOGGER).fatal(arg_0));
        this.connectedMachine = baseData.connection();
        this.tunnelType = baseData.tunnel();
        try {
            Object object = this.tunnelType;
            if (object instanceof InstancedTunnel) {
                InstancedTunnel it = (InstancedTunnel)object;
                this.tunnel = it.newInstance(this.f_58858_, this.getTunnelSide());
            }
            if ((object = this.tunnel) instanceof INBTSerializable) {
                INBTSerializable persist = (INBTSerializable)object;
                if (nbt.m_128441_("tunnel_data")) {
                    Tag data = nbt.m_128423_("tunnel_data");
                    persist.deserializeNBT(data);
                }
            }
        }
        catch (Exception ex) {
            CompactMachines.LOGGER.error("Error loading tunnel persistent data at {}; this is likely a cross-mod issue!", (Object)this.f_58858_, (Object)ex);
        }
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.legacyMachineId > -1) {
                try {
                    this.upgradeLegacyData();
                }
                catch (MissingDimensionException e) {
                    CompactMachines.LOGGER.error(CompactMachines.CONN_MARKER, "Failed to load legacy location info for tunnel conversion at: {}; removing the tunnel instance.", (Object)this.f_58858_);
                    this.tunnelType = (TunnelDefinition)Tunnels.UNKNOWN.get();
                }
            }
            if (this.tunnelType != null && this.tunnelType.equals(Tunnels.UNKNOWN.get())) {
                CompactMachines.LOGGER.warn("Removing unknown tunnel type at {}", (Object)this.f_58858_.m_123344_());
                sl.m_7731_(this.f_58858_, ((Block)Walls.BLOCK_SOLID_WALL.get()).m_49966_(), 3);
            }
        }
    }

    private void upgradeLegacyData() throws MissingDimensionException {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return;
        }
        if (this.legacyMachineId == -1) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            LegacyMachineLocationsGraph leg = LegacyMachineLocationsGraph.get(sl.m_7654_());
            if (leg != null) {
                this.connectedMachine = leg.getLocation(this.legacyMachineId);
            } else {
                CompactMachines.LOGGER.error(CompactMachines.CONN_MARKER, "Failed to load legacy location info for tunnel conversion at: {}; removing the tunnel instance.", (Object)this.f_58858_);
                this.tunnelType = (TunnelDefinition)Tunnels.UNKNOWN.get();
            }
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128359_("tunnel_type", Tunnels.getRegistryId(this.tunnelType).toString());
        compound.m_128365_("connection", (Tag)this.connectedMachine.serializeNBT());
        TunnelInstance tunnelInstance = this.tunnel;
        if (tunnelInstance instanceof INBTSerializable) {
            INBTSerializable persist = (INBTSerializable)tunnelInstance;
            Tag data = persist.serializeNBT();
            compound.m_128365_("tunnel_data", data);
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128359_("tunnel_type", Tunnels.getRegistryId(this.tunnelType).toString());
        nbt.m_128365_("connection", (Tag)this.connectedMachine.serializeNBT());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("tunnel_type")) {
            ResourceLocation id = new ResourceLocation(tag.m_128461_("tunnel_type"));
            this.tunnelType = Tunnels.getDefinition(id);
        }
        if (tag.m_128441_("connection")) {
            this.connectedMachine = LevelBlockPosition.fromNBT(tag.m_128469_("connection"));
        }
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getTunnelCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction outerSide) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return LazyOptional.empty();
        }
        if (outerSide != null && outerSide != this.getConnectedSide()) {
            return LazyOptional.empty();
        }
        TunnelDefinition tunnelDefinition = this.tunnelType;
        if (tunnelDefinition instanceof CapabilityTunnel) {
            CapabilityTunnel c = (CapabilityTunnel)((Object)tunnelDefinition);
            return c.getCapability(cap, this.tunnel);
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return super.getCapability(cap, side);
        }
        if (side != null && side != this.getTunnelSide()) {
            return super.getCapability(cap, side);
        }
        TunnelDefinition tunnelDefinition = this.tunnelType;
        if (tunnelDefinition instanceof CapabilityTunnel) {
            CapabilityTunnel c = (CapabilityTunnel)((Object)tunnelDefinition);
            return c.getCapability(cap, this.tunnel);
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public IDimensionalBlockPosition getConnectedPosition() {
        return this.connectedMachine;
    }

    public Direction getTunnelSide() {
        BlockState state = this.m_58900_();
        return (Direction)state.m_61143_((Property)TunnelWallBlock.TUNNEL_SIDE);
    }

    public Direction getConnectedSide() {
        BlockState blockState = this.m_58900_();
        return (Direction)blockState.m_61143_((Property)TunnelWallBlock.CONNECTED_SIDE);
    }

    public void setTunnelType(TunnelDefinition type) {
        Level level;
        if (type == this.tunnelType) {
            return;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !((level = this.f_58857_) instanceof ServerLevel)) {
            this.tunnelType = type;
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        TunnelPosition p = new TunnelPosition(sl, this.f_58858_, this.getTunnelSide());
        TunnelDefinition tunnelDefinition = this.tunnelType;
        if (tunnelDefinition instanceof TunnelTeardownHandler) {
            TunnelTeardownHandler teardown = (TunnelTeardownHandler)((Object)tunnelDefinition);
            teardown.onRemoved(p, this.tunnel);
        }
        this.tunnelType = type;
        if (type instanceof InstancedTunnel) {
            InstancedTunnel it = (InstancedTunnel)((Object)type);
            this.tunnel = it.newInstance(p.pos(), p.side());
        }
        this.m_6596_();
    }

    public TunnelDefinition getTunnelType() {
        return this.tunnelType;
    }

    public void setConnectedTo(IDimensionalBlockPosition machine, Direction side) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.connectedMachine = new LevelBlockPosition(machine);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            TunnelConnectionGraph graph = TunnelConnectionGraph.forRoom(sl, new ChunkPos(this.f_58858_));
            graph.rebind(this.f_58858_, machine, side);
        }
    }

    @javax.annotation.Nullable
    public <U extends TunnelInstance> U getTunnel() {
        try {
            return (U)this.tunnel;
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    public void setInstance(TunnelInstance newTunn) {
        this.tunnel = newTunn;
        this.m_6596_();
    }

    @Nullable
    public TunnelPosition tunnelPosition() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return new TunnelPosition(sl, this.f_58858_, this.getConnectedSide());
        }
        return null;
    }
}

