/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.location;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.codec.CodecExtensions;
import dev.compactmods.machines.api.location.IDimensionalBlockPosition;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.logging.log4j.Logger;

public class LevelBlockPosition
implements INBTSerializable<CompoundTag>,
IDimensionalBlockPosition {
    private ResourceKey<Level> dimension;
    private Vec3 position;
    private Vec2 rotation;
    public static final Codec<LevelBlockPosition> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dim").forGetter(LevelBlockPosition::getDimension), (App)CodecExtensions.VECTOR3D.fieldOf("pos").forGetter(LevelBlockPosition::getExactPosition), (App)CodecExtensions.VECTOR2.optionalFieldOf("rot", (Object)Vec2.f_82462_).forGetter(x -> x.rotation)).apply((Applicative)i, LevelBlockPosition::new));

    private LevelBlockPosition() {
    }

    public LevelBlockPosition(IDimensionalBlockPosition base) {
        this.dimension = base.dimensionKey();
        this.position = base.getExactPosition();
        this.rotation = Vec2.f_82462_;
    }

    public LevelBlockPosition(ResourceKey<Level> world, BlockPos positionBlock) {
        this(world, Vec3.f_82478_, Vec2.f_82462_);
        this.position = new Vec3((double)positionBlock.m_123341_(), (double)positionBlock.m_123342_(), (double)positionBlock.m_123343_());
        this.rotation = Vec2.f_82462_;
    }

    public LevelBlockPosition(ResourceKey<Level> world, Vec3 positionBlock) {
        this(world, positionBlock, Vec2.f_82462_);
        this.dimension = world;
        this.rotation = Vec2.f_82462_;
    }

    public LevelBlockPosition(ResourceKey<Level> dim, Vec3 pos, Vec2 rotation) {
        this.dimension = dim;
        this.position = pos;
        this.rotation = rotation;
    }

    public static LevelBlockPosition fromEntity(LivingEntity entity) {
        return new LevelBlockPosition((ResourceKey<Level>)entity.m_9236_().m_46472_(), entity.m_20182_(), entity.m_20155_());
    }

    @Override
    public ServerLevel level(@Nonnull MinecraftServer server) {
        return server.m_129880_(this.dimension);
    }

    @Override
    public BlockState state(MinecraftServer server) {
        ServerLevel level = this.level(server);
        return level.m_8055_(this.getBlockPosition());
    }

    @Override
    public IDimensionalBlockPosition relative(Direction direction) {
        return new LevelBlockPosition(this.dimension, this.position.m_82520_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_()));
    }

    @Override
    public boolean isLoaded(MinecraftServer server) {
        ServerLevel level = this.level(server);
        return level.m_46749_(this.getBlockPosition());
    }

    public static LevelBlockPosition fromNBT(CompoundTag nbt) {
        LevelBlockPosition dp = new LevelBlockPosition();
        dp.deserializeNBT(nbt);
        return dp;
    }

    public CompoundTag serializeNBT() {
        if (this.rotation == null) {
            this.rotation = Vec2.f_82462_;
        }
        DataResult nbt = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this);
        return nbt.result().orElse(null);
    }

    public void deserializeNBT(CompoundTag nbt) {
        Optional dimensionalPosition = CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
        dimensionalPosition.ifPresent(dp -> {
            this.dimension = dp.dimension;
            this.position = dp.position;
            this.rotation = dp.rotation;
        });
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public Optional<Vec2> getRotation() {
        return Optional.of(this.rotation);
    }

    @Override
    public BlockPos getBlockPosition() {
        return new BlockPos((int)this.position.f_82479_, (int)this.position.f_82480_, (int)this.position.f_82481_);
    }

    @Override
    public Vec3 getExactPosition() {
        return this.position;
    }

    @Override
    public ResourceKey<Level> dimensionKey() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LevelBlockPosition that = (LevelBlockPosition)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.position.equals((Object)that.position)) {
            return false;
        }
        return this.rotation.m_82476_(that.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.position, this.rotation);
    }

    public String toString() {
        return "DimensionalPosition{d=" + this.dimension + ", p=" + this.position + ", r=" + this.rotation + "}";
    }
}

