/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.dimension;

import dev.compactmods.machines.api.dimension.CompactDimension;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;

public class WorldBorderFixer {
    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(WorldBorderFixer::onWorldLoaded);
        MinecraftForge.EVENT_BUS.addListener(WorldBorderFixer::onPlayerLogin);
        MinecraftForge.EVENT_BUS.addListener(WorldBorderFixer::onPlayerDimChange);
    }

    private static void onWorldLoaded(LevelEvent.Load evt) {
        ServerLevel compactDim;
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof ServerLevel && (compactDim = (ServerLevel)levelAccessor).m_46472_().equals(CompactDimension.LEVEL_KEY)) {
            WorldBorderFixer.sendWorldBorderListenerOverrides(compactDim.m_7654_(), compactDim);
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        ServerPlayer sp;
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer && CompactDimension.isLevelCompact((sp = (ServerPlayer)player).m_9236_())) {
            WorldBorderFixer.sendClientWorldBorderFix(sp);
        }
    }

    private static void onPlayerDimChange(PlayerEvent.PlayerChangedDimensionEvent evt) {
        Player player;
        if (evt.getTo().equals(CompactDimension.LEVEL_KEY) && (player = evt.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            WorldBorderFixer.sendClientWorldBorderFix(sp);
        }
    }

    private static void sendWorldBorderListenerOverrides(MinecraftServer serv, ServerLevel compactDim) {
        WorldBorder owBorder = serv.m_129783_().m_6857_();
        WorldBorder cwBorder = compactDim.m_6857_();
        Set listeners = owBorder.f_61905_.stream().filter(border -> border instanceof BorderChangeListener.DelegateBorderChangeListener).map(BorderChangeListener.DelegateBorderChangeListener.class::cast).filter(list -> list.f_61864_ == cwBorder).collect(Collectors.toSet());
        for (BorderChangeListener.DelegateBorderChangeListener listener : listeners) {
            owBorder.m_156096_((BorderChangeListener)listener);
        }
        cwBorder.m_61949_(0.0, 0.0);
        cwBorder.m_61917_(5.9999968E7);
        serv.m_6846_().m_11270_((Packet)new ClientboundSetBorderSizePacket(cwBorder), compactDim.m_46472_());
    }

    private static void sendClientWorldBorderFix(ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)new ClientboundInitializeBorderPacket(new WorldBorder()));
    }
}

