/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.jade.providers.server;

import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.tunnel.TunnelItem;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class CompactMachineComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final CompactMachineComponentProvider INSTANCE = new CompactMachineComponentProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        CompactMachineBlockEntity machine = (CompactMachineBlockEntity)accessor.getBlockEntity();
        machine.getConnectedRoom().ifPresent(room -> {
            ServerLevel compactDim = accessor.getLevel().m_7654_().m_129880_(CompactDimension.LEVEL_KEY);
            TunnelConnectionGraph graph = TunnelConnectionGraph.forRoom(compactDim, room);
            Stream<TunnelDefinition> attachedTunnelsStream = graph.getTypesForSide(machine.getLevelPosition(), accessor.getSide());
            ItemStack[] itemStackArray = (ItemStack[])attachedTunnelsStream.map(TunnelItem::createStack).toArray(ItemStack[]::new);
            ListTag attachedTunnels = new ListTag();
            for (ItemStack itemStack : itemStackArray) {
                CompoundTag tag = itemStack.m_41739_(new CompoundTag());
                attachedTunnels.add((Object)tag);
            }
            data.m_128365_("attached_tunnels", (Tag)attachedTunnels);
        });
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("compactmachines", "machine_tunnels");
    }
}

