/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.api.tunnels.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.recipe.TunnelRecipeHelper;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class TunnelRecipeBuilder {
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;
    private int count;
    private ResourceLocation tunnelType;

    private TunnelRecipeBuilder(RegistryObject<TunnelDefinition> definition, int count) {
        this.tunnelType = definition.getId();
        this.count = count;
    }

    public static TunnelRecipeBuilder tunnel(RegistryObject<TunnelDefinition> definition) {
        return new TunnelRecipeBuilder(definition, 1);
    }

    public static TunnelRecipeBuilder tunnel(RegistryObject<TunnelDefinition> definition, int count) {
        return new TunnelRecipeBuilder(definition, count);
    }

    public TunnelRecipeBuilder setType(ResourceLocation id) {
        this.tunnelType = id;
        return this;
    }

    public TunnelRecipeBuilder requires(ItemLike item) {
        return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public TunnelRecipeBuilder requires(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public TunnelRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance crit) {
        this.advancement.m_138386_(criterionName, crit);
        return this;
    }

    public TunnelRecipeBuilder group(String groupName) {
        this.group = groupName;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.ensureValid(this.tunnelType);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)TunnelRecipeHelper.getRecipeId(this.tunnelType))).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.tunnelType)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(this.tunnelType, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new ResourceLocation(this.tunnelType.m_135827_(), "recipes/" + this.tunnelType.m_135815_())));
    }

    private void ensureValid(ResourceLocation recipeId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation tunnelType;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation tunnelType, int count, String group, List<Ingredient> ingredients, Advancement.Builder adv, ResourceLocation advId) {
            this.tunnelType = tunnelType;
            this.count = count;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = adv;
            this.advancementId = advId;
        }

        public void m_7917_(JsonObject output) {
            if (!this.group.isEmpty()) {
                output.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            output.add("ingredients", (JsonElement)jsonarray);
            JsonObject result = new JsonObject();
            result.addProperty("item", TunnelDefinition.TUNNEL_ID.toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            JsonObject definition = new JsonObject();
            definition.addProperty("id", this.tunnelType.toString());
            JsonObject nbt = new JsonObject();
            nbt.add("definition", (JsonElement)definition);
            result.add("nbt", (JsonElement)nbt);
            output.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return TunnelRecipeHelper.getRecipeId(this.tunnelType);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

