/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.api.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.compactmods.machines.api.codec.DoubleStreamExtensions;
import java.util.UUID;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class CodecExtensions {
    public static final Codec<UUID> UUID_CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)UUID.fromString(s));
        }
        catch (Exception ex) {
            return DataResult.error(() -> "Not a valid UUID: " + s + " (" + ex.getMessage() + ")");
        }
    }, UUID::toString).stable();
    public static final Codec<Vec3> VECTOR3D = DoubleStreamExtensions.CODEC.comapFlatMap(i -> DoubleStreamExtensions.fixedDoubleSize(i, 3).map(out -> new Vec3(out[0], out[1], out[2])), vec -> DoubleStream.of(vec.f_82479_, vec.f_82480_, vec.f_82481_));
    public static final Codec<Vec2> VECTOR2 = DoubleStreamExtensions.CODEC.comapFlatMap(i -> DoubleStreamExtensions.fixedDoubleSize(i, 2).map(out -> new Vec2((float)out[0], (float)out[1])), vec -> DoubleStream.of(vec.f_82470_, vec.f_82471_));
    public static final Codec<ChunkPos> CHUNKPOS = Codec.INT_STREAM.comapFlatMap(i -> Util.m_137539_((IntStream)i, (int)2).map(arr -> new ChunkPos(arr[0], arr[1])), pos -> IntStream.of(pos.f_45578_, pos.f_45579_));
}

