/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import vazkii.botania.common.block.block_entity.corporea.CorporeaRetainerBlockEntity;

public class InterceptorTest {
    private static final String TEMPLATE = "botania:block/interceptor";
    private static final BlockPos APPLE_BUTTON_JEANS = new BlockPos(6, 6, 4);
    private static final BlockPos BOOTS_WITH_THE_FUR = new BlockPos(4, 6, 4);
    private static final BlockPos WILDCARD_RETAINER = new BlockPos(6, 5, 7);
    private static final BlockPos BOOTS_RETAINER = new BlockPos(4, 5, 7);

    @GameTest(template="botania:block/interceptor")
    public void testAppleRequest(GameTestHelper helper) {
        helper.m_177385_(APPLE_BUTTON_JEANS);
        helper.m_177425_().m_177546_(1, () -> {
            InterceptorTest.assertHasPendingRequest(helper, WILDCARD_RETAINER);
            InterceptorTest.assertHasNoPendingRequest(helper, BOOTS_RETAINER);
        }).m_177543_();
    }

    @GameTest(template="botania:block/interceptor")
    public void testBootsRequest(GameTestHelper helper) {
        helper.m_177385_(BOOTS_WITH_THE_FUR);
        helper.m_177425_().m_177546_(1, () -> {
            InterceptorTest.assertHasPendingRequest(helper, WILDCARD_RETAINER);
            InterceptorTest.assertHasPendingRequest(helper, BOOTS_RETAINER);
        }).m_177543_();
    }

    private static void assertHasPendingRequest(GameTestHelper helper, BlockPos retainerPos) {
        InterceptorTest.assertHasPendingRequest(helper, retainerPos, false);
    }

    private static void assertHasPendingRequest(GameTestHelper helper, BlockPos retainerPos, boolean invert) {
        CorporeaRetainerBlockEntity retainer = (CorporeaRetainerBlockEntity)helper.m_177347_(retainerPos);
        if (retainer == null) {
            throw new GameTestAssertPosException("Expected corporea retainer", helper.m_177449_(retainerPos), retainerPos, helper.m_177436_());
        }
        if (!retainer.hasPendingRequest() ^ invert) {
            throw new GameTestAssertPosException("Expected corporea retainer to " + (invert ? "not " : "") + "have a pending request", helper.m_177449_(retainerPos), retainerPos, helper.m_177436_());
        }
    }

    private static void assertHasNoPendingRequest(GameTestHelper helper, BlockPos retainerPos) {
        InterceptorTest.assertHasPendingRequest(helper, retainerPos, true);
    }
}

