/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import java.util.List;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.routing.ExitRoute;
import net.minecraft.entity.player.EntityPlayer;

public class StatUpdate
extends CoordinatesPacket {
    private CoreRoutedPipe pipe;
    private int stat_session_sent;
    private int stat_session_recieved;
    private int stat_session_relayed;
    private long stat_lifetime_sent;
    private long stat_lifetime_recieved;
    private long stat_lifetime_relayed;
    private int server_routing_table_size;

    public StatUpdate(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new StatUpdate(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.field_70170_p);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe cPipe = (CoreRoutedPipe)pipe.pipe;
        cPipe.stat_session_sent = this.stat_session_sent;
        cPipe.stat_session_recieved = this.stat_session_recieved;
        cPipe.stat_session_relayed = this.stat_session_relayed;
        cPipe.stat_lifetime_sent = this.stat_lifetime_sent;
        cPipe.stat_lifetime_recieved = this.stat_lifetime_recieved;
        cPipe.stat_lifetime_relayed = this.stat_lifetime_relayed;
        cPipe.server_routing_table_size = this.server_routing_table_size;
    }

    private void initData() {
        this.setPosX(this.pipe.getX());
        this.setPosY(this.pipe.getY());
        this.setPosZ(this.pipe.getZ());
        this.stat_session_sent = this.pipe.stat_session_sent;
        this.stat_session_recieved = this.pipe.stat_session_recieved;
        this.stat_session_relayed = this.pipe.stat_session_relayed;
        this.stat_lifetime_sent = this.pipe.stat_lifetime_sent;
        this.stat_lifetime_recieved = this.pipe.stat_lifetime_recieved;
        this.stat_lifetime_relayed = this.pipe.stat_lifetime_relayed;
        int numentries = 0;
        for (List<ExitRoute> route : this.pipe.getRouter().getRouteTable()) {
            if (route == null || route.isEmpty()) continue;
            ++numentries;
        }
        this.server_routing_table_size = numentries;
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        this.initData();
        super.writeData(data);
        data.writeInt(this.stat_session_sent);
        data.writeInt(this.stat_session_recieved);
        data.writeInt(this.stat_session_relayed);
        data.writeLong(this.stat_lifetime_sent);
        data.writeLong(this.stat_lifetime_recieved);
        data.writeLong(this.stat_lifetime_relayed);
        data.writeInt(this.server_routing_table_size);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.stat_session_sent = data.readInt();
        this.stat_session_recieved = data.readInt();
        this.stat_session_relayed = data.readInt();
        this.stat_lifetime_sent = data.readLong();
        this.stat_lifetime_recieved = data.readLong();
        this.stat_lifetime_relayed = data.readLong();
        this.server_routing_table_size = data.readInt();
    }

    public StatUpdate setPipe(CoreRoutedPipe pipe) {
        this.pipe = pipe;
        return this;
    }
}

