/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.TextField;
import codechicken.nei.config.Option;
import java.util.List;

public class OptionTextField
extends Option {
    protected final TextField textField = new TextField("test"){
        {
            this.h = 20;
        }

        @Override
        public void onTextChange(String oldText) {
            if (this.focused() && OptionTextField.this.isValidValue(this.text()) && (!OptionTextField.this.defaulting() || !this.text().equals(OptionTextField.this.getTag().getValue()))) {
                OptionTextField.this.getTag().setValue(this.text());
            }
        }

        @Override
        public void setFocus(boolean focus) {
            if (!focus && !OptionTextField.this.isValidValue(this.text())) {
                this.setText(OptionTextField.this.renderTag().getValue());
            }
            super.setFocus(focus);
        }
    };

    public OptionTextField(String name) {
        super(name);
    }

    @Override
    public void update() {
        this.textField.update();
        if (!this.textField.focused()) {
            this.textField.setText(this.renderTag().getValue());
        }
    }

    public String getPrefix() {
        return this.translateN(this.name, new Object[0]);
    }

    protected int getMaxInputWidth() {
        return this.slot.slotWidth();
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        GuiDraw.drawString((String)this.getPrefix(), (int)10, (int)6, (int)-1);
        this.textField.w = Math.max(60, Math.min(this.getMaxInputWidth(), this.slot.slotWidth() - GuiDraw.getStringWidth((String)this.getPrefix())) - 16);
        this.textField.x = this.slot.slotWidth() - this.textField.w;
        this.textField.draw(mousex, mousey);
    }

    @Override
    public void keyTyped(char c, int keycode) {
        this.textField.handleKeyPress(keycode, c);
    }

    @Override
    public void mouseClicked(int mousex, int mousey, int button) {
        if (this.textField.contains(mousex, mousey)) {
            this.textField.handleClick(mousex, mousey, button);
        }
    }

    @Override
    public void onMouseClicked(int mousex, int mousey, int button) {
        this.textField.onGuiClick(mousex, mousey);
    }

    @Override
    public List<String> handleTooltip(int mousex, int mousey, List<String> currenttip) {
        String tip;
        if (new Rectangle4i(10, 0, this.textField.x - 10, 20).contains(mousex, mousey) && !(tip = this.translateN(this.name + ".tip", new Object[0])).equals(this.namespaced(this.name + ".tip"))) {
            currenttip.add(tip);
        }
        return currenttip;
    }

    public boolean isValidInput(String s) {
        return true;
    }

    public boolean isValidValue(String s) {
        return true;
    }
}

