/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.ItemStackMap;
import codechicken.nei.NEIActions;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PlayerSave;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NEIServerConfig {
    private static MinecraftServer server;
    public static Logger logger;
    public static File saveDir;
    public static ConfigFile serverConfig;
    public static Map<Integer, NBTTagCompound> dimTags;
    public static HashMap<String, PlayerSave> playerSaves;
    public static ItemStackMap<Set<String>> bannedItems;

    public static void load(World world) {
        if (MinecraftServer.func_71276_C() != server) {
            logger.debug("Loading NEI Server");
            server = MinecraftServer.func_71276_C();
            saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "NEI");
            dimTags.clear();
            NEIServerConfig.loadConfig();
            NEIServerConfig.loadBannedItems();
        }
        NEIServerConfig.loadWorld(world);
    }

    public static File getSaveDir(World world) {
        return new File(CommonUtils.getSaveLocation((World)world), "NEI");
    }

    private static void loadWorld(World world) {
        try {
            File file = new File(NEIServerConfig.getSaveDir(world), "world.dat");
            NBTTagCompound tag = NEIServerUtils.readNBT(file);
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            dimTags.put(CommonUtils.getDimension((World)world), tag);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadConfig() {
        File file = new File(saveDir, "server.cfg");
        serverConfig = new ConfigFile(file);
        serverConfig.setNewLineMode(1);
        serverConfig.getTag("permissions").useBraces();
        serverConfig.getTag("permissions").setComment("List of players who can use these features.\nEg. time=CodeChicken, Friend1");
        NEIServerConfig.setDefaultFeature("time", new String[0]);
        NEIServerConfig.setDefaultFeature("rain", new String[0]);
        NEIServerConfig.setDefaultFeature("heal", new String[0]);
        NEIServerConfig.setDefaultFeature("magnet", new String[0]);
        NEIServerConfig.setDefaultFeature("creative", new String[0]);
        NEIServerConfig.setDefaultFeature("creative+", new String[0]);
        NEIServerConfig.setDefaultFeature("adventure", new String[0]);
        NEIServerConfig.setDefaultFeature("enchant", new String[0]);
        NEIServerConfig.setDefaultFeature("potion", new String[0]);
        NEIServerConfig.setDefaultFeature("save-state", new String[0]);
        NEIServerConfig.setDefaultFeature("item", new String[0]);
        NEIServerConfig.setDefaultFeature("delete", new String[0]);
        NEIServerConfig.setDefaultFeature("notify-item", "CONSOLE, OP");
    }

    private static void setDefaultFeature(String featurename, String ... names) {
        if (names.length == 0) {
            names = new String[]{"OP"};
        }
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (i >= 1) {
                list.append(", ");
            }
            list.append(names[i]);
        }
        serverConfig.getTag("permissions." + featurename).setDefaultValue(list.toString());
    }

    private static void saveWorld(int dim) {
        try {
            File saveDir = NEIServerConfig.getSaveDir((World)DimensionManager.getWorld((int)dim));
            if (!saveDir.isDirectory()) {
                FileUtils.forceMkdir((File)saveDir);
            }
            File file = new File(saveDir, "world.dat");
            NEIServerUtils.writeNBT(dimTags.get(dim), file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean canPlayerPerformAction(String playername, String name) {
        return NEIServerConfig.isPlayerInList(playername, NEIServerConfig.getPlayerList("permissions." + NEIActions.base(name)), true);
    }

    public static boolean isPlayerInList(String playername, Set<String> list, boolean allowCards) {
        if (playername.equals("CONSOLE")) {
            return list.contains(playername);
        }
        playername = playername.toLowerCase();
        if (allowCards) {
            if (list.contains("ALL")) {
                return true;
            }
            if ((ServerUtils.isPlayerOP((String)playername) || ServerUtils.isPlayerOwner((String)playername)) && list.contains("OP")) {
                return true;
            }
        }
        return list.contains(playername);
    }

    public static boolean isActionDisabled(int dim, String name) {
        return dimTags.get(dim).func_74767_n("disabled" + name);
    }

    public static void disableAction(int dim, String name, boolean disable) {
        dimTags.get(dim).func_74757_a("disabled" + name, disable);
        NEISPH.sendActionDisabled(dim, name, disable);
        NEIServerConfig.saveWorld(dim);
    }

    public static HashSet<String> getPlayerList(String tag) {
        String[] list = serverConfig.getTag(tag).getValue("").replace(" ", "").split(",");
        return new HashSet<String>(Arrays.asList(list));
    }

    public static void addPlayerToList(String playername, String tag) {
        HashSet<String> list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.add(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    public static void remPlayerFromList(String playername, String tag) {
        HashSet<String> list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.remove(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    private static void savePlayerList(String tag, Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(iterator.next());
            ++i;
        }
        serverConfig.getTag(tag).setValue(sb.toString());
    }

    private static void loadBannedItems() {
        bannedItems.clear();
        File file = new File(saveDir, "banneditems.cfg");
        if (!file.exists()) {
            bannedItems.put(new ItemStack(Blocks.field_150483_bI), new HashSet<String>(Collections.singletonList("NONE")));
            NEIServerConfig.saveBannedItems();
            return;
        }
        try {
            FileReader r = new FileReader(file);
            int line = 0;
            for (String s : IOUtils.readLines((Reader)r)) {
                if (s.charAt(0) == '#' || s.trim().isEmpty()) continue;
                int delim = s.lastIndexOf(61);
                if (delim < 0) {
                    logger.error("line " + line + ": Missing =");
                    continue;
                }
                try {
                    NBTTagCompound key = (NBTTagCompound)JsonToNBT.func_150315_a((String)s.substring(0, delim));
                    HashSet<String> values = new HashSet<String>();
                    for (String s2 : s.substring(delim + 1).split(",")) {
                        values.add(s2.trim());
                    }
                    bannedItems.put(InventoryUtils.loadPersistant((NBTTagCompound)key), values);
                }
                catch (Exception e) {
                    logger.error("line " + line + ": " + e.getMessage());
                }
            }
            r.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveBannedItems() {
        File file = new File(saveDir, "banneditems.cfg");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter p = new PrintWriter(file);
            p.println("#Saved in this format for external editing. The format isn't that hard to figure out. If you think you're up to it, modify it here!");
            for (ItemStackMap.Entry<Set<String>> entry : bannedItems.entries()) {
                NBTTagCompound key = InventoryUtils.savePersistant((ItemStack)entry.key, (NBTTagCompound)new NBTTagCompound());
                key.func_82580_o("Count");
                if (key.func_74771_c("Damage") == 0) {
                    key.func_82580_o("Damage");
                }
                p.print(key.toString());
                p.print("=[");
                int i = 0;
                for (String s : (Set)entry.value) {
                    if (i++ != 0) {
                        p.print(", ");
                    }
                    p.print(s);
                }
                p.println("]");
            }
            p.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PlayerSave forPlayer(String username) {
        return playerSaves.get(username);
    }

    public static void loadPlayer(EntityPlayer player) {
        logger.debug("Loading Player: " + player.func_146103_bH().getName());
        playerSaves.put(player.func_70005_c_(), new PlayerSave(player.func_70005_c_(), new File(saveDir, "players")));
    }

    public static void unloadPlayer(EntityPlayer player) {
        logger.debug("Unloading Player: " + player.func_70005_c_());
        PlayerSave playerSave = playerSaves.remove(player.func_70005_c_());
        if (playerSave != null) {
            playerSave.save();
        }
    }

    public static boolean authenticatePacket(EntityPlayerMP sender, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "item");
            }
            case 4: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "delete");
            }
            case 6: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "magnet");
            }
            case 7: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "time");
            }
            case 8: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "heal");
            }
            case 9: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "rain");
            }
            case 14: 
            case 23: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "creative+");
            }
            case 21: 
            case 22: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "enchant");
            }
            case 24: {
                return NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), "potion");
            }
        }
        return true;
    }

    static {
        logger = LogManager.getLogger((String)"NotEnoughItems");
        dimTags = new HashMap<Integer, NBTTagCompound>();
        playerSaves = new HashMap();
        bannedItems = new ItemStackMap();
    }
}

