/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.guihook;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.ItemStackSet;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIModContainer;
import codechicken.nei.guihook.DefaultSlotClickHandler;
import codechicken.nei.guihook.HideousLinkedList;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.guihook.IContainerSlotClickHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IGuiClientSide;
import codechicken.nei.guihook.IGuiHandleMouseWheel;
import codechicken.nei.guihook.IGuiSlotDraw;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.ReadableNumberConverter;
import codechicken.nei.util.RenderTooltipEventHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerManager {
    public GuiContainer window;
    public static RenderItem drawItems = new RenderItem();
    public static final LinkedList<IContainerTooltipHandler> tooltipHandlers = new HideousLinkedList<IContainerTooltipHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerInputHandler> inputHandlers = new HideousLinkedList<IContainerInputHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerDrawHandler> drawHandlers = new HideousLinkedList<IContainerDrawHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerObjectHandler> objectHandlers = new HideousLinkedList<IContainerObjectHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerSlotClickHandler> slotClickHandlers = new HideousLinkedList<IContainerSlotClickHandler>(new CopyOnWriteArrayList());
    private static int modelviewDepth;
    private static final HashSet<String> stackTraces;
    private static final ItemStackSet renderingErrorItems;
    private int clickHandled = 0;
    public final List<IContainerTooltipHandler> instanceTooltipHandlers;
    private static int tooltipPage;

    public static GuiContainerManager getManager() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        return gui instanceof GuiContainer ? GuiContainerManager.getManager((GuiContainer)gui) : null;
    }

    public static GuiContainerManager getManager(GuiContainer gui) {
        return null;
    }

    public static void addTooltipHandler(IContainerTooltipHandler handler) {
        tooltipHandlers.add(handler);
    }

    public static void addInputHandler(IContainerInputHandler handler) {
        inputHandlers.add(handler);
    }

    public static void addDrawHandler(IContainerDrawHandler handler) {
        drawHandlers.add(handler);
    }

    public static void addObjectHandler(IContainerObjectHandler handler) {
        objectHandlers.add(handler);
    }

    public static void addSlotClickHandler(IContainerSlotClickHandler handler) {
        slotClickHandlers.addFirst(handler);
    }

    public static FontRenderer getFontRenderer(ItemStack stack) {
        FontRenderer f;
        if (stack != null && stack.func_77973_b() != null && (f = stack.func_77973_b().getFontRenderer(stack)) != null) {
            return f;
        }
        return GuiDraw.fontRenderer;
    }

    public static List<String> itemDisplayNameMultiline(ItemStack stack, GuiContainer gui, boolean includeHandlers) {
        List<String> namelist = null;
        try {
            namelist = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, includeHandlers && Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Throwable ignored) {
            namelist = new ArrayList();
        }
        if (namelist.isEmpty()) {
            namelist.add("Unnamed");
        } else if (namelist.get(0) == null || ((String)namelist.get(0)).isEmpty()) {
            namelist.set(0, "Unnamed");
        }
        if (includeHandlers) {
            for (IContainerTooltipHandler handler : tooltipHandlers) {
                namelist = handler.handleItemDisplayName(gui, stack, namelist);
            }
        }
        namelist.set(0, stack.func_77953_t().field_77937_e.toString() + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, EnumChatFormatting.GRAY + namelist.get(i) + EnumChatFormatting.RESET);
        }
        return namelist;
    }

    @Nullable
    public static String countDetails(int stackSize, int maxStackSize, String fullPattern, String shortPattern) {
        if (maxStackSize > 1 && stackSize > maxStackSize) {
            int remainder = stackSize % maxStackSize;
            if (remainder > 0) {
                return String.format(fullPattern, NEIClientUtils.formatNumbers(stackSize), NEIClientUtils.formatNumbers(stackSize / maxStackSize), NEIClientUtils.formatNumbers(maxStackSize), NEIClientUtils.formatNumbers(remainder));
            }
            return String.format(shortPattern, NEIClientUtils.formatNumbers(stackSize), NEIClientUtils.formatNumbers(stackSize / maxStackSize), NEIClientUtils.formatNumbers(maxStackSize));
        }
        return null;
    }

    @Nullable
    public static String itemCountDetails(ItemStack stack) {
        FluidStack fluid = StackInfo.getFluid(stack);
        if (fluid != null) {
            return GuiContainerManager.fluidAmountDetails(fluid.amount * Math.max(1, stack.field_77994_a));
        }
        return GuiContainerManager.countDetails(stack.field_77994_a, stack.func_77976_d(), "Count: %s = %s * %s + %s", "Count: %s = %s * %s");
    }

    @Nullable
    public static String fluidAmountDetails(FluidStack fluid) {
        return GuiContainerManager.fluidAmountDetails(fluid.amount);
    }

    @Nullable
    public static String fluidAmountDetails(int amount) {
        return GuiContainerManager.countDetails(amount, 144, "Amount: %s L = %s * %s L + %s L", "Amount: %s L = %s * %s L");
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        try {
            List namelist = itemstack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            if (!namelist.isEmpty() && !"".equals(namelist.get(0))) {
                return itemstack.func_77953_t().field_77937_e.toString() + (String)namelist.get(0) + EnumChatFormatting.RESET;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Unnamed";
    }

    @Deprecated
    public static String concatenatedDisplayName(ItemStack itemstack, boolean includeHandlers) {
        List<String> list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, includeHandlers);
        StringJoiner sb = new StringJoiner("#");
        for (String name : list) {
            if (name.isEmpty()) continue;
            sb.add(name);
        }
        return EnumChatFormatting.func_110646_a((String)sb.toString());
    }

    public static void drawItem(int offsetX, int offsetY, ItemStack itemstack) {
        GuiContainerManager.drawItem(offsetX, offsetY, itemstack, false);
    }

    public static void drawItem(int offsetX, int offsetY, ItemStack itemstack, boolean smallAmount) {
        GuiContainerManager.drawItem(offsetX, offsetY, itemstack, smallAmount, null);
    }

    public static void drawItem(int offsetX, int offsetY, ItemStack itemstack, boolean smallAmount, String quantity) {
        GuiContainerManager.drawItem(offsetX, offsetY, itemstack, GuiContainerManager.getFontRenderer(itemstack), smallAmount, quantity);
    }

    public static void drawItem(int offsetX, int offsetY, ItemStack itemstack, FontRenderer fontRenderer) {
        GuiContainerManager.drawItem(offsetX, offsetY, itemstack, fontRenderer, false, null);
    }

    public static void drawItem(int offsetX, int offsetY, ItemStack itemstack, FontRenderer fontRenderer, boolean smallAmount, String quantity) {
        GuiContainerManager.safeItemRenderContext(itemstack, offsetX, offsetY, fontRenderer, () -> {
            float scale = smallAmount ? 0.5f : 1.0f;
            String stackSize = quantity;
            if (stackSize == null) {
                if (itemstack.field_77994_a > 1) {
                    stackSize = ReadableNumberConverter.INSTANCE.toWideReadableForm(itemstack.field_77994_a);
                    if (stackSize.length() == 3) {
                        scale = 0.8f;
                    } else if (stackSize.length() == 4) {
                        scale = 0.6f;
                    } else if (stackSize.length() > 4) {
                        scale = 0.5f;
                    }
                } else {
                    stackSize = "";
                }
            }
            drawItems.func_82406_b(fontRenderer, GuiDraw.renderEngine, itemstack, offsetX, offsetY);
            if (scale != 1.0f && !stackSize.isEmpty()) {
                GuiContainerManager.drawBigStackSize(offsetX, offsetY, stackSize, scale);
                stackSize = "";
            }
            drawItems.func_94148_a(fontRenderer, GuiDraw.renderEngine, itemstack, offsetX, offsetY, stackSize);
        });
    }

    protected static void drawBigStackSize(int offsetX, int offsetY, String stackSize, float scale) {
        float inverseScaleFactor = 1.0f / scale;
        GuiContainerManager.enable2DRender();
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        int X = (int)(((float)offsetX + 16.0f - (float)GuiDraw.fontRenderer.func_78256_a(stackSize) * scale) * inverseScaleFactor);
        int Y = (int)(((float)offsetY + 16.0f - 7.0f * scale) * inverseScaleFactor);
        GuiDraw.fontRenderer.func_78261_a(stackSize, X, Y, 0xFFFFFF);
        GL11.glScaled((double)inverseScaleFactor, (double)inverseScaleFactor, (double)inverseScaleFactor);
        GuiContainerManager.enable3DRender();
    }

    private static void safeItemRenderContext(ItemStack stack, int x, int y, FontRenderer fontRenderer, Runnable callback) {
        float zLevel = GuiContainerManager.drawItems.field_77023_b += 100.0f;
        GL11.glPushAttrib((int)1048575);
        GuiContainerManager.enable3DRender();
        if (!renderingErrorItems.contains(stack)) {
            try {
                callback.run();
                if (!GuiContainerManager.checkMatrixStack()) {
                    throw new IllegalStateException("Modelview matrix stack too deep");
                }
                if (Tessellator.field_78398_a.field_78415_z) {
                    throw new IllegalStateException("Still drawing");
                }
            }
            catch (Exception e) {
                NEIClientUtils.reportErrorBuffered((Throwable)e, stackTraces, stack);
                GuiContainerManager.restoreMatrixStack();
                if (Tessellator.field_78398_a.field_78415_z) {
                    Tessellator.field_78398_a.func_78381_a();
                }
                GuiContainerManager.drawItems.field_77023_b = zLevel;
                drawItems.func_77015_a(fontRenderer, GuiDraw.renderEngine, new ItemStack((Block)Blocks.field_150480_ab), x, y);
                renderingErrorItems.add(stack);
            }
        } else {
            drawItems.func_77015_a(fontRenderer, GuiDraw.renderEngine, new ItemStack((Block)Blocks.field_150480_ab), x, y);
        }
        GL11.glPopAttrib();
        GuiContainerManager.drawItems.field_77023_b = zLevel - 100.0f;
    }

    public static void registerReloadResourceListener() {
        IResourceManager iResourceManager = Minecraft.func_71410_x().func_110442_L();
        if (iResourceManager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager manager = (SimpleReloadableResourceManager)iResourceManager;
            manager.func_110542_a((IResourceManagerReloadListener)new ResourcePackReloaded());
        }
    }

    public static void enableMatrixStackLogging() {
        modelviewDepth = GL11.glGetInteger((int)2979);
    }

    public static void disableMatrixStackLogging() {
        modelviewDepth = -1;
    }

    public static boolean checkMatrixStack() {
        return modelviewDepth < 0 || GL11.glGetInteger((int)2979) == modelviewDepth;
    }

    public static void restoreMatrixStack() {
        if (modelviewDepth >= 0) {
            for (int i = GL11.glGetInteger((int)2979); i > modelviewDepth; --i) {
                GL11.glPopMatrix();
            }
        }
    }

    public static void setColouredItemRender(boolean enable) {
        GuiContainerManager.drawItems.field_77024_a = !enable;
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public GuiContainerManager(GuiContainer screen) {
        this.window = screen;
        if (screen instanceof IContainerTooltipHandler) {
            IContainerTooltipHandler tooltipHandler = (IContainerTooltipHandler)screen;
            this.instanceTooltipHandlers = Collections.synchronizedList(new LinkedList());
            this.instanceTooltipHandlers.add(tooltipHandler);
            this.instanceTooltipHandlers.addAll(tooltipHandlers);
        } else {
            this.instanceTooltipHandlers = tooltipHandlers;
        }
    }

    public static ItemStack getStackMouseOver(GuiContainer window) {
        Point mousePos = GuiDraw.getMousePosition();
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            ItemStack item = objectHandler.getStackUnderMouse(window, mousePos.x, mousePos.y);
            if (item == null) continue;
            return item;
        }
        Slot slot = GuiContainerManager.getSlotMouseOver(window);
        if (slot != null) {
            return slot.func_75211_c();
        }
        return null;
    }

    public static Slot getSlotMouseOver(GuiContainer window) {
        Point mousePos = GuiDraw.getMousePosition();
        if (GuiContainerManager.getManager(window).objectUnderMouse(mousePos.x, mousePos.y)) {
            return null;
        }
        return window.func_146975_c(mousePos.x, mousePos.y);
    }

    public void load() {
        this.clickHandled = 0;
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.load(this.window);
        }
    }

    public void updateScreen() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public boolean lastKeyTyped(int keyID, char keyChar) {
        if (keyID == 1) {
            return false;
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.lastKeyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean firstKeyTyped(char keyChar, int keyID) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onKeyTyped(this.window, keyChar, keyID);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.keyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseClicked(this.window, mousex, mousey, button);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.mouseClicked(this.window, mousex, mousey, button)) continue;
            this.clickHandled |= 1 << button;
            return true;
        }
        return false;
    }

    public void mouseScrolled(int scrolled) {
        Point mousepos = GuiDraw.getMousePosition();
        for (IContainerInputHandler inputHandler : inputHandlers) {
            inputHandler.onMouseScrolled(this.window, mousepos.x, mousepos.y, scrolled);
        }
        for (IContainerInputHandler inputHandler : inputHandlers) {
            if (!inputHandler.mouseScrolled(this.window, mousepos.x, mousepos.y, scrolled)) continue;
            return;
        }
        if (this.window instanceof IGuiHandleMouseWheel) {
            ((IGuiHandleMouseWheel)this.window).mouseScrolled(scrolled);
        }
    }

    public boolean overrideMouseUp(int mousex, int mousey, int button) {
        if (button >= 0 && (this.clickHandled & 1 << button) != 0) {
            this.clickHandled &= ~(1 << button);
            this.mouseUp(mousex, mousey, button);
            return true;
        }
        return false;
    }

    public void mouseUp(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseUp(this.window, mousex, mousey, button);
        }
    }

    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseDragged(this.window, mousex, mousey, button, heldTime);
        }
    }

    public void preDraw() {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.onPreDraw(this.window);
        }
    }

    public void renderObjects(int mousex, int mousey) {
        GL11.glTranslatef((float)(-this.window.field_147003_i), (float)(-this.window.field_147009_r), (float)200.0f);
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderObjects(this.window, mousex, mousey);
        }
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.postRenderObjects(this.window, mousex, mousey);
        }
        GL11.glTranslatef((float)this.window.field_147003_i, (float)this.window.field_147009_r, (float)-200.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderToolTips(int mousex, int mousey) {
        List<String> hotkeystips;
        List<String> tooltip = new LinkedList<String>();
        FontRenderer font = GuiDraw.fontRenderer;
        List<IContainerTooltipHandler> list = this.instanceTooltipHandlers;
        synchronized (list) {
            for (IContainerTooltipHandler iContainerTooltipHandler : this.instanceTooltipHandlers) {
                tooltip = iContainerTooltipHandler.handleTooltip(this.window, mousex, mousey, tooltip);
            }
        }
        ItemStack stack = GuiContainerManager.getStackMouseOver(this.window);
        if (tooltip.isEmpty() && GuiContainerManager.shouldShowTooltip(this.window)) {
            font = GuiContainerManager.getFontRenderer(stack);
            if (stack != null) {
                tooltip = GuiContainerManager.itemDisplayNameMultiline(stack, this.window, true);
                GuiContainerManager.applyItemCountDetails(tooltip, stack);
            }
            Iterator iterator = this.instanceTooltipHandlers;
            synchronized (iterator) {
                for (IContainerTooltipHandler handler : this.instanceTooltipHandlers) {
                    tooltip = handler.handleItemTooltip(this.window, stack, mousex, mousey, tooltip);
                }
            }
        }
        if (!tooltip.isEmpty()) {
            tooltip.set(0, tooltip.get(0) + "\u00a7h");
        }
        if (GuiContainerManager.shouldShowTooltip(this.window) && !(hotkeystips = this.collectHotkeyTips(mousex, mousey)).isEmpty()) {
            if (tooltip.isEmpty()) {
                tooltip.addAll(hotkeystips);
            } else {
                tooltip.addAll(1, hotkeystips);
            }
        }
        if (NEIModContainer.isGTNHLibLoaded() && !tooltip.isEmpty()) {
            if (RenderTooltipEventHelper.post(stack, (GuiScreen)this.window, mousex, mousey, font)) {
                return;
            }
            Consumer<List<String>> alternativeRenderer = RenderTooltipEventHelper.getAlternativeRenderer();
            if (alternativeRenderer == null) {
                GuiContainerManager.drawPagedTooltip(RenderTooltipEventHelper.getFont(), RenderTooltipEventHelper.getX() + 12, RenderTooltipEventHelper.getY() - 12, tooltip);
            } else {
                GL11.glDisable((int)32826);
                RenderHelper.func_74518_a();
                GL11.glDisable((int)2929);
                GuiDraw.gui.incZLevel(300.0f);
                alternativeRenderer.accept(tooltip);
                GuiDraw.gui.incZLevel(-300.0f);
                GL11.glEnable((int)2929);
                RenderHelper.func_74519_b();
                GL11.glEnable((int)32826);
            }
            RenderTooltipEventHelper.flush();
        } else {
            GuiContainerManager.drawPagedTooltip(font, mousex + 12, mousey - 12, tooltip);
        }
        for (IContainerDrawHandler iContainerDrawHandler : drawHandlers) {
            iContainerDrawHandler.postRenderTooltips(this.window, mousex, mousey, tooltip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> collectHotkeyTips(int mousex, int mousey) {
        Map<String, String> hotkeys = new HashMap<String, String>();
        List<IContainerTooltipHandler> list = this.instanceTooltipHandlers;
        synchronized (list) {
            for (IContainerTooltipHandler handler : this.instanceTooltipHandlers) {
                hotkeys = handler.handleHotkeys(this.window, mousex, mousey, hotkeys);
            }
        }
        if (!hotkeys.isEmpty()) {
            ArrayList<String> hotkeystips = new ArrayList<String>();
            if (!NEIClientUtils.altKey()) {
                hotkeystips.add(EnumChatFormatting.GRAY + NEIClientUtils.translate("showHotkeys", EnumChatFormatting.GOLD + NEIClientUtils.translate("key.alt", new Object[0]) + EnumChatFormatting.GRAY));
            } else {
                HashMap<String, List> messages = new HashMap<String, List>();
                hotkeys.remove(null);
                hotkeys.remove("");
                for (Map.Entry<String, String> entry2 : hotkeys.entrySet()) {
                    messages.computeIfAbsent(entry2.getValue(), m -> new ArrayList()).add(entry2.getKey());
                }
                for (List keys : messages.values()) {
                    Collections.sort(keys, (a, b) -> {
                        if (a.length() != b.length()) {
                            return Integer.compare(a.length(), b.length());
                        }
                        return a.compareTo((String)b);
                    });
                }
                messages.entrySet().stream().sorted((a, b) -> {
                    String sa = String.join((CharSequence)"/", (Iterable)a.getValue());
                    String sb = String.join((CharSequence)"/", (Iterable)b.getValue());
                    if (sa.length() != sb.length()) {
                        return Integer.compare(sa.length(), sb.length());
                    }
                    return sa.compareTo(sb);
                }).map(entry -> this.getHotkeyTip((List)entry.getValue(), (String)entry.getKey())).collect(Collectors.toCollection(() -> hotkeystips));
                hotkeystips.set(hotkeystips.size() - 1, (String)hotkeystips.get(hotkeystips.size() - 1) + "\u00a7h");
            }
            return hotkeystips;
        }
        return Collections.emptyList();
    }

    private String getHotkeyTip(List<String> keys, String message) {
        return EnumChatFormatting.GOLD + String.join((CharSequence)(EnumChatFormatting.DARK_GRAY + " / " + EnumChatFormatting.GOLD), keys) + EnumChatFormatting.GRAY + " - " + message + EnumChatFormatting.RESET;
    }

    public static void drawPagedTooltip(FontRenderer font, int x, int y, List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        List<List<String>> tooltips = GuiContainerManager.splitTooltipByPage(list);
        int n = tooltipPage = tooltipPage < tooltips.size() ? tooltipPage : 0;
        if (tooltips.size() > 1) {
            tooltips.get(tooltipPage).add(EnumChatFormatting.ITALIC + NEIClientUtils.translate("inventory.tooltip.page", tooltipPage + 1, tooltips.size(), NEIClientConfig.getKeyName("gui.next_tooltip")));
        }
        if (NEIModContainer.isGTNHLibLoaded()) {
            GuiDraw.drawMultilineTip((FontRenderer)font, (int)x, (int)y, tooltips.get(tooltipPage), (int)RenderTooltipEventHelper.getBackgroundStart(), (int)RenderTooltipEventHelper.getBackgroundEnd(), (int)RenderTooltipEventHelper.getBorderStart(), (int)RenderTooltipEventHelper.getBorderEnd());
            return;
        }
        GuiDraw.drawMultilineTip((FontRenderer)font, (int)x, (int)y, tooltips.get(tooltipPage));
    }

    public static List<List<String>> splitTooltipByPage(List<String> list) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        ArrayList<String> tmp = new ArrayList<String>();
        int height = -2;
        for (int i = 0; i < list.size(); ++i) {
            int lineHeight;
            String text = list.get(i);
            GuiDraw.ITooltipLineHandler line = GuiDraw.getTipLine((String)text);
            int n = line != null ? line.getSize().height : (lineHeight = text.endsWith("\u00a7h") && i + 1 < list.size() ? 12 : 10);
            if (height + lineHeight <= GuiDraw.displaySize().height - 16 - 10) {
                height += lineHeight;
            } else {
                ret.add(new ArrayList(tmp));
                tmp.clear();
                height = -2;
            }
            tmp.add(text);
        }
        if (!tmp.isEmpty()) {
            ret.add(tmp);
        }
        return ret;
    }

    public static boolean shouldShowTooltip(GuiContainer window) {
        if (window == null) {
            return false;
        }
        for (IContainerObjectHandler handler : objectHandlers) {
            if (handler.shouldShowTooltip(window)) continue;
            return false;
        }
        return window.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null;
    }

    public static void applyItemCountDetails(List<String> tooltip, ItemStack stack) {
        String itemCount;
        if (stack.field_77994_a != Integer.MAX_VALUE && NEIClientUtils.shiftKey() && (itemCount = GuiContainerManager.itemCountDetails(stack)) != null) {
            tooltip.add(String.format(EnumChatFormatting.GRAY + itemCount + EnumChatFormatting.RESET, new Object[0]));
        }
    }

    public static void incrementTooltipPage() {
        ++tooltipPage;
    }

    public void renderSlotUnderlay(Slot slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotUnderlay(this.window, slot);
        }
    }

    public void renderSlotOverlay(Slot slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotOverlay(this.window, slot);
        }
        GL11.glEnable((int)3008);
    }

    public boolean objectUnderMouse(int mousex, int mousey) {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            if (!objectHandler.objectUnderMouse(this.window, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public void handleMouseClick(Slot slot, int slotIndex, int button, int modifier) {
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.beforeSlotClick(this.window, slotIndex, button, slot, modifier);
        }
        boolean eventHandled = false;
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            eventHandled = handler.handleSlotClick(this.window, slotIndex, button, slot, modifier, eventHandled);
        }
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.afterSlotClick(this.window, slotIndex, button, slot, modifier);
        }
    }

    public void handleKeyboardInput() {
        int k = Keyboard.getEventKey();
        char c = Keyboard.getEventCharacter();
        if (Keyboard.getEventKeyState() || k == 0 && Character.isDefined(c)) {
            try {
                this.keyTyped(c, k);
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Caught out of bounds exception pressing " + c + " " + k);
                e.printStackTrace();
            }
        }
        this.window.field_146297_k.func_152348_aa();
    }

    public void keyTyped(char c, int k) {
        if (this.firstKeyTyped(c, k)) {
            return;
        }
        GuiContainerManager.callKeyTyped(this.window, c, k);
    }

    private static void callKeyTyped(GuiContainer window, char c, int k) {
    }

    public void drawSlotItem(Slot slot, ItemStack stack, int x, int y, String quantity) {
        if (this.window instanceof IGuiSlotDraw) {
            GuiContainerManager.safeItemRenderContext(stack, x, y, GuiDraw.fontRenderer, () -> ((IGuiSlotDraw)this.window).drawSlotItem(slot, stack, x, y, quantity));
        } else if (stack != null) {
            GuiContainerManager.drawItem(x, y, stack, false, quantity);
        }
    }

    public void handleSlotClick(int slotIndex, int button, int modifiers) {
        if (slotIndex == -1) {
            return;
        }
        if (this.window instanceof IGuiClientSide) {
            this.window.field_146297_k.field_71439_g.field_71070_bA.func_75144_a(slotIndex, button, modifiers, (EntityPlayer)this.window.field_146297_k.field_71439_g);
        } else {
            this.window.field_146297_k.field_71442_b.func_78753_a(this.window.field_147002_h.field_75152_c, slotIndex, button, modifiers, (EntityPlayer)this.window.field_146297_k.field_71439_g);
        }
    }

    public void handleMouseWheel() {
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.mouseScrolled(i > 0 ? 1 : -1);
        }
    }

    static {
        GuiContainerManager.addSlotClickHandler(new DefaultSlotClickHandler());
        modelviewDepth = -1;
        stackTraces = new HashSet();
        renderingErrorItems = new ItemStackSet();
    }

    private static class ResourcePackReloaded
    implements IResourceManagerReloadListener {
        private ResourcePackReloaded() {
        }

        public void func_110549_a(IResourceManager p_110549_1_) {
            renderingErrorItems.clear();
            ItemList.loadItems.restart();
        }
    }
}

