/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemList;
import codechicken.nei.LRUCache;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.ItemFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class SearchTokenParser {
    protected final LRUCache<String, ItemFilter> filtersCache = new LRUCache(20);
    protected final List<ISearchParserProvider> searchProviders;
    protected final ProvidersCache providersCache = new ProvidersCache();
    protected final Map<Character, Character> prefixRedefinitions = new HashMap<Character, Character>();

    public SearchTokenParser(List<ISearchParserProvider> searchProviders) {
        this.searchProviders = searchProviders;
    }

    public SearchTokenParser() {
        this(new ArrayList<ISearchParserProvider>());
    }

    public void addProvider(ISearchParserProvider provider) {
        this.searchProviders.add(provider);
        this.providersCache.clear();
        this.filtersCache.clear();
    }

    public void clearCache() {
        this.filtersCache.clear();
    }

    protected List<ISearchParserProvider> getProviders() {
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (!currentLanguage.func_135034_a().equals(this.providersCache.languageCode)) {
            HashMap<Character, ISearchParserProvider> providers = new HashMap<Character, ISearchParserProvider>();
            for (int index = this.searchProviders.size() - 1; index >= 0; --index) {
                ISearchParserProvider provider = this.searchProviders.get(index);
                if (providers.containsKey(Character.valueOf(provider.getPrefix())) || !provider.getMatchingLanguages().contains(currentLanguage)) continue;
                providers.put(Character.valueOf(provider.getPrefix()), provider);
            }
            this.providersCache.providers = new ArrayList(providers.values());
            this.providersCache.languageCode = currentLanguage.func_135034_a();
        }
        return this.providersCache.providers;
    }

    public ISearchParserProvider getProvider(char ch) {
        return this.getProviders().stream().filter(provider -> provider.getSearchMode() == SearchMode.PREFIX && this.getRedefinedPrefix(provider.getPrefix()) == ch).findFirst().orElse(null);
    }

    public synchronized ItemFilter getFilter(String filterText) {
        filterText = EnumChatFormatting.func_110646_a((String)filterText).toLowerCase();
        return this.filtersCache.computeIfAbsent(filterText, text -> {
            String[] parts = text.split("\\|");
            List searchTokens = Arrays.stream(parts).map(this::parseSearchText).filter(s -> s != null).collect(Collectors.toCollection(ArrayList::new));
            if (searchTokens.isEmpty()) {
                return new ItemList.EverythingItemFilter();
            }
            if (searchTokens.size() == 1) {
                return new IsRegisteredItemFilter((ItemFilter)searchTokens.get(0));
            }
            return new IsRegisteredItemFilter(new ItemList.AnyMultiItemFilter(searchTokens));
        });
    }

    public List<SearchToken> splitSearchText(String filterText) {
        if (filterText.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchToken> tokens = new ArrayList<SearchToken>();
        String prefixes = this.getPrefixes();
        int spaceMode = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
        String patternPart1 = "(?<tokenA>(^|\\s+)(?:[^" + Pattern.quote(" -\"" + prefixes) + "]).+?(?=\\s+[" + Pattern.quote("-\"" + prefixes) + "]|$))";
        String patternPart2 = "((?<ignore>-*)(?<firstChar>[" + Pattern.quote(prefixes) + "]*)(?<tokenB>\\\".*?(?:\\\"|$)|\\S+\\s*))";
        Pattern pattern = Pattern.compile(spaceMode == 0 ? patternPart2 : patternPart1 + "|" + patternPart2);
        Matcher filterMatcher = pattern.matcher(filterText);
        while (filterMatcher.find()) {
            String firstChar = filterMatcher.group("firstChar");
            SearchToken token = new SearchToken();
            token.start = filterMatcher.start();
            token.end = filterMatcher.end();
            token.ignore = "-".equals(filterMatcher.group("ignore"));
            String string = token.rawText = spaceMode == 0 ? null : filterMatcher.group("tokenA");
            if (firstChar != null && !firstChar.isEmpty()) {
                token.firstChar = Character.valueOf(firstChar.charAt(0));
            }
            if (token.rawText == null) {
                token.rawText = filterMatcher.group("tokenB");
                boolean bl = token.quotes = token.rawText.length() > 1 && token.rawText.startsWith("\"") && token.rawText.endsWith("\"");
                if (token.quotes) {
                    token.rawText = token.rawText.substring(1, token.rawText.length() - 1);
                }
                token.words = new String[]{token.rawText.trim()};
            } else {
                token.words = spaceMode == 2 ? token.rawText.trim().split("\\s+") : new String[]{token.rawText.trim()};
            }
            tokens.add(token);
        }
        return tokens;
    }

    private String getPrefixes() {
        StringBuilder prefixes = new StringBuilder().append('\u0000');
        for (ISearchParserProvider provider : this.getProviders()) {
            if (provider.getSearchMode() != SearchMode.PREFIX) continue;
            prefixes.append(this.getRedefinedPrefix(provider.getPrefix()));
        }
        return prefixes.toString();
    }

    public char getRedefinedPrefix(char prefix) {
        return this.prefixRedefinitions.getOrDefault(Character.valueOf(prefix), Character.valueOf(prefix)).charValue();
    }

    private ItemFilter parseSearchText(String filterText) {
        if (filterText.isEmpty()) {
            return null;
        }
        ItemList.AllMultiItemFilter searchTokens = new ItemList.AllMultiItemFilter();
        List<SearchToken> tokens = this.splitSearchText(filterText);
        for (SearchToken token : tokens) {
            if (!token.rawText.isEmpty()) {
                ItemFilter result = this.parseToken(token);
                if (token.ignore) {
                    searchTokens.filters.add(new ItemList.NegatedItemFilter(result));
                    continue;
                }
                searchTokens.filters.add(result);
                continue;
            }
            if (token.ignore) continue;
            searchTokens.filters.add(new ItemList.NothingItemFilter());
        }
        return searchTokens;
    }

    private ItemFilter parseToken(SearchToken token) {
        ISearchParserProvider provider;
        ISearchParserProvider iSearchParserProvider = provider = token.firstChar == null ? null : this.getProvider(token.firstChar.charValue());
        if (provider == null || provider.getSearchMode() == SearchMode.NEVER) {
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
            for (ISearchParserProvider _provider : this.getProviders()) {
                if (_provider.getSearchMode() != SearchMode.ALWAYS) continue;
                ItemList.AllMultiItemFilter filter = this.generateFilters(_provider, token.words);
                if (filter.filters.isEmpty()) continue;
                filters.add(filter);
            }
            return filters.isEmpty() ? new ItemList.NothingItemFilter() : new ItemList.AnyMultiItemFilter(filters);
        }
        return this.generateFilters(provider, token.words);
    }

    private ItemList.AllMultiItemFilter generateFilters(ISearchParserProvider provider, String[] words) {
        ItemList.AllMultiItemFilter filters = new ItemList.AllMultiItemFilter();
        for (String work : words) {
            ItemFilter filter = provider.getFilter(work);
            if (filter == null) continue;
            filters.filters.add(filter);
        }
        return filters;
    }

    private static class ProvidersCache {
        public String languageCode = null;
        public List<ISearchParserProvider> providers = new ArrayList<ISearchParserProvider>();

        private ProvidersCache() {
        }

        public void clear() {
            this.languageCode = null;
            this.providers.clear();
        }
    }

    public static interface ISearchParserProvider {
        public ItemFilter getFilter(String var1);

        public static List<Language> getAllLanguages() {
            return new ArrayList<Language>(Minecraft.func_71410_x().func_135016_M().func_135040_d());
        }

        default public List<Language> getMatchingLanguages() {
            return ISearchParserProvider.getAllLanguages();
        }

        public char getPrefix();

        public EnumChatFormatting getHighlightedColor();

        public SearchMode getSearchMode();
    }

    public static class SearchToken {
        public boolean ignore = false;
        public boolean quotes = false;
        public Character firstChar = null;
        public String[] words;
        public String rawText = "";
        public int start = 0;
        public int end = 0;
    }

    public static enum SearchMode {
        ALWAYS,
        PREFIX,
        NEVER;


        public static SearchMode fromInt(int value) {
            SearchMode searchMode;
            switch (value) {
                case 0: {
                    searchMode = ALWAYS;
                    break;
                }
                case 1: {
                    searchMode = PREFIX;
                    break;
                }
                default: {
                    searchMode = NEVER;
                }
            }
            return searchMode;
        }
    }

    private static class IsRegisteredItemFilter
    implements ItemFilter {
        public ItemFilter filter;

        public IsRegisteredItemFilter(ItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(ItemStack item) {
            return item != null && item.func_77973_b() != null && item.func_77973_b().delegate.name() != null && this.filter.matches(item);
        }
    }
}

