/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkContainerInfo;
import codechicken.nei.BookmarkCraftingChain;
import codechicken.nei.Button;
import codechicken.nei.ButtonCycled;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemStackMap;
import codechicken.nei.ItemsGrid;
import codechicken.nei.ItemsTooltipLineHandler;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PanelWidget;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import codechicken.nei.util.ReadableNumberConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class BookmarkPanel
extends PanelWidget {
    protected File bookmarkFile;
    protected BookmarkLoadingState bookmarksState;
    protected SortableItem sortableItem;
    protected SortableGroup sortableGroup;
    protected GroupingItem groupingItem;
    protected RecipeTooltipLineHandler recipeTooltipLineHandler;
    protected CraftingChainTooltipLineHandler craftingChainTooltipLineHandler;
    public Button namespacePrev;
    public Button namespaceNext;
    public Button pullBookmarkedItems;
    public Label namespaceLabel;
    protected List<BookmarkGrid> namespaces = new ArrayList<BookmarkGrid>();
    protected int activeNamespaceIndex = 0;

    public BookmarkPanel() {
        this.grid = new BookmarkGrid();
        this.namespaces.add(new BookmarkGrid());
        this.setNamespace(0);
    }

    @Override
    public void init() {
        super.init();
        this.namespaceLabel = new Label("1", true);
        this.namespacePrev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (BookmarkPanel.this.inEditingState() || rightclick) {
                    return false;
                }
                return BookmarkPanel.this.prevNamespace();
            }

            @Override
            public String getRenderLabel() {
                return "<";
            }
        };
        this.namespaceNext = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (BookmarkPanel.this.inEditingState() || rightclick) {
                    return false;
                }
                return BookmarkPanel.this.nextNamespace();
            }

            @Override
            public String getRenderLabel() {
                return ">";
            }
        };
        this.pullBookmarkedItems = new Button("Pull"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.pullBookmarkItems(-1, false);
            }

            @Override
            public String getRenderLabel() {
                return "P";
            }
        };
    }

    @Override
    public String getLabelText() {
        if (((BookmarkGrid)this.grid).getCraftingMode(0)) {
            return String.format("\u00a72[\u00a7r%d/%d\u00a72]\u00a7r", this.getPage(), Math.max(1, this.getNumPages()));
        }
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    public boolean inEditingState() {
        return this.sortableItem != null || this.sortableGroup != null || this.draggedStack != null || this.groupingItem != null && this.groupingItem.hasEndRow();
    }

    public void addItem(ItemStack itemStack) {
        this.addItem(itemStack, true);
    }

    public void addItem(ItemStack itemStack, boolean saveSize) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int idx = BGrid.indexOf(itemStack, true);
        if (idx != -1) {
            BGrid.removeItem(idx);
        }
        this.addOrRemoveItem(itemStack, null, null, false, saveSize);
    }

    public void addOrRemoveItem(ItemStack stackA) {
        this.addOrRemoveItem(stackA, null, null, false, false);
    }

    public void addOrRemoveItem(ItemStack stackover, String handlerName, List<PositionedStack> ingredients, boolean saveIngredients, boolean saveSize) {
        this.loadBookmarksIfNeeded();
        Point mousePos = GuiDraw.getMousePosition();
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousePos.x, mousePos.y);
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        if (slot != null && StackInfo.equalItemAndNBT(slot.item, stackover, true)) {
            BGrid.removeRecipe(slot.slotIndex, saveIngredients);
        } else {
            int idx;
            BookmarkRecipeId recipeId = null;
            if (handlerName != null && !handlerName.isEmpty() && ingredients != null) {
                recipeId = new BookmarkRecipeId(handlerName, ingredients);
            }
            if ((idx = BGrid.indexOf(stackover, recipeId)) != -1) {
                BGrid.removeRecipe(idx, saveIngredients);
            } else if (saveIngredients && handlerName != null && !handlerName.isEmpty() && ingredients != null) {
                BookmarkRecipe recipe = new BookmarkRecipe(stackover);
                recipe.handlerName = handlerName;
                recipe.recipeId = recipeId;
                for (PositionedStack stack : ingredients) {
                    recipe.ingredients.add(stack.item);
                }
                this.addRecipe(recipe, saveSize);
            } else {
                NBTTagCompound nbTag = StackInfo.itemStackToNBT(stackover);
                ItemStack normalized = StackInfo.loadFromNBT(nbTag, saveSize ? (long)nbTag.func_74762_e("Count") : 0L);
                ItemStackMetadata metadata = new ItemStackMetadata(recipeId, nbTag, false, 0);
                BGrid.addItem(normalized, metadata);
            }
        }
        this.fixCountOfNamespaces();
    }

    public void addRecipe(BookmarkRecipe recipe, boolean saveSize) {
        this.addRecipe(recipe, saveSize, 0);
    }

    public void addRecipe(BookmarkRecipe recipe, boolean saveSize, int groupId) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        BookmarkRecipeId recipeId = recipe.getRecipeId();
        if (!BGrid.groups.containsKey(groupId)) {
            groupId = 0;
        }
        if (recipeId != null) {
            LinkedHashMap<String, NBTTagCompound> uniqueIngredients = new LinkedHashMap<String, NBTTagCompound>();
            BGrid.removeRecipe(recipeId, groupId);
            for (ItemStack stack : recipe.ingredients) {
                String GUID = StackInfo.getItemStackGUID(stack);
                NBTTagCompound nbTagU = (NBTTagCompound)uniqueIngredients.get(GUID);
                NBTTagCompound nbTagS = StackInfo.itemStackToNBT(stack);
                if (nbTagU == null) {
                    uniqueIngredients.put(GUID, nbTagS);
                    continue;
                }
                nbTagU.func_74768_a("Count", nbTagU.func_74762_e("Count") + nbTagS.func_74762_e("Count"));
            }
            for (String GUID : uniqueIngredients.keySet()) {
                NBTTagCompound nbTag = (NBTTagCompound)uniqueIngredients.get(GUID);
                ItemStack normalized = StackInfo.loadFromNBT(nbTag, saveSize ? (long)nbTag.func_74762_e("Count") : 0L);
                ItemStackMetadata metadata = new ItemStackMetadata(recipeId.copy(), nbTag, true, groupId);
                BGrid.addItem(normalized, metadata);
            }
        }
        for (ItemStack stack : recipe.result) {
            NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack);
            ItemStack normalized = StackInfo.loadFromNBT(nbTag, saveSize ? (long)nbTag.func_74762_e("Count") : 0L);
            ItemStackMetadata metadata = new ItemStackMetadata(recipeId, nbTag, false, groupId);
            BGrid.addItem(normalized, metadata);
        }
        this.fixCountOfNamespaces();
    }

    public void addBookmarkGroup(List<ItemStack> items, BookmarkViewMode viewMode) {
        ArrayList<BookmarkRecipe> recipes = new ArrayList<BookmarkRecipe>();
        for (ItemStack stack : items) {
            recipes.add(new BookmarkRecipe(stack));
        }
        this.addBookmarkGroup(recipes, viewMode, false);
    }

    public void addBookmarkGroup(List<BookmarkRecipe> recipes, BookmarkViewMode viewMode, boolean crafting) {
        if (recipes.isEmpty()) {
            return;
        }
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int groupId = 0;
        if (viewMode == null) {
            viewMode = BGrid.getViewMode(0);
        }
        for (ItemStackMetadata meta : BGrid.metadata) {
            if (meta.groupId <= groupId) continue;
            groupId = meta.groupId;
        }
        BGrid.groups.put(++groupId, new BookmarkGroup(viewMode, crafting));
        for (BookmarkRecipe recipe : recipes) {
            this.addRecipe(recipe, true, groupId);
        }
        this.fixCountOfNamespaces();
    }

    public BookmarkRecipeId getBookmarkRecipeId(int slotIndex) {
        ItemStackMetadata meta = ((BookmarkGrid)this.grid).getMetadata(slotIndex);
        return meta.ingredient ? null : meta.recipeId;
    }

    public BookmarkRecipeId getBookmarkRecipeId(ItemStack stackA) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        BookmarkRecipeId recipeId = null;
        for (int idx = 0; idx < BGrid.realItems.size(); ++idx) {
            if (!StackInfo.equalItemAndNBT(stackA, (ItemStack)BGrid.realItems.get(idx), true) || (recipeId = this.getBookmarkRecipeId(idx)) == null) continue;
            return recipeId;
        }
        return null;
    }

    public boolean removeBookmarkRecipeId(BookmarkRecipeId recipeId) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        boolean groupId = false;
        return BGrid.removeRecipe(recipeId, 0);
    }

    public int getHoveredGroupId(boolean groupPanel) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int overRowIndex = BGrid.getHoveredRowIndex(groupPanel);
        if (groupPanel && overRowIndex == -1) {
            Point mouse = GuiDraw.getMousePosition();
            if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mouse.x, mouse.y)) {
                return 0;
            }
        }
        return overRowIndex >= 0 ? BGrid.getRowGroupId(overRowIndex) : -1;
    }

    public void removeGroup(int groupId) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        if (groupId >= 0 || groupId < BGrid.groups.size()) {
            BGrid.removeGroup(groupId);
        }
    }

    protected String getNamespaceLabelText(boolean shortFormat) {
        String activePage = String.valueOf(this.activeNamespaceIndex + 1);
        return shortFormat ? activePage : activePage + "/" + this.fixCountOfNamespaces();
    }

    protected int fixCountOfNamespaces() {
        if (this.namespaces.get(this.getNamespaceSize() - 1).size() > 0) {
            this.namespaces.add(new BookmarkGrid());
        } else if (this.activeNamespaceIndex == this.getNamespaceSize() - 2 && this.grid.size() == 0) {
            this.namespaces.remove(this.getNamespaceSize() - 1);
        }
        return this.getNamespaceSize();
    }

    protected boolean removeEmptyNamespaces() {
        if (this.activeNamespaceIndex != this.getNamespaceSize() - 1 && this.grid.size() == 0) {
            this.namespaces.remove(this.activeNamespaceIndex);
            this.setNamespace(this.activeNamespaceIndex);
            return true;
        }
        return false;
    }

    protected boolean prevNamespace() {
        if (this.bookmarksState != BookmarkLoadingState.LOADED) {
            return false;
        }
        this.fixCountOfNamespaces();
        this.removeEmptyNamespaces();
        if (this.activeNamespaceIndex == 0) {
            this.setNamespace(this.getNamespaceSize() - 1);
        } else {
            this.setNamespace(this.activeNamespaceIndex - 1);
        }
        return true;
    }

    protected boolean nextNamespace() {
        if (this.bookmarksState != BookmarkLoadingState.LOADED) {
            return false;
        }
        if (this.removeEmptyNamespaces()) {
            return true;
        }
        if (this.activeNamespaceIndex == this.fixCountOfNamespaces() - 1) {
            this.setNamespace(0);
        } else {
            this.setNamespace(this.activeNamespaceIndex + 1);
        }
        return true;
    }

    protected void setNamespace(int namespaceIndex) {
        this.activeNamespaceIndex = Math.min(namespaceIndex, this.namespaces.size() - 1);
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
        if (this.grid.size() == 0 && this.activeNamespaceIndex > 0) {
            ((BookmarkGrid)this.grid).setViewMode(0, this.namespaces.get(this.activeNamespaceIndex - 1).getViewMode(0));
        }
    }

    public int getNamespaceSize() {
        return this.namespaces.size();
    }

    public void load() {
        File dir;
        String worldPath = "global";
        if (NEIClientConfig.getBooleanSetting("inventory.bookmarks.worldSpecific")) {
            worldPath = NEIClientConfig.getWorldPath();
        }
        if (!(dir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath)).exists()) {
            dir.mkdirs();
        }
        this.bookmarkFile = new File(dir, "bookmarks.ini");
        if (!this.bookmarkFile.exists()) {
            File defaultBookmarks;
            File globalBookmarks = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/bookmarks.ini");
            File configBookmarks = new File(NEIClientConfig.configDir, "bookmarks.ini");
            File file = defaultBookmarks = configBookmarks.exists() ? configBookmarks : globalBookmarks;
            if (defaultBookmarks.exists()) {
                try {
                    if (this.bookmarkFile.createNewFile()) {
                        FileInputStream src = new FileInputStream(defaultBookmarks);
                        FileOutputStream dst = new FileOutputStream(this.bookmarkFile);
                        IOUtils.copy((InputStream)src, (OutputStream)dst);
                        ((InputStream)src).close();
                        ((OutputStream)dst).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.bookmarksState = null;
    }

    public void saveBookmarks() {
        if (this.bookmarkFile == null || this.bookmarksState != BookmarkLoadingState.LOADED) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        NBTTagCompound navigation = new NBTTagCompound();
        navigation.func_74768_a("namespaceIndex", this.activeNamespaceIndex);
        for (int grpIdx = 0; grpIdx < this.getNamespaceSize() - 1; ++grpIdx) {
            BookmarkGrid grid = this.namespaces.get(grpIdx);
            JsonObject settings = new JsonObject();
            JsonObject groups = new JsonObject();
            for (int groupId : grid.groups.keySet()) {
                BookmarkGroup group = grid.groups.get(groupId);
                JsonObject groupJson = new JsonObject();
                groupJson.add("viewmode", (JsonElement)new JsonPrimitive(group.viewMode.toString()));
                groupJson.add("crafting", (JsonElement)new JsonPrimitive(Boolean.valueOf(group.crafting != null)));
                groups.add(String.valueOf(groupId), (JsonElement)groupJson);
            }
            settings.add("groups", (JsonElement)groups);
            strings.add("; " + NBTJson.toJson((JsonElement)settings));
            navigation.func_74768_a("namespacePage." + grpIdx, grid.page);
            for (int idx = 0; idx < grid.size(); ++idx) {
                try {
                    NBTTagCompound nbTag = StackInfo.itemStackToNBT((ItemStack)grid.realItems.get(idx));
                    if (nbTag == null) continue;
                    JsonObject row = new JsonObject();
                    ItemStackMetadata meta = grid.metadata.get(idx);
                    row.add("item", NBTJson.toJsonObject((NBTBase)nbTag));
                    row.add("factor", (JsonElement)new JsonPrimitive((Number)meta.factor));
                    row.add("ingredient", (JsonElement)new JsonPrimitive(Boolean.valueOf(meta.ingredient)));
                    if (meta.groupId != 0) {
                        row.add("groupId", (JsonElement)new JsonPrimitive((Number)meta.groupId));
                    }
                    if (meta.recipeId != null) {
                        row.add("recipeId", (JsonElement)meta.recipeId.toJsonObject());
                    }
                    strings.add(NBTJson.toJson((JsonElement)row));
                    continue;
                }
                catch (JsonSyntaxException e) {
                    NEIClientConfig.logger.error("Failed to stringify bookmarked ItemStack to json string");
                }
            }
        }
        try (FileOutputStream output = new FileOutputStream(this.bookmarkFile);){
            IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            NEIClientConfig.world.nbt.func_74782_a("bookmark", (NBTBase)navigation);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Filed to save bookmarks list to file {}", new Object[]{this.bookmarkFile, e});
        }
    }

    protected void loadBookmarksIfNeeded() {
        List itemStrings;
        if (this.bookmarksState != null || this.bookmarksState == BookmarkLoadingState.LOADING) {
            return;
        }
        this.bookmarksState = BookmarkLoadingState.LOADING;
        if (this.bookmarkFile == null || !this.bookmarkFile.exists()) {
            this.bookmarksState = BookmarkLoadingState.LOADED;
            return;
        }
        try (FileInputStream reader = new FileInputStream(this.bookmarkFile);){
            NEIClientConfig.logger.info("Loading bookmarks from file {}", new Object[]{this.bookmarkFile});
            itemStrings = IOUtils.readLines((InputStream)reader, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load bookmarks from file {}", new Object[]{this.bookmarkFile, e});
            return;
        }
        JsonParser parser = new JsonParser();
        ArrayList<BookmarkGrid> namespaces = new ArrayList<BookmarkGrid>();
        NBTTagCompound navigation = new NBTTagCompound();
        namespaces.add(new BookmarkGrid());
        BookmarkGrid grid = (BookmarkGrid)namespaces.get(0);
        int groupId = 0;
        if (NEIClientConfig.world.nbt.func_74764_b("bookmark")) {
            navigation = NEIClientConfig.world.nbt.func_74775_l("bookmark");
        }
        for (String itemStr : itemStrings) {
            try {
                ItemStack itemStack;
                if (itemStr.isEmpty()) {
                    itemStr = "; {}";
                }
                if (itemStr.startsWith("; ")) {
                    JsonObject settings = parser.parse(itemStr.substring(2)).getAsJsonObject();
                    if (grid.size() > 0) {
                        grid = new BookmarkGrid();
                        namespaces.add(grid);
                    }
                    if (navigation.func_74764_b("namespacePage." + (namespaces.size() - 1))) {
                        grid.page = navigation.func_74762_e("namespacePage." + (namespaces.size() - 1));
                    }
                    if (settings.get("viewmode") != null) {
                        grid.groups.get((Object)Integer.valueOf((int)0)).viewMode = BookmarkViewMode.valueOf(settings.get("viewmode").getAsString());
                        continue;
                    }
                    if (settings.get("groups") == null || !(settings.get("groups") instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)settings.get("groups");
                    for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                        if (!(jsonEntry.getValue() instanceof JsonObject)) continue;
                        JsonObject value = (JsonObject)jsonEntry.getValue();
                        BookmarkGroup group = new BookmarkGroup(value.has("viewmode") ? BookmarkViewMode.valueOf(value.get("viewmode").getAsString()) : BookmarkViewMode.DEFAULT, value.has("crafting") ? value.get("crafting").getAsBoolean() : false);
                        grid.groups.put(Integer.valueOf((String)jsonEntry.getKey()), group);
                    }
                    continue;
                }
                JsonObject jsonObject = parser.parse(itemStr).getAsJsonObject();
                BookmarkRecipeId recipeId = null;
                NBTTagCompound itemStackNBT = jsonObject.get("item") != null ? (NBTTagCompound)NBTJson.toNbt(jsonObject.get("item")) : (NBTTagCompound)NBTJson.toNbt((JsonElement)jsonObject);
                if (jsonObject.get("recipeId") != null && jsonObject.get("recipeId") instanceof JsonObject) {
                    recipeId = new BookmarkRecipeId((JsonObject)jsonObject.get("recipeId"));
                }
                if ((itemStack = StackInfo.loadFromNBT(itemStackNBT)) != null) {
                    groupId = jsonObject.has("groupId") ? jsonObject.get("groupId").getAsInt() : 0;
                    grid.realItems.add(itemStack);
                    grid.metadata.add(new ItemStackMetadata(recipeId, jsonObject.has("factor") ? Math.abs(jsonObject.get("factor").getAsInt()) : (itemStackNBT.func_74764_b("gtFluidName") ? 144 : 1), jsonObject.has("ingredient") ? jsonObject.get("ingredient").getAsBoolean() : false, grid.groups.containsKey(groupId) ? groupId : 0, itemStackNBT.func_74764_b("gtFluidName")));
                    continue;
                }
                NEIClientConfig.logger.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", new Object[]{itemStr});
            }
            catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException e) {
                NEIClientConfig.logger.error("Failed to load bookmarked ItemStack from json string:\n{}", new Object[]{itemStr});
            }
        }
        for (BookmarkGrid gr : namespaces) {
            gr.onItemsChanged();
        }
        this.namespaces = namespaces;
        this.bookmarksState = BookmarkLoadingState.LOADED;
        if (navigation.func_74764_b("namespaceIndex")) {
            this.setNamespace(navigation.func_74762_e("namespaceIndex"));
        } else {
            this.setNamespace(0);
        }
    }

    @Override
    public void resize(GuiContainer gui) {
        this.loadBookmarksIfNeeded();
        super.resize(gui);
    }

    @Override
    protected int resizeHeader(GuiContainer gui) {
        LayoutStyleMinecraft layout = (LayoutStyleMinecraft)LayoutManager.getLayoutStyle();
        int rows = (int)Math.ceil((double)layout.buttonCount / (double)layout.numButtons);
        int diff = rows * 18 + this.getMarginTop(gui) - this.y;
        if (diff > 0) {
            this.y += diff;
            this.h -= diff;
        }
        return super.resizeHeader(gui);
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        int BUTTON_SIZE = 16;
        ButtonCycled button = LayoutManager.bookmarksButton;
        int leftBorder = this.y + this.h > button.y ? button.x + button.w + 2 : this.x;
        int rightBorder = this.x + this.w;
        int center = leftBorder + Math.max(0, (rightBorder - leftBorder) / 2);
        int labelWidth = 2;
        this.pullBookmarkedItems.h = 16;
        this.namespaceNext.h = 16;
        this.namespacePrev.h = 16;
        this.pullBookmarkedItems.w = 16;
        this.namespaceNext.w = 16;
        this.namespacePrev.w = 16;
        this.namespaceNext.y = this.pullBookmarkedItems.y = this.y + this.h - 16;
        this.namespacePrev.y = this.pullBookmarkedItems.y;
        if (rightBorder - leftBorder >= 70) {
            labelWidth = 36;
            this.namespaceLabel.text = this.getNamespaceLabelText(false);
        } else {
            labelWidth = 18;
            this.namespaceLabel.text = this.getNamespaceLabelText(true);
        }
        this.namespaceLabel.y = this.namespacePrev.y + 5;
        this.namespaceLabel.x = center;
        this.namespacePrev.x = center - labelWidth / 2 - 2 - this.namespacePrev.w;
        this.namespaceNext.x = center + labelWidth / 2 + 2;
        this.pullBookmarkedItems.x = center + 2 * labelWidth / 2 + 2;
        return 18;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (this.grid.getPerPage() > 0 && this.getNamespaceSize() > 1) {
            LayoutManager.addWidget(this.namespacePrev);
            LayoutManager.addWidget(this.namespaceNext);
            LayoutManager.addWidget(this.namespaceLabel);
            if (BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer()) != null) {
                LayoutManager.addWidget(this.pullBookmarkedItems);
            }
        }
    }

    @Override
    protected String getPositioningSettingName() {
        return "world.panels.bookmarks";
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2 - 4;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 2;
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        if (stack == null) {
            return null;
        }
        ItemStackMetadata meta = ((BookmarkGrid)this.grid).getMetadata(mouseDownSlot);
        int amount = stack.field_77994_a;
        if (amount == 0 && !meta.fluidDisplay) {
            int n = amount = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
            if (amount == 0) {
                amount = stack.func_77976_d();
            }
        }
        return NEIServerUtils.copyStack(stack, amount);
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (this.mouseDownSlot >= this.grid.realItems.size()) {
            this.mouseDownSlot = -1;
        }
        if (this.groupingItem != null) {
            int overRowIndex = (mousey - this.grid.marginTop) / 18;
            if (this.groupingItem.hasEndRow() || overRowIndex != this.groupingItem.startRowIndex || heldTime > 250L) {
                this.groupingItem.setEndRowIndex((BookmarkGrid)this.grid, Math.max(0, Math.min(overRowIndex, this.grid.getLastRowIndex())));
            }
            return;
        }
        if (this.sortableGroup != null) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            int overRowIndex = (mousey - this.grid.marginTop) / 18;
            if (this.sortableGroup.groupId != BGrid.getRowGroupId(overRowIndex)) {
                BGrid.moveGroup(this.sortableGroup.groupId, overRowIndex);
            }
            return;
        }
        if (this.sortableItem != null) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            ItemStackMetadata sortMeta = this.sortableItem.metadata.get(0);
            BookmarkViewMode sortViewMode = BGrid.getViewMode(sortMeta.groupId);
            ItemPanel.ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            if (sortViewMode == BookmarkViewMode.TODO_LIST && !sortMeta.ingredient) {
                mouseOverSlot = this.getSlotMouseOver(this.grid.marginLeft + this.grid.paddingLeft, mousey);
                if (mouseOverSlot != null) {
                    float ySlot = (float)(mousey - BGrid.marginTop) / 18.0f;
                    int lastRowIndex = BGrid.getLastRowIndex();
                    int overRowIndex = (int)ySlot;
                    int beforeGroupId = overRowIndex > 0 ? BGrid.getRowGroupId(overRowIndex - 1) : 0;
                    int afterGroupId = overRowIndex < lastRowIndex ? BGrid.getRowGroupId(overRowIndex + 1) : 0;
                    int overGroupId = BGrid.metadata.get((int)mouseOverSlot.slotIndex).groupId;
                    ySlot -= (float)overRowIndex;
                    if (this.sortableItem.items.indexOf(BGrid.realItems.get(mouseOverSlot.slotIndex)) == -1 && overGroupId == sortMeta.groupId) {
                        if (mouseOverSlot.slotIndex < BGrid.realItems.indexOf(this.sortableItem.items.get(0))) {
                            BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex, overGroupId, true);
                        } else {
                            BGrid.moveItem(this.sortableItem, BGrid.getRowItemIndex(overRowIndex, false), overGroupId, false);
                        }
                    } else if ((double)ySlot <= 0.25) {
                        if (BGrid.getViewMode(beforeGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(sortMeta.recipeId, beforeGroupId)) {
                            BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex, beforeGroupId, true);
                        }
                    } else if ((double)ySlot > 0.25 && (double)ySlot <= 0.5) {
                        if (!(beforeGroupId == afterGroupId || beforeGroupId == 0 || afterGroupId == 0 && BGrid.getViewMode(overGroupId) != BookmarkViewMode.DEFAULT || BGrid.getViewMode(0) != BookmarkViewMode.TODO_LIST || this.existsRecipeIdInGroupId(sortMeta.recipeId, 0))) {
                            beforeGroupId = 0;
                        }
                        if (BGrid.getViewMode(beforeGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(sortMeta.recipeId, beforeGroupId)) {
                            BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex, beforeGroupId, true);
                        }
                    } else if ((double)ySlot > 0.5 && (double)ySlot < 0.75) {
                        if (!(beforeGroupId == afterGroupId || beforeGroupId == 0 && BGrid.getViewMode(overGroupId) != BookmarkViewMode.DEFAULT || afterGroupId == 0 || BGrid.getViewMode(0) != BookmarkViewMode.TODO_LIST || this.existsRecipeIdInGroupId(sortMeta.recipeId, 0))) {
                            afterGroupId = 0;
                        }
                        if (BGrid.getViewMode(afterGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(sortMeta.recipeId, afterGroupId)) {
                            BGrid.moveItem(this.sortableItem, BGrid.getRowItemIndex(overRowIndex, false), afterGroupId, false);
                        }
                    } else if ((double)ySlot >= 0.75 && BGrid.getViewMode(afterGroupId) == BookmarkViewMode.TODO_LIST && !this.existsRecipeIdInGroupId(sortMeta.recipeId, afterGroupId)) {
                        BGrid.moveItem(this.sortableItem, BGrid.getRowItemIndex(overRowIndex, false), afterGroupId, false);
                    }
                }
            } else if (mouseOverSlot != null && this.sortableItem.items.indexOf(BGrid.realItems.get(mouseOverSlot.slotIndex)) == -1) {
                ItemStackMetadata meta = BGrid.getMetadata(mouseOverSlot.slotIndex);
                if (meta.groupId == sortMeta.groupId) {
                    if (sortViewMode == BookmarkViewMode.DEFAULT) {
                        BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex);
                    } else if (sortViewMode == BookmarkViewMode.TODO_LIST && meta.recipeId != null && meta.recipeId.equals(sortMeta.recipeId)) {
                        BGrid.moveItem(this.sortableItem, mouseOverSlot.slotIndex);
                    }
                }
            }
            return;
        }
        if (button == 0 && NEIClientUtils.shiftKey() && this.mouseDownSlot >= 0 && this.sortableItem == null) {
            ItemPanel.ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            if (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 250L) {
                BookmarkGrid BGrid = (BookmarkGrid)this.grid;
                ItemStackMetadata meta = BGrid.getMetadata(this.mouseDownSlot);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                ArrayList<ItemStackMetadata> metadata = new ArrayList<ItemStackMetadata>();
                if (meta.recipeId == null || meta.ingredient || BGrid.getViewMode(meta.groupId) == BookmarkViewMode.DEFAULT) {
                    items.add((ItemStack)BGrid.realItems.get(this.mouseDownSlot));
                    metadata.add(BGrid.metadata.get(this.mouseDownSlot));
                } else {
                    for (int i = 0; i < BGrid.metadata.size(); ++i) {
                        if (BGrid.metadata.get((int)i).recipeId == null || meta.groupId != BGrid.metadata.get((int)i).groupId || !meta.recipeId.equals(BGrid.metadata.get((int)i).recipeId)) continue;
                        items.add((ItemStack)BGrid.realItems.get(i));
                        metadata.add(BGrid.metadata.get(i));
                    }
                }
                this.sortableItem = new SortableItem(items, metadata);
                this.sortableItem.shiftX = -8;
                this.sortableItem.shiftY = -8;
                this.grid.onGridChanged();
            }
            return;
        }
        super.mouseDragged(mousex, mousey, button, heldTime);
    }

    private boolean existsRecipeIdInGroupId(BookmarkRecipeId recipeId, int groupId) {
        if (recipeId == null) {
            return false;
        }
        for (ItemStackMetadata meta : ((BookmarkGrid)this.grid).metadata) {
            if (!meta.equalsRecipe(recipeId, groupId) || this.sortableItem.metadata.indexOf(meta) != -1) continue;
            return true;
        }
        return false;
    }

    private int getNextSlot() {
        List<Integer> mask = this.grid.getMask();
        int columns = this.grid.getColumns();
        int perPage = this.grid.getRows() * columns;
        boolean line = ((BookmarkGrid)this.grid).getViewMode(0) == BookmarkViewMode.TODO_LIST;
        for (int i = mask.size(); i < perPage; ++i) {
            if (this.grid.isInvalidSlot(i) || line && i % columns != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        int idx;
        Rectangle4i rect;
        int idx2;
        int i;
        Point startRect;
        List<Integer> mask;
        BookmarkGrid BGrid;
        if (this.sortableItem != null) {
            BGrid = (BookmarkGrid)this.grid;
            mask = BGrid.getMask();
            startRect = null;
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            for (i = 0; i < mask.size(); ++i) {
                if (mask.get(i) == null || !this.sortableItem.items.contains(BGrid.realItems.get(idx2 = mask.get(i).intValue()))) continue;
                rect = this.grid.getSlotRect(i);
                if (startRect == null) {
                    startRect = new Point(rect.x - this.sortableItem.shiftX, rect.y - this.sortableItem.shiftY);
                }
                GuiContainerManager.drawItem(mousex + rect.x - startRect.x + 1, mousey + rect.y - startRect.y + 1, BGrid.getItem(idx2), true, "");
            }
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
        if (this.sortableGroup != null) {
            BGrid = (BookmarkGrid)this.grid;
            mask = BGrid.getMask();
            startRect = null;
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            for (i = 0; i < mask.size(); ++i) {
                if (mask.get(i) == null) continue;
                idx2 = mask.get(i);
                if (BGrid.metadata.get((int)idx2).groupId != this.sortableGroup.groupId) continue;
                rect = this.grid.getSlotRect(i);
                if (startRect == null) {
                    startRect = new Point(rect.x - this.sortableGroup.shiftX, rect.y - this.sortableGroup.shiftY);
                }
                GuiContainerManager.drawItem(mousex + rect.x - startRect.x + 1, mousey + rect.y - startRect.y + 1, BGrid.getItem(idx2), true, "");
            }
            if (startRect != null) {
                int startRowIndex = -1;
                int endRowIndex = 0;
                for (int rowIndex = 0; rowIndex < BGrid.gridGroupMask.size(); ++rowIndex) {
                    if (BGrid.gridGroupMask.get(rowIndex) != this.sortableGroup.groupId) continue;
                    if (startRowIndex == -1) {
                        startRowIndex = rowIndex;
                    }
                    endRowIndex = rowIndex;
                }
                GL11.glPushMatrix();
                GL11.glTranslated((double)(mousex - startRect.x), (double)(mousey - startRect.y), (double)1.0);
                BGrid.drawGroup(this.sortableGroup.groupId, startRowIndex, endRowIndex);
                GL11.glPopMatrix();
            }
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
        if (ItemPanels.itemPanel.draggedStack != null && this.contains(mousex, mousey) && (idx = this.getNextSlot()) >= 0) {
            Rectangle4i rect2 = this.grid.getSlotRect(idx);
            GuiDraw.drawRect((int)rect2.x, (int)rect2.y, (int)rect2.w, (int)rect2.h, (int)-296397483);
        }
        super.postDraw(mousex, mousey);
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        int overRowIndex;
        int overRowIndex2;
        BookmarkGrid BGrid;
        int groupId;
        if (button == 0 && NEIClientUtils.shiftKey() && (groupId = (BGrid = (BookmarkGrid)this.grid).getRowGroupId(overRowIndex2 = BGrid.getHoveredRowIndex(true))) != 0) {
            int rowIndex;
            for (rowIndex = overRowIndex2; rowIndex >= 0 && groupId == BGrid.getRowGroupId(rowIndex); --rowIndex) {
            }
            Rectangle4i rect = BGrid.getSlotRect(rowIndex + 1, 0);
            this.sortableGroup = new SortableGroup(groupId);
            this.sortableGroup.shiftX = rect.x - mousex;
            this.sortableGroup.shiftY = rect.y - mousey;
            return true;
        }
        if (!(NEIClientUtils.shiftKey() || button != 0 && button != 1 || (overRowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(true)) == -1)) {
            this.groupingItem = new GroupingItem((BookmarkGrid)this.grid, button == 1, overRowIndex);
            return true;
        }
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            BGrid = (BookmarkGrid)this.grid;
            if (button == 0) {
                BGrid.toggleViewMode(0);
            } else if (button == 1) {
                BGrid.toggleCraftingMode(0);
            }
            return true;
        }
        return super.handleClickExt(mousex, mousey, button);
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int overRowIndex = BGrid.getHoveredRowIndex(true);
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            currenttip.add(NEIClientUtils.translate("bookmark.group", new Object[0]));
            currenttip = this.craftingChainTooltip(0, currenttip);
        }
        if (new Rectangle4i(this.pullBookmarkedItems.x, this.pullBookmarkedItems.y, this.pullBookmarkedItems.w, this.pullBookmarkedItems.h).contains(mousex, mousey) && BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
            currenttip.add(NEIClientUtils.translate("bookmark.pullBookmarkedItems.tip", new Object[0]));
        }
        if (overRowIndex != -1) {
            int groupId = BGrid.getRowGroupId(overRowIndex);
            currenttip.add(NEIClientUtils.translate("bookmark.group", new Object[0]));
            if (groupId != 0) {
                currenttip = this.craftingChainTooltip(groupId, currenttip);
            } else {
                this.craftingChainTooltipLineHandler = null;
            }
        } else {
            this.craftingChainTooltipLineHandler = null;
        }
        return super.handleTooltip(gui, mousex, mousey, currenttip);
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int overRowIndex = BGrid.getHoveredRowIndex(true);
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            hotkeys.put(NEIClientUtils.translate("bookmark.group.toggle_mode.key", new Object[0]), NEIClientUtils.translate("bookmark.group.toggle_mode", new Object[0]));
            hotkeys.put(NEIClientUtils.translate("bookmark.group.toggle_crafting_chain.key", new Object[0]), NEIClientUtils.translate("bookmark.group.toggle_crafting_chain", new Object[0]));
            String keyName = NEIClientConfig.getKeyName("gui.remove_recipe");
            if (keyName != null) {
                hotkeys.put(keyName, NEIClientUtils.translate("bookmark.group.remove_recipe", new Object[0]));
            }
            if (BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
                keyName = NEIClientConfig.getKeyName("gui.bookmark_pull_items");
                if (keyName != null) {
                    hotkeys.put(keyName, NEIClientUtils.translate("bookmark.group.pull_items", new Object[0]));
                }
                if ((keyName = NEIClientConfig.getKeyName("gui.bookmark_pull_items_ingredients")) != null) {
                    hotkeys.put(keyName, NEIClientUtils.translate("bookmark.group.pull_items_ingredients", new Object[0]));
                }
            }
        }
        if (overRowIndex != -1) {
            String keyName;
            int groupId = BGrid.getRowGroupId(overRowIndex);
            hotkeys.put(NEIClientUtils.translate("bookmark.group.include_group.key", new Object[0]), NEIClientUtils.translate("bookmark.group.include_group", new Object[0]));
            if (groupId != 0) {
                hotkeys.put(NEIClientUtils.translate("bookmark.group.exclude_group.key", new Object[0]), NEIClientUtils.translate("bookmark.group.exclude_group", new Object[0]));
                hotkeys.put(NEIClientUtils.translate("bookmark.group.toggle_mode.key", new Object[0]), NEIClientUtils.translate("bookmark.group.toggle_mode", new Object[0]));
                hotkeys.put(NEIClientUtils.translate("bookmark.group.toggle_crafting_chain.key", new Object[0]), NEIClientUtils.translate("bookmark.group.toggle_crafting_chain", new Object[0]));
                hotkeys.put(NEIClientUtils.translate("bookmark.group.sorting.key", new Object[0]), NEIClientUtils.translate("bookmark.group.sorting", new Object[0]));
            }
            if ((keyName = NEIClientConfig.getKeyName("gui.remove_recipe")) != null) {
                hotkeys.put(keyName, NEIClientUtils.translate("bookmark.group.remove_recipe", new Object[0]));
            }
            if (BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
                keyName = NEIClientConfig.getKeyName("gui.bookmark_pull_items");
                if (keyName != null) {
                    hotkeys.put(keyName, NEIClientUtils.translate("bookmark.group.pull_items", new Object[0]));
                }
                if ((keyName = NEIClientConfig.getKeyName("gui.bookmark_pull_items_ingredients")) != null) {
                    hotkeys.put(keyName, NEIClientUtils.translate("bookmark.group.pull_items_ingredients", new Object[0]));
                }
            }
        }
        return hotkeys;
    }

    private List<String> craftingChainTooltip(int groupId, List<String> currenttip) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        BookmarkGroup group = BGrid.groups.get(groupId);
        if (this.craftingChainTooltipLineHandler == null || this.craftingChainTooltipLineHandler.groupId != groupId) {
            this.craftingChainTooltipLineHandler = group.crafting != null ? new CraftingChainTooltipLineHandler(groupId, group.crafting) : null;
        } else if (group.crafting == null) {
            this.craftingChainTooltipLineHandler = null;
        }
        if (this.craftingChainTooltipLineHandler != null) {
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.craftingChainTooltipLineHandler));
        }
        return currenttip;
    }

    @Override
    public boolean contains(int px, int py) {
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(px, py)) {
            return true;
        }
        if (((BookmarkGrid)this.grid).getHoveredRowIndex(true) != -1) {
            return true;
        }
        return super.contains(px, py);
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        if (this.contains(mousex, mousey) && itemstack != null && this.recipeTooltipLineHandler != null) {
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.recipeTooltipLineHandler));
        }
        return currenttip;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.sortableItem != null) {
            this.sortableItem = null;
            this.mouseDownSlot = -1;
            this.grid.onItemsChanged();
        } else if (this.sortableGroup != null) {
            this.sortableGroup = null;
            this.mouseDownSlot = -1;
            this.grid.onItemsChanged();
        } else if (this.groupingItem != null) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            if (this.groupingItem.hasEndRow()) {
                BGrid.createGroup(this.groupingItem);
            } else {
                int groupId = BGrid.getRowGroupId(this.groupingItem.startRowIndex);
                if (groupId != 0) {
                    if (button == 0) {
                        BGrid.toggleViewMode(groupId);
                    } else if (button == 1) {
                        BGrid.toggleCraftingMode(groupId);
                    }
                }
            }
            this.mouseDownSlot = -1;
            this.groupingItem = null;
            this.grid.onItemsChanged();
        } else {
            super.mouseUp(mousex, mousey, button);
        }
    }

    @Override
    public boolean onMouseWheel(int shift, int mousex, int mousey) {
        ItemPanel.ItemPanelSlot slot;
        if (!this.inEditingState() && new Rectangle4i(this.namespacePrev.x, this.namespacePrev.y, this.namespaceNext.x + this.namespaceNext.w - this.namespacePrev.x, this.namespacePrev.h).contains(mousex, mousey)) {
            if (shift > 0) {
                this.prevNamespace();
            } else {
                this.nextNamespace();
            }
            return true;
        }
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        if (!this.inEditingState() && NEIClientUtils.controlKey() && (slot = this.getSlotMouseOver(mousex, mousey)) != null) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            ItemStackMetadata overMeta = BGrid.getMetadata(slot.slotIndex);
            HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
            int shiftMultiplier = 1;
            if (NEIClientUtils.altKey()) {
                int n = shiftMultiplier = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
                if (shiftMultiplier == 0) {
                    shiftMultiplier = slot.item.func_77976_d();
                }
            }
            if (NEIClientUtils.shiftKey()) {
                for (int slotIndex = this.grid.size() - 1; slotIndex >= 0; --slotIndex) {
                    if (!overMeta.equalsRecipe(BGrid.getMetadata(slotIndex)) || slotIndex == slot.slotIndex) continue;
                    items.put(slotIndex, this.shiftStackSize(BGrid, slotIndex, shift, shiftMultiplier));
                }
            }
            items.put(slot.slotIndex, this.shiftStackSize(BGrid, slot.slotIndex, shift, shiftMultiplier));
            Iterator iterator = items.keySet().iterator();
            while (iterator.hasNext()) {
                int slotIndex = (Integer)iterator.next();
                if (items.get(slotIndex) == null) continue;
                BGrid.realItems.set(slotIndex, (ItemStack)items.get(slotIndex));
            }
            BGrid.onItemsChanged();
            return true;
        }
        if (super.onMouseWheel(shift, mousex, mousey)) {
            int overRowIndex = (mousey - this.grid.marginTop) / 18;
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            if (this.sortableGroup != null && this.sortableGroup.groupId != BGrid.getRowGroupId(overRowIndex)) {
                BGrid.moveGroup(this.sortableGroup.groupId, overRowIndex);
            }
            if (this.groupingItem != null && (this.groupingItem.hasEndRow() || overRowIndex != this.groupingItem.startRowIndex)) {
                this.groupingItem.setEndRowIndex(BGrid, Math.max(0, Math.min(overRowIndex, this.grid.getLastRowIndex())));
            }
            return true;
        }
        return false;
    }

    private ItemStack shiftStackSize(BookmarkGrid BGrid, int slotIndex, int shift, int shiftMultiplier) {
        int multiplier;
        long count;
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(BGrid.getItem(slotIndex));
        ItemStackMetadata meta = BGrid.getMetadata(slotIndex);
        if (meta.factor > 0 && (count = (long)((multiplier = nbTag.func_74762_e("Count") / meta.factor) + shift * shiftMultiplier) / (long)shiftMultiplier * (long)shiftMultiplier * (long)meta.factor) <= Integer.MAX_VALUE) {
            return StackInfo.loadFromNBT(nbTag, Math.max(count, 0L));
        }
        return null;
    }

    public boolean pullBookmarkItems(int groupId, boolean onlyIngredients) {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        IBookmarkContainerHandler containerHandler = BookmarkContainerInfo.getBookmarkContainerHandler(guiContainer);
        if (containerHandler == null) {
            return false;
        }
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStackMap<Long> uniqueItems = new ItemStackMap<Long>();
        for (int idx = 0; idx < BGrid.realItems.size(); ++idx) {
            ItemStackMetadata meta = BGrid.metadata.get(idx);
            if (groupId != -1 && groupId != meta.groupId) continue;
            ItemStack stack = BGrid.getItem(idx);
            BookmarkGroup group = BGrid.groups.get(meta.groupId);
            if (onlyIngredients && (!meta.ingredient || group != null && group.crafting != null && !group.crafting.inputs.containsKey(BGrid.realItems.get(idx)))) continue;
            uniqueItems.put(stack, uniqueItems.getOrDefault(stack, 0L) + (long)StackInfo.itemStackToNBT(stack).func_74762_e("Count"));
        }
        for (ItemStackMap.Entry entry : uniqueItems.entries()) {
            if ((Long)entry.value <= 0L) continue;
            items.add(StackInfo.loadFromNBT(StackInfo.itemStackToNBT(entry.key), Math.min((Long)entry.value, (long)(36 * entry.key.func_77976_d()))));
        }
        if (items.isEmpty()) {
            return false;
        }
        containerHandler.pullBookmarkItemsFromContainer(guiContainer, items);
        return true;
    }

    public static class BookmarkGrid
    extends ItemsGrid {
        protected static final int GROUP_PANEL_WIDTH = 7;
        protected static final int DEFAULT_GROUP_ID = 0;
        protected static final float SCALE_SPEED = 0.1f;
        protected List<ItemStackMetadata> metadata = new ArrayList<ItemStackMetadata>();
        protected WeakHashMap<ItemStack, Float> animation = new WeakHashMap();
        protected Map<Integer, BookmarkGroup> groups = new HashMap<Integer, BookmarkGroup>();
        protected List<Integer> gridGroupMask = new ArrayList<Integer>();
        protected int previousPageGroupId = 0;
        protected int nextPageGroupId = 0;
        protected int focusedGroupId = -1;
        protected int pageCount = 0;

        public BookmarkGrid() {
            this.groups.put(0, new BookmarkGroup(BookmarkViewMode.DEFAULT));
        }

        public BookmarkViewMode getViewMode(int groupId) {
            return this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode;
        }

        public void setViewMode(int groupId, BookmarkViewMode mode) {
            if (this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode != mode) {
                this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode = mode;
                if (mode == BookmarkViewMode.DEFAULT) {
                    this.sortGroup(groupId);
                }
                this.onItemsChanged();
            }
        }

        public void toggleViewMode(int groupId) {
            this.groups.get(groupId).toggleViewMode();
            if (this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode == BookmarkViewMode.DEFAULT) {
                this.sortGroup(groupId);
            }
            this.onItemsChanged();
        }

        public boolean getCraftingMode(int groupId) {
            return this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null;
        }

        public void setCraftingMode(int groupId, boolean on) {
            if (this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null != on) {
                this.groups.get((Object)Integer.valueOf((int)groupId)).crafting = on ? new BookmarkCraftingChain() : null;
                this.onItemsChanged();
            }
        }

        public void toggleCraftingMode(int groupId) {
            this.groups.get(groupId).toggleCraftingMode();
            this.onItemsChanged();
        }

        @Override
        public int getNumPages() {
            if (this.gridMask == null) {
                this.getMask();
            }
            return this.pageCount;
        }

        @Override
        protected List<Integer> getMask() {
            if (this.gridMask != null) {
                return this.gridMask;
            }
            if (this.perPage == 0 || this.size() == 0) {
                this.gridGroupMask = new ArrayList<Integer>();
                this.gridMask = new ArrayList();
                return this.gridMask;
            }
            ItemStackMetadata previousMeta = new ItemStackMetadata(null, 1, false, 0, false);
            ArrayList<Integer> itemsMask = new ArrayList<Integer>();
            ArrayList<Integer> groupsMask = new ArrayList<Integer>();
            int size = this.size();
            int lastIdx = -1;
            int index = 0;
            int idx = 0;
            while (idx < size && lastIdx != idx) {
                lastIdx = idx;
                for (int r = 0; r < this.rows && idx < size; ++r) {
                    for (int c = 0; c < this.columns && idx < size; ++c) {
                        index = r * this.columns + c;
                        if (this.isInvalidSlot(index)) {
                            itemsMask.add(null);
                            continue;
                        }
                        ItemStackMetadata meta = this.metadata.get(idx);
                        if (c > 0 && previousMeta.groupId != meta.groupId) {
                            itemsMask.add(null);
                            continue;
                        }
                        if (this.getViewMode(meta.groupId) == BookmarkViewMode.DEFAULT) {
                            previousMeta = meta;
                            itemsMask.add(idx++);
                            continue;
                        }
                        if (c == 0 && (meta.recipeId == null || !meta.ingredient || index + 1 < this.rows * this.columns && this.isInvalidSlot(index + 1) || previousMeta.groupId != meta.groupId || meta.ingredient && !meta.recipeId.equals(previousMeta.recipeId))) {
                            previousMeta = meta;
                            itemsMask.add(idx++);
                            continue;
                        }
                        if (c > 0 && meta.recipeId != null && meta.recipeId.equals(previousMeta.recipeId)) {
                            previousMeta = meta;
                            itemsMask.add(idx++);
                            continue;
                        }
                        itemsMask.add(null);
                    }
                    groupsMask.add(previousMeta.groupId);
                }
            }
            this.pageCount = (int)Math.ceil((float)itemsMask.size() / (float)(this.rows * this.columns));
            this.page = Math.max(0, Math.min(this.page, this.pageCount - 1));
            this.gridMask = itemsMask.subList(this.page * this.rows * this.columns, Math.min(itemsMask.size(), (this.page + 1) * this.rows * this.columns));
            this.previousPageGroupId = 0;
            this.nextPageGroupId = 0;
            if (this.page > 0 && this.page * this.rows < groupsMask.size() && groupsMask.get(this.page * this.rows) == groupsMask.get(this.page * this.rows - 1)) {
                this.previousPageGroupId = (Integer)groupsMask.get(this.page * this.rows);
            }
            if ((this.page + 1) * this.rows < groupsMask.size() && groupsMask.get((this.page + 1) * this.rows) == groupsMask.get((this.page + 1) * this.rows - 1)) {
                this.nextPageGroupId = (Integer)groupsMask.get((this.page + 1) * this.rows);
            }
            this.gridGroupMask = groupsMask.subList(this.page * this.rows, Math.min(groupsMask.size(), (this.page + 1) * this.rows));
            return this.gridMask;
        }

        protected int getRowGroupId(int rowIndex) {
            if (this.gridMask == null) {
                this.getMask();
            }
            return rowIndex != -1 && rowIndex < this.gridGroupMask.size() ? this.gridGroupMask.get(rowIndex) : 0;
        }

        protected int getRowItemIndex(int rowIndex, boolean dir) {
            int i;
            List<Integer> mask = this.getMask();
            int size = mask.size();
            int n = i = dir ? 0 : this.columns - 1;
            while (i >= 0 && i < this.columns) {
                if (rowIndex * this.columns + i < size && mask.get(rowIndex * this.columns + i) != null) {
                    return mask.get(rowIndex * this.columns + i);
                }
                i += dir ? 1 : -1;
            }
            return -1;
        }

        protected int getHoveredRowIndex(boolean groupPanel) {
            Point mouse = GuiDraw.getMousePosition();
            int leftBorder = this.marginLeft + this.paddingLeft;
            int r = (mouse.y - this.marginTop) / 18;
            if (!new Rectangle4i(leftBorder - (groupPanel ? 7 : 0), this.marginTop, this.columns * 18, (this.getLastRowIndex() + 1) * 18).contains(mouse.x, mouse.y)) {
                return -1;
            }
            if (groupPanel && mouse.x >= leftBorder - 7 && mouse.x < leftBorder) {
                return r;
            }
            if (!groupPanel && !this.isInvalidSlot(this.columns * r + (mouse.x - leftBorder) / 18)) {
                return r;
            }
            return -1;
        }

        @Override
        public void setGridSize(int mleft, int mtop, int w, int h) {
            super.setGridSize(mleft + 7, mtop, w, h);
        }

        @Override
        public void draw(int mousex, int mousey) {
            ItemPanel.ItemPanelSlot focused;
            int rowId;
            int rowIndex;
            if (this.getPerPage() == 0) {
                return;
            }
            List<Integer> groupMask = this.gridGroupMask;
            GroupingItem groupingItem = LayoutManager.bookmarkPanel.groupingItem;
            int sortableGroupId = LayoutManager.bookmarkPanel.sortableGroup != null ? LayoutManager.bookmarkPanel.sortableGroup.groupId : -3;
            int previousPageGroupId = this.previousPageGroupId;
            int nextPageGroupId = this.nextPageGroupId;
            int previoudGroupId = 0;
            int groupStartIndex = -2;
            if (sortableGroupId != -3) {
                for (int rowIndex2 = 0; rowIndex2 < groupMask.size(); ++rowIndex2) {
                    if (groupMask.get(rowIndex2) != sortableGroupId) continue;
                    GuiDraw.drawRect((int)(this.marginLeft + this.paddingLeft - 7), (int)(this.marginTop + rowIndex2 * 18), (int)7, (int)18, (int)0x66555555);
                }
            } else {
                int focusedRowIndex = this.getHoveredRowIndex(true);
                if (focusedRowIndex != -1) {
                    GuiDraw.drawRect((int)(this.marginLeft + this.paddingLeft - 7), (int)(this.marginTop + focusedRowIndex * 18), (int)7, (int)18, (int)-296397483);
                }
            }
            if (groupingItem != null && groupingItem.hasEndRow()) {
                int rowIndex3;
                List<Integer> mask = this.getMask();
                int topRowIndex = groupingItem.getTopRowIndex(this);
                int bottomRowIndex = groupingItem.getBottomRowIndex(this);
                int groupIdA = this.metadata.get((int)groupingItem.startItemIndexTop).groupId;
                int groupId = groupingItem.ungroup ? 0 : (groupIdA == 0 ? -1 : groupIdA);
                groupMask = new ArrayList<Integer>(groupMask);
                if (mask.indexOf(Math.min(groupingItem.startItemIndexTop, groupingItem.endItemIndexTop)) == -1) {
                    previousPageGroupId = groupId;
                }
                if (mask.indexOf(Math.max(groupingItem.startItemIndexBottom, groupingItem.endItemIndexBottom)) == -1) {
                    nextPageGroupId = groupId;
                }
                for (rowIndex3 = topRowIndex; rowIndex3 <= bottomRowIndex; ++rowIndex3) {
                    groupMask.set(rowIndex3, groupId);
                }
                if (groupIdA != 0 && !groupingItem.ungroup && groupingItem.startItemIndexTop != groupingItem.endItemIndexTop) {
                    if (groupingItem.endItemIndexTop < groupingItem.startItemIndexTop) {
                        for (rowIndex3 = topRowIndex - 1; rowIndex3 >= 0 && groupMask.get(rowIndex3) == groupIdA; --rowIndex3) {
                            groupMask.set(rowIndex3, 0);
                        }
                    } else if (groupingItem.endItemIndexTop > groupingItem.startItemIndexTop) {
                        for (rowIndex3 = bottomRowIndex + 1; rowIndex3 < groupMask.size() && groupMask.get(rowIndex3) == groupIdA; ++rowIndex3) {
                            groupMask.set(rowIndex3, 0);
                        }
                    }
                }
            }
            if (previousPageGroupId != 0 && previousPageGroupId == groupMask.get(0)) {
                previoudGroupId = previousPageGroupId;
                groupStartIndex = -1;
            }
            for (rowIndex = 0; rowIndex < groupMask.size(); ++rowIndex) {
                int groupId = groupMask.get(rowIndex);
                if (groupStartIndex != -2 && previoudGroupId != 0 && previoudGroupId != groupId) {
                    if (previoudGroupId != sortableGroupId) {
                        this.drawGroup(Math.max(0, previoudGroupId), groupStartIndex, rowIndex - 1);
                    }
                    groupStartIndex = -2;
                }
                if (groupStartIndex == -2 && groupId != 0) {
                    groupStartIndex = rowIndex;
                }
                previoudGroupId = groupId;
            }
            if (groupStartIndex != -2) {
                int n = rowIndex = nextPageGroupId != 0 && nextPageGroupId == groupMask.get(groupMask.size() - 1) ? this.rows : this.getLastRowIndex();
                if (previoudGroupId != sortableGroupId) {
                    this.drawGroup(Math.max(0, previoudGroupId), groupStartIndex, rowIndex);
                }
            }
            this.focusedGroupId = NEIClientUtils.shiftKey() && !LayoutManager.bookmarkPanel.inEditingState() ? ((rowId = this.getHoveredRowIndex(true)) != -1 ? this.getRowGroupId(rowId) : ((focused = this.getSlotMouseOver(mousex, mousey)) != null ? this.metadata.get((int)focused.slotIndex).groupId : -1)) : -1;
            super.draw(mousex, mousey);
        }

        private void drawGroup(int groupId, int rowIndexStart, int rowIndexEnd) {
            int halfWidth = 3;
            int heightPadding = 4;
            int leftPosition = this.marginLeft + this.paddingLeft - 3 - 1;
            int color = this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null ? 1715853941 : -10066330;
            int width = (Math.min(rowIndexEnd, this.rows - 1) - Math.max(0, rowIndexStart) + 1) * 18;
            int top = this.marginTop + Math.max(0, rowIndexStart) * 18;
            if (rowIndexStart >= 0) {
                GuiDraw.drawRect((int)leftPosition, (int)(this.marginTop + rowIndexStart * 18 + 4), (int)3, (int)1, (int)color);
                top += 5;
                width -= 5;
            }
            if (rowIndexEnd < this.rows) {
                GuiDraw.drawRect((int)leftPosition, (int)(this.marginTop + (rowIndexEnd + 1) * 18 - 4), (int)3, (int)1, (int)color);
                width -= 4;
            }
            GuiDraw.drawRect((int)leftPosition, (int)top, (int)1, (int)width, (int)color);
        }

        private void removeDuplicateItems() {
            HashMap<BookmarkRecipeId, Integer> recipeCache = new HashMap<BookmarkRecipeId, Integer>();
            HashMap<ItemStack, Integer> itemsCache = new HashMap<ItemStack, Integer>();
            HashSet<String> unique = new HashSet<String>();
            int index = 0;
            while (index < this.metadata.size()) {
                ItemStack stack = (ItemStack)this.realItems.get(index);
                ItemStackMetadata meta = this.metadata.get(index);
                String key = String.valueOf(meta.groupId);
                if (!itemsCache.containsKey(stack)) {
                    for (Object item : itemsCache.keySet()) {
                        if (!StackInfo.equalItemAndNBT(stack, (ItemStack)item, true)) continue;
                        itemsCache.put(stack, (Integer)itemsCache.get(item));
                        break;
                    }
                }
                if (!itemsCache.containsKey(stack)) {
                    itemsCache.put(stack, itemsCache.size());
                }
                key = key + ":" + itemsCache.get(stack);
                if (meta.recipeId != null) {
                    if (!recipeCache.containsKey(meta.recipeId)) {
                        for (Object item : recipeCache.keySet()) {
                            if (!((BookmarkRecipeId)item).equals(meta.recipeId)) continue;
                            recipeCache.put(meta.recipeId, (Integer)recipeCache.get(item));
                            break;
                        }
                    }
                    if (!recipeCache.containsKey(meta.recipeId)) {
                        recipeCache.put(meta.recipeId, recipeCache.size());
                    }
                    key = key + ":" + recipeCache.get(meta.recipeId);
                }
                if (unique.contains(key)) {
                    this.realItems.remove(index);
                    this.metadata.remove(index);
                    continue;
                }
                unique.add(key);
                ++index;
            }
        }

        private void sortGroup(int groupId) {
            int dir = this.getViewMode(groupId) == BookmarkViewMode.TODO_LIST ? 1 : -1;
            int size = this.metadata.size();
            int idx = 0;
            while (idx < size) {
                ItemStackMetadata meta = this.metadata.get(idx);
                if (meta.groupId == groupId && meta.recipeId != null) {
                    HashMap<Integer, Integer> sortingRank = new HashMap<Integer, Integer>();
                    ArrayList<ItemStackMetadata> sortedMetadata = new ArrayList<ItemStackMetadata>();
                    ArrayList<ItemStack> sortedItems = new ArrayList<ItemStack>();
                    ArrayList<Integer> items = new ArrayList<Integer>();
                    for (int index = idx; index < size; ++index) {
                        if (!meta.equalsRecipe(this.metadata.get(index))) continue;
                        sortingRank.put(index, (this.metadata.get((int)index).ingredient ? 1 : -1) * dir);
                        items.add(index);
                    }
                    items.sort((a, b) -> (Integer)sortingRank.get(a) - (Integer)sortingRank.get(b));
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        sortedItems.add((ItemStack)this.realItems.get(index));
                        sortedMetadata.add(this.metadata.get(index));
                    }
                    this.realItems.removeAll(sortedItems);
                    this.metadata.removeAll(sortedMetadata);
                    this.realItems.addAll(idx, sortedItems);
                    this.metadata.addAll(idx, sortedMetadata);
                    idx += sortedItems.size();
                    continue;
                }
                ++idx;
            }
        }

        private void sortIngredients() {
            if (this.size() == 0) {
                return;
            }
            this.removeDuplicateItems();
            boolean inEditingState = LayoutManager.bookmarkPanel.inEditingState();
            for (int groupId : this.groups.keySet()) {
                BookmarkGroup group = this.groups.get(groupId);
                if (group.viewMode == BookmarkViewMode.TODO_LIST) {
                    this.sortGroup(groupId);
                }
                if (group.crafting == null || inEditingState) continue;
                ArrayList<ItemStackMetadata> groupMetadata = new ArrayList<ItemStackMetadata>();
                ArrayList<ItemStack> groupItems = new ArrayList<ItemStack>();
                for (int idx = 0; idx < this.metadata.size(); ++idx) {
                    if (this.metadata.get((int)idx).groupId != groupId) continue;
                    groupItems.add((ItemStack)this.realItems.get(idx));
                    groupMetadata.add(this.metadata.get(idx));
                }
                group.crafting.refresh(groupItems, groupMetadata);
            }
        }

        @Override
        protected void onItemsChanged() {
            this.sortIngredients();
            this.onGridChanged();
        }

        protected void createGroup(GroupingItem groupingItem) {
            int idx;
            int topItemIndex = Math.min(groupingItem.startItemIndexTop, groupingItem.endItemIndexTop);
            int bottomItemIndex = Math.max(groupingItem.startItemIndexBottom, groupingItem.endItemIndexBottom);
            int groupIdA = this.metadata.get((int)groupingItem.startItemIndexTop).groupId;
            int groupId = 0;
            if (!groupingItem.ungroup) {
                if (groupIdA == 0) {
                    for (ItemStackMetadata meta : this.metadata) {
                        if (meta.groupId <= groupId) continue;
                        groupId = meta.groupId;
                    }
                    this.groups.put(++groupId, new BookmarkGroup(this.getViewMode(0)));
                } else {
                    groupId = groupIdA;
                }
            }
            for (idx = topItemIndex; idx <= bottomItemIndex; ++idx) {
                this.metadata.get((int)idx).groupId = groupId;
            }
            if (groupIdA != 0) {
                if (!groupingItem.ungroup) {
                    if (groupingItem.endItemIndexTop < groupingItem.startItemIndexTop) {
                        for (idx = topItemIndex - 1; idx >= 0 && this.metadata.get((int)idx).groupId == groupIdA; --idx) {
                            this.metadata.get((int)idx).groupId = 0;
                        }
                    } else {
                        for (idx = bottomItemIndex + 1; idx < this.metadata.size() && this.metadata.get((int)idx).groupId == groupIdA; ++idx) {
                            this.metadata.get((int)idx).groupId = 0;
                        }
                    }
                } else if (bottomItemIndex + 1 < this.metadata.size() && this.metadata.get((int)(bottomItemIndex + 1)).groupId == groupIdA) {
                    this.groups.put(++groupId, new BookmarkGroup(this.getViewMode(groupIdA)));
                    for (idx = bottomItemIndex + 1; idx < this.metadata.size() && this.metadata.get((int)idx).groupId == groupIdA; ++idx) {
                        this.metadata.get((int)idx).groupId = groupId;
                    }
                }
            }
            HashSet<Integer> usedSetIds = new HashSet<Integer>();
            for (ItemStackMetadata meta : this.metadata) {
                usedSetIds.add(meta.groupId);
            }
            this.groups.keySet().removeIf(k -> k != 0 && !usedSetIds.contains(k));
            this.onItemsChanged();
        }

        protected void removeGroup(int groupId) {
            for (int i = this.metadata.size() - 1; i >= 0; --i) {
                if (this.metadata.get((int)i).groupId != groupId) continue;
                this.metadata.remove(i);
                this.realItems.remove(i);
            }
            if (groupId != 0) {
                this.groups.remove(groupId);
            }
            this.onItemsChanged();
        }

        protected void moveGroup(int groupId, int overRowIndex) {
            int idx;
            int overGroupId = this.getRowGroupId(overRowIndex);
            int overItemIndex = this.getRowItemIndex(overRowIndex, false);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ArrayList<ItemStackMetadata> metadata = new ArrayList<ItemStackMetadata>();
            boolean moveDown = true;
            for (idx = overItemIndex + 1; idx < this.realItems.size() && moveDown; ++idx) {
                moveDown = this.metadata.get((int)idx).groupId != groupId;
            }
            for (idx = 0; idx < this.realItems.size(); ++idx) {
                if (this.metadata.get((int)idx).groupId != groupId) continue;
                items.add((ItemStack)this.realItems.get(idx));
                metadata.add(this.metadata.get(idx));
            }
            if (moveDown) {
                int bottomItemIndex = overItemIndex + 1;
                if (overGroupId == 0 || bottomItemIndex == this.realItems.size() || this.metadata.get((int)bottomItemIndex).groupId != overGroupId) {
                    this.realItems.removeAll(items);
                    this.metadata.removeAll(metadata);
                    this.realItems.addAll(bottomItemIndex -= items.size(), items);
                    this.metadata.addAll(bottomItemIndex, metadata);
                    this.onItemsChanged();
                }
            } else {
                int topItemIndex = this.getRowItemIndex(overRowIndex, true) - 1;
                if (topItemIndex >= -1 && (overGroupId == 0 || topItemIndex == -1 || this.metadata.get((int)topItemIndex).groupId != overGroupId)) {
                    this.realItems.removeAll(items);
                    this.metadata.removeAll(metadata);
                    this.realItems.addAll(topItemIndex + 1, items);
                    this.metadata.addAll(topItemIndex + 1, metadata);
                    this.onItemsChanged();
                }
            }
        }

        public int indexOf(ItemStack stackA, BookmarkRecipeId recipeId) {
            return this.indexOf(stackA, recipeId, 0);
        }

        public int indexOf(ItemStack stackA, BookmarkRecipeId recipeId, int groupId) {
            for (int idx = 0; idx < this.realItems.size(); ++idx) {
                ItemStackMetadata meta = this.getMetadata(idx);
                if (meta.groupId != groupId || (recipeId != null || meta.recipeId != null) && (recipeId == null || !recipeId.equals(meta.recipeId)) || !StackInfo.equalItemAndNBT(stackA, this.getItem(idx), true)) continue;
                return idx;
            }
            return -1;
        }

        @Override
        public ItemStack getItem(int idx) {
            ItemStack stack = this.realItems.get(idx);
            ItemStackMetadata meta = this.getMetadata(idx);
            BookmarkCraftingChain crafting = this.groups.get((Object)Integer.valueOf((int)meta.groupId)).crafting;
            if (crafting != null && crafting.calculatedItems.containsKey(stack)) {
                return crafting.calculatedItems.get(stack);
            }
            return stack;
        }

        public ItemStackMetadata getMetadata(int idx) {
            return this.metadata.get(idx);
        }

        public void addItem(ItemStack stackA, ItemStackMetadata meta) {
            this.addItem(stackA, meta, true);
        }

        public void addItem(ItemStack stackA, ItemStackMetadata meta, boolean animate) {
            this.realItems.add(stackA);
            this.metadata.add(meta);
            if (animate && NEIClientConfig.getGridRenderingCacheMode() == 0 && NEIClientConfig.areBookmarksAnimated()) {
                this.animation.put(stackA, Float.valueOf(0.0f));
            }
            this.onItemsChanged();
        }

        protected void removeRecipe(int idx, boolean removeFullRecipe) {
            ItemStackMetadata meta = this.metadata.get(idx);
            if (!removeFullRecipe && meta.recipeId != null && !meta.ingredient) {
                Optional<ItemStackMetadata> result = this.metadata.stream().filter(m -> m != meta && !m.ingredient && meta.equalsRecipe((ItemStackMetadata)m)).findAny();
                boolean bl = removeFullRecipe = !result.isPresent();
            }
            if (meta.recipeId != null && removeFullRecipe) {
                this.removeRecipe(meta.recipeId, meta.groupId);
            } else {
                this.removeItem(idx);
            }
        }

        protected boolean removeRecipe(BookmarkRecipeId recipeIdA, int groupId) {
            boolean removed = false;
            for (int slotIndex = this.metadata.size() - 1; slotIndex >= 0; --slotIndex) {
                if (!this.metadata.get(slotIndex).equalsRecipe(recipeIdA, groupId)) continue;
                removed = this.removeItem(slotIndex) || removed;
            }
            return removed;
        }

        protected boolean removeItem(int idx) {
            this.realItems.remove(idx);
            this.metadata.remove(idx);
            this.onItemsChanged();
            return true;
        }

        public BookmarkRecipeId getRecipeId(int idx) {
            return this.getMetadata((int)idx).recipeId;
        }

        protected void moveItem(SortableItem sortableItem, int slotIndex) {
            this.moveItem(sortableItem, slotIndex, slotIndex < 0 ? 0 : this.metadata.get((int)slotIndex).groupId, slotIndex < this.realItems.indexOf(sortableItem.items.get(0)));
        }

        protected void moveItem(SortableItem sortableItem, int slotIndex, int groupId, boolean moveUp) {
            if (slotIndex == -1) {
                return;
            }
            if (sortableItem.items.indexOf(this.realItems.get(slotIndex)) == -1) {
                ItemStack stackA = (ItemStack)this.realItems.get(slotIndex);
                this.realItems.removeAll(sortableItem.items);
                this.metadata.removeAll(sortableItem.metadata);
                slotIndex = this.realItems.indexOf(stackA) + (moveUp ? 0 : 1);
                for (ItemStackMetadata sm : sortableItem.metadata) {
                    sm.groupId = groupId;
                }
                this.realItems.addAll(slotIndex, sortableItem.items);
                this.metadata.addAll(slotIndex, sortableItem.metadata);
                this.onItemsChanged();
            } else if (sortableItem.metadata.get((int)0).groupId != groupId) {
                for (ItemStackMetadata meta : sortableItem.metadata) {
                    meta.groupId = groupId;
                }
                this.onItemsChanged();
            }
        }

        @Override
        protected int getGridRenderingCacheMode() {
            return this.focusedGroupId == -1 ? NEIClientConfig.getGridRenderingCacheMode() : 0;
        }

        @Override
        protected void beforeDrawSlot(@Nullable ItemPanel.ItemPanelSlot focus, int idx, Rectangle4i rect) {
            if (LayoutManager.bookmarkPanel.sortableGroup != null && this.getMetadata((int)idx).groupId == LayoutManager.bookmarkPanel.sortableGroup.groupId) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)0x66555555);
            } else if (LayoutManager.bookmarkPanel.sortableItem != null && LayoutManager.bookmarkPanel.sortableItem.items.contains(this.realItems.get(idx))) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)0x66555555);
            } else if (!LayoutManager.bookmarkPanel.inEditingState()) {
                if (NEIClientUtils.shiftKey()) {
                    ItemStack stack = (ItemStack)this.realItems.get(idx);
                    ItemStackMetadata meta = this.getMetadata(idx);
                    BookmarkGroup groupMeta = this.groups.get(meta.groupId);
                    if (groupMeta.crafting != null && meta.groupId == this.focusedGroupId) {
                        if (groupMeta.crafting.inputs.containsKey(stack)) {
                            GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)1715853941);
                        } else if (groupMeta.crafting.outputs.containsKey(stack)) {
                            GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-1721316097);
                        } else if (groupMeta.crafting.remainder.containsKey(stack)) {
                            GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-1721316097);
                        }
                    } else if (focus != null && meta.equalsRecipe(this.getMetadata(focus.slotIndex))) {
                        GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)(meta.ingredient ? 1715853941 : -1721316097));
                    } else {
                        super.beforeDrawSlot(focus, idx, rect);
                    }
                } else {
                    super.beforeDrawSlot(focus, idx, rect);
                }
            }
        }

        @Override
        protected void afterDrawSlot(@Nullable ItemPanel.ItemPanelSlot focus, int idx, Rectangle4i rect) {
            ItemStackMetadata meta = this.getMetadata(idx);
            if (meta.ingredient || meta.recipeId == null || LayoutManager.bookmarkPanel.sortableItem != null || LayoutManager.bookmarkPanel.sortableGroup != null) {
                return;
            }
            ItemStack stack = (ItemStack)this.realItems.get(idx);
            BookmarkGroup groupMeta = this.groups.get(meta.groupId);
            int multiplier = 0;
            if (NEIClientUtils.shiftKey()) {
                ItemStackMetadata prevMeta;
                ItemStackMetadata itemStackMetadata = prevMeta = idx > 0 ? this.getMetadata(idx - 1) : null;
                if (prevMeta == null || prevMeta.ingredient || !meta.recipeId.equals(prevMeta.recipeId)) {
                    if (groupMeta.crafting != null && meta.groupId == this.focusedGroupId && groupMeta.crafting.multiplier.containsKey(stack)) {
                        multiplier = this.groups.get((Object)Integer.valueOf((int)meta.groupId)).crafting.multiplier.get(stack);
                    } else if (focus != null && meta.factor > 0 && meta.equalsRecipe(this.getMetadata(focus.slotIndex))) {
                        multiplier = StackInfo.itemStackToNBT(stack).func_74762_e("Count") / meta.factor;
                    }
                }
            }
            if (multiplier > 0) {
                this.drawRecipeMarker(rect.x, rect.y, GuiContainerManager.getFontRenderer(stack), "x" + ReadableNumberConverter.INSTANCE.toWideReadableForm(multiplier), 0xFFFFFF);
            } else if (meta.recipeId != null && !meta.ingredient && NEIClientConfig.showRecipeMarker()) {
                this.drawRecipeMarker(rect.x, rect.y, GuiContainerManager.getFontRenderer(stack), "R", 0xA0A0A0);
            }
        }

        @Override
        protected void drawItem(Rectangle4i rect, int idx) {
            if (!(LayoutManager.bookmarkPanel.sortableGroup != null && this.metadata.get((int)idx).groupId == LayoutManager.bookmarkPanel.sortableGroup.groupId || LayoutManager.bookmarkPanel.sortableItem != null && LayoutManager.bookmarkPanel.sortableItem.items.contains(this.realItems.get(idx)))) {
                String stackSize;
                ItemStack realStack = (ItemStack)this.realItems.get(idx);
                ItemStackMetadata meta = this.getMetadata(idx);
                BookmarkGroup groupMeta = this.groups.get(meta.groupId);
                ItemStack drawStack = realStack;
                if (groupMeta.crafting != null && meta.groupId == this.focusedGroupId) {
                    if (groupMeta.crafting.inputs.containsKey(drawStack)) {
                        drawStack = groupMeta.crafting.inputs.get(drawStack);
                    } else if (groupMeta.crafting.outputs.containsKey(drawStack)) {
                        drawStack = groupMeta.crafting.outputs.get(drawStack);
                    } else if (groupMeta.crafting.remainder.containsKey(drawStack)) {
                        drawStack = groupMeta.crafting.remainder.get(drawStack);
                    } else if (groupMeta.crafting.intermediate.containsKey(drawStack)) {
                        drawStack = groupMeta.crafting.intermediate.get(drawStack);
                    }
                } else if (groupMeta.crafting != null && groupMeta.crafting.calculatedItems.containsKey(drawStack)) {
                    drawStack = groupMeta.crafting.calculatedItems.get(drawStack);
                }
                String string = stackSize = meta.fluidDisplay || drawStack.field_77994_a == 0 ? "" : ReadableNumberConverter.INSTANCE.toWideReadableForm(drawStack.field_77994_a);
                if (this.animation.containsKey(realStack) && this.animation.get(realStack).floatValue() < 1.0f) {
                    float currentScale = this.animation.get(realStack).floatValue() + 0.1f;
                    if (currentScale >= 1.0f) {
                        this.animation.remove(realStack);
                    } else {
                        this.animation.put(realStack, Float.valueOf(currentScale));
                    }
                    this.drawPoppingItem(rect, drawStack, stackSize, currentScale);
                } else {
                    GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, drawStack, true, stackSize);
                }
            }
        }

        protected void drawPoppingItem(Rectangle4i rect, ItemStack stack, String stackSize, float currentScale) {
            GL11.glScalef((float)currentScale, (float)currentScale, (float)currentScale);
            GuiContainerManager.drawItem(Math.round(((float)(rect.x + 1) + (9.0f - currentScale * 18.0f / 2.0f)) / currentScale), Math.round(((float)(rect.y + 1) + (9.0f - currentScale * 18.0f / 2.0f)) / currentScale), stack, true, stackSize);
            GL11.glScalef((float)(1.0f / currentScale), (float)(1.0f / currentScale), (float)(1.0f / currentScale));
        }

        protected void drawRecipeMarker(int offsetX, int offsetY, FontRenderer fontRenderer, String text, int color) {
            float scaleFactor = fontRenderer.func_82883_a() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            GuiContainerManager.enable2DRender();
            GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
            int X = (int)(((float)offsetX + 1.0f) * inverseScaleFactor);
            int Y = (int)(((float)offsetY + 1.0f) * inverseScaleFactor);
            fontRenderer.func_78261_a(text, X, Y, color);
            GL11.glScaled((double)inverseScaleFactor, (double)inverseScaleFactor, (double)inverseScaleFactor);
            GuiContainerManager.enable3DRender();
        }

        @Override
        protected void afterDrawItems(int mousex, int mousey, @Nullable ItemPanel.ItemPanelSlot focused) {
            super.afterDrawItems(mousex, mousey, focused);
            if (focused != null && NEIClientConfig.getRecipeTooltipsMode() != 0 && NEIClientConfig.isLoaded()) {
                ItemStackMetadata meta = this.metadata.get(focused.slotIndex);
                int tooltipMode = NEIClientConfig.getRecipeTooltipsMode();
                if (meta.recipeId == null || meta.ingredient) {
                    LayoutManager.bookmarkPanel.recipeTooltipLineHandler = null;
                } else if (this.groups.get((Object)Integer.valueOf((int)meta.groupId)).viewMode == BookmarkViewMode.DEFAULT && tooltipMode != 1 && tooltipMode != 3) {
                    LayoutManager.bookmarkPanel.recipeTooltipLineHandler = null;
                } else if (this.groups.get((Object)Integer.valueOf((int)meta.groupId)).viewMode == BookmarkViewMode.TODO_LIST && tooltipMode != 2 && tooltipMode != 3) {
                    LayoutManager.bookmarkPanel.recipeTooltipLineHandler = null;
                } else if (LayoutManager.bookmarkPanel.recipeTooltipLineHandler == null || LayoutManager.bookmarkPanel.recipeTooltipLineHandler.recipeId != meta.recipeId) {
                    LayoutManager.bookmarkPanel.recipeTooltipLineHandler = new RecipeTooltipLineHandler(focused.item, meta.recipeId);
                }
            } else {
                LayoutManager.bookmarkPanel.recipeTooltipLineHandler = null;
            }
        }

        @Override
        public void update() {
            if (LayoutManager.bookmarkPanel.recipeTooltipLineHandler != null) {
                LayoutManager.bookmarkPanel.recipeTooltipLineHandler.update();
            }
        }
    }

    protected static class SortableItem {
        public List<ItemStack> items = new ArrayList<ItemStack>();
        public List<ItemStackMetadata> metadata = new ArrayList<ItemStackMetadata>();
        public int shiftX = 0;
        public int shiftY = 0;

        public SortableItem(List<ItemStack> items, List<ItemStackMetadata> metadata) {
            this.items = items;
            this.metadata = metadata;
        }
    }

    protected static class SortableGroup {
        public int groupId;
        public int shiftX = 0;
        public int shiftY = 0;

        public SortableGroup(int groupId) {
            this.groupId = groupId;
        }
    }

    protected static class GroupingItem {
        public boolean ungroup;
        protected int startRowIndex;
        protected int startItemIndexTop;
        protected int startItemIndexBottom;
        protected int endRowIndex = Integer.MIN_VALUE;
        protected int endItemIndexTop;
        protected int endItemIndexBottom;

        public GroupingItem(BookmarkGrid BGrid, boolean ungroup, int rowIndex) {
            this.ungroup = ungroup;
            this.setStartRowIndex(BGrid, rowIndex);
        }

        public void setStartRowIndex(BookmarkGrid BGrid, int rowIndex) {
            this.startRowIndex = rowIndex;
            this.startItemIndexTop = this.getTopItemIndex(BGrid, rowIndex);
            this.startItemIndexBottom = this.getBottomItemIndex(BGrid, rowIndex);
        }

        public void setEndRowIndex(BookmarkGrid BGrid, int rowIndex) {
            if (BGrid.getRowItemIndex(rowIndex, true) >= 0) {
                this.endRowIndex = rowIndex;
                this.endItemIndexTop = this.getTopItemIndex(BGrid, rowIndex);
                this.endItemIndexBottom = this.getBottomItemIndex(BGrid, rowIndex);
            }
        }

        public boolean hasEndRow() {
            return this.endRowIndex != Integer.MIN_VALUE;
        }

        protected int getTopItemIndex(BookmarkGrid BGrid, int topRowIndex) {
            ItemStackMetadata meta;
            int topItemIndex = BGrid.getRowItemIndex(topRowIndex, true);
            ItemStackMetadata itemStackMetadata = meta = topItemIndex >= 0 ? BGrid.metadata.get(topItemIndex) : null;
            if (meta != null && meta.recipeId != null) {
                while (topItemIndex > 0 && meta.equalsRecipe(BGrid.metadata.get(topItemIndex - 1))) {
                    --topItemIndex;
                }
            }
            return topItemIndex;
        }

        protected int getBottomItemIndex(BookmarkGrid BGrid, int bottomRowIndex) {
            ItemStackMetadata meta;
            int bottomItemIndex = BGrid.getRowItemIndex(bottomRowIndex, false);
            ItemStackMetadata itemStackMetadata = meta = bottomItemIndex >= 0 ? BGrid.metadata.get(bottomItemIndex) : null;
            if (meta != null && meta.recipeId != null) {
                int size = BGrid.size();
                while (bottomItemIndex < size - 1 && meta.equalsRecipe(BGrid.metadata.get(bottomItemIndex + 1))) {
                    ++bottomItemIndex;
                }
            }
            return bottomItemIndex;
        }

        public int getTopRowIndex(BookmarkGrid BGrid) {
            int topItemIndex;
            List<Integer> mask = BGrid.getMask();
            int index = mask.indexOf(topItemIndex = Math.min(this.startItemIndexTop, this.endItemIndexTop));
            if (index != -1) {
                return index == -1 ? 0 : index / BGrid.columns;
            }
            return 0;
        }

        public int getBottomRowIndex(BookmarkGrid BGrid) {
            int bottomItemIndex;
            List<Integer> mask = BGrid.getMask();
            int index = mask.indexOf(bottomItemIndex = Math.max(this.startItemIndexBottom, this.endItemIndexBottom));
            if (index != -1) {
                return index == -1 ? BGrid.getLastRowIndex() : index / BGrid.columns;
            }
            return BGrid.getLastRowIndex();
        }
    }

    public static class BookmarkRecipe {
        public String handlerName = "";
        public List<ItemStack> result = new ArrayList<ItemStack>();
        public List<ItemStack> ingredients = new ArrayList<ItemStack>();
        public BookmarkRecipeId recipeId = null;

        public BookmarkRecipe(ItemStack ... result) {
            this.result.addAll(Arrays.asList(result));
        }

        public BookmarkRecipeId getRecipeId() {
            if (!this.handlerName.isEmpty() && !this.ingredients.isEmpty() && this.recipeId == null) {
                this.recipeId = new BookmarkRecipeId(this.handlerName, this.ingredients);
            }
            return this.recipeId;
        }
    }

    protected static class ItemStackMetadata {
        public int factor;
        public int groupId;
        public BookmarkRecipeId recipeId;
        public boolean ingredient = false;
        public boolean fluidDisplay = false;

        public ItemStackMetadata(BookmarkRecipeId recipeId, int factor, boolean ingredient, int groupId, boolean fluidDisplay) {
            this.recipeId = recipeId;
            this.factor = factor;
            this.ingredient = ingredient;
            this.groupId = groupId;
            this.fluidDisplay = fluidDisplay;
        }

        public ItemStackMetadata(BookmarkRecipeId recipeId, NBTTagCompound nbTag, boolean ingredient, int groupId) {
            this(recipeId, nbTag.func_74762_e("Count"), ingredient, groupId, nbTag.func_74764_b("gtFluidName"));
        }

        public ItemStackMetadata copy() {
            return new ItemStackMetadata(this.recipeId, this.factor, this.ingredient, this.groupId, this.fluidDisplay);
        }

        public boolean equalsRecipe(ItemStackMetadata meta) {
            return this.equalsRecipe(meta.recipeId, meta.groupId);
        }

        public boolean equalsRecipe(BookmarkRecipeId recipeId, int groupId) {
            return groupId == this.groupId && recipeId != null && recipeId.equals(this.recipeId);
        }
    }

    public static enum BookmarkViewMode {
        DEFAULT,
        TODO_LIST;

    }

    protected static class BookmarkGroup {
        public BookmarkCraftingChain crafting = null;
        public BookmarkViewMode viewMode;

        public BookmarkGroup(BookmarkViewMode viewMode) {
            this.viewMode = viewMode;
        }

        public BookmarkGroup(BookmarkViewMode viewMode, boolean crafting) {
            this.viewMode = viewMode;
            this.crafting = crafting ? new BookmarkCraftingChain() : null;
        }

        public void toggleViewMode() {
            this.viewMode = this.viewMode == BookmarkViewMode.DEFAULT ? BookmarkViewMode.TODO_LIST : BookmarkViewMode.DEFAULT;
        }

        public void toggleCraftingMode() {
            this.crafting = this.crafting == null ? new BookmarkCraftingChain() : null;
        }

        public BookmarkGroup copy() {
            return new BookmarkGroup(this.viewMode);
        }
    }

    public static enum BookmarkLoadingState {
        LOADING,
        LOADED;

    }

    protected static class CraftingChainTooltipLineHandler
    implements GuiDraw.ITooltipLineHandler {
        protected int groupId;
        protected BookmarkCraftingChain craftingChain;
        protected ItemsTooltipLineHandler inputs;
        protected ItemsTooltipLineHandler outputs;
        protected ItemsTooltipLineHandler remainder;
        protected Dimension size = new Dimension();

        public CraftingChainTooltipLineHandler(int groupId, BookmarkCraftingChain craftingChain) {
            this.groupId = groupId;
            this.craftingChain = craftingChain;
            this.inputs = new ItemsTooltipLineHandler(NEIClientUtils.translate("bookmark.crafting_chain.input", new Object[0]), craftingChain.inputs.values().stream().collect(Collectors.toCollection(LinkedList::new)), true, Integer.MAX_VALUE);
            this.outputs = new ItemsTooltipLineHandler(NEIClientUtils.translate("bookmark.crafting_chain.output", new Object[0]), craftingChain.outputs.values().stream().collect(Collectors.toCollection(LinkedList::new)), true, Integer.MAX_VALUE);
            this.remainder = new ItemsTooltipLineHandler(NEIClientUtils.translate("bookmark.crafting_chain.remainder", new Object[0]), craftingChain.remainder.values().stream().collect(Collectors.toCollection(LinkedList::new)), true, Integer.MAX_VALUE);
            if (!(this.inputs.isEmpty() && this.outputs.isEmpty() && this.remainder.isEmpty())) {
                this.size.height += 2 + GuiDraw.fontRenderer.field_78288_b;
                this.size.width = Math.max(this.inputs.getSize().width, Math.max(this.outputs.getSize().width, this.remainder.getSize().width));
                this.size.height += this.inputs.getSize().height + this.outputs.getSize().height + this.remainder.getSize().height;
            }
        }

        public Dimension getSize() {
            return this.size;
        }

        public void draw(int x, int y) {
            if (this.size.height == 0) {
                return;
            }
            GuiDraw.fontRenderer.func_78261_a(EnumChatFormatting.AQUA + NEIClientUtils.translate("bookmark.crafting_chain", new Object[0]) + EnumChatFormatting.RESET, x, y + 2, -296397483);
            y += 2 + GuiDraw.fontRenderer.field_78288_b;
            if (NEIClientConfig.craftingChainDir() == 0) {
                if (!this.inputs.isEmpty()) {
                    this.inputs.draw(x, y);
                    y += this.inputs.getSize().height;
                }
                if (!this.outputs.isEmpty()) {
                    this.outputs.draw(x, y);
                    y += this.outputs.getSize().height;
                }
            } else {
                if (!this.outputs.isEmpty()) {
                    this.outputs.draw(x, y);
                    y += this.outputs.getSize().height;
                }
                if (!this.inputs.isEmpty()) {
                    this.inputs.draw(x, y);
                    y += this.inputs.getSize().height;
                }
            }
            if (!this.remainder.isEmpty()) {
                this.remainder.draw(x, y);
            }
        }
    }

    protected static class RecipeTooltipLineHandler
    implements GuiDraw.ITooltipLineHandler {
        protected ItemStack stack = null;
        protected GuiRecipe<?> gui = null;
        protected BookmarkRecipeId recipeId = null;
        protected boolean createdGui = false;

        public RecipeTooltipLineHandler(ItemStack stack, BookmarkRecipeId recipeId) {
            this.stack = stack;
            this.recipeId = recipeId;
        }

        public void update() {
            if (this.gui == null && !this.createdGui) {
                this.gui = GuiCraftingRecipe.createRecipeGui("recipeId", false, this.stack, this.recipeId);
                this.createdGui = true;
                if (this.gui != null) {
                    this.gui.func_73866_w_();
                    this.gui.field_147009_r = 0;
                    this.gui.field_147003_i = 0;
                }
            }
        }

        public Dimension getSize() {
            if (this.gui != null) {
                return this.gui.getWidgetSize();
            }
            return new Dimension(0, 0);
        }

        public void draw(int x, int y) {
            if (this.gui == null) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)3.0);
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glPushAttrib((int)1048575);
            RenderHelper.func_74518_a();
            this.gui.func_146976_a(0.0f, -100, -100);
            GL11.glPopAttrib();
            if (this.gui.slotcontainer != null) {
                GL11.glPushAttrib((int)1048575);
                RenderHelper.func_74520_c();
                GL11.glEnable((int)32826);
                GL11.glDisable((int)2929);
                List slots = this.gui.slotcontainer.field_75151_b;
                for (Slot slot : slots) {
                    if (slot == null || slot.func_75211_c() == null) continue;
                    GuiContainerManager.drawItem(slot.field_75223_e, slot.field_75221_f, slot.func_75211_c());
                }
                GL11.glPopAttrib();
            }
            this.gui.func_146979_b(-100, -100);
            GL11.glPopMatrix();
        }
    }
}

