/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.bs.ICrateStorageProxy;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class CrateInventoryHandler
extends SpecialInventoryHandler {
    private final ICrateStorageProxy _tile;
    private final boolean _hideOnePerStack;
    LinkedList<Map.Entry<ItemIdentifier, Integer>> cached;

    private CrateInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = SimpleServiceLocator.betterStorageProxy.getCrateStorageProxy(tile);
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public CrateInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return SimpleServiceLocator.betterStorageProxy.isBetterStorageCrate(tile);
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new CrateInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        for (ItemStack stack : this._tile.getContents()) {
            result.add(ItemIdentifier.get(stack));
        }
        return result;
    }

    @Override
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map<ItemIdentifier, Integer> getItemsAndCount(boolean linked) {
        HashMap<ItemIdentifier, Integer> map = new HashMap<ItemIdentifier, Integer>((int)((double)this._tile.getUniqueItems() * 1.5));
        for (ItemStack stack : this._tile.getContents()) {
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.field_77994_a - (this._hideOnePerStack ? 1 : 0);
            Integer m = map.get(itemId);
            if (m == null) {
                map.put(itemId, stackSize);
                continue;
            }
            map.put(itemId, m + stackSize);
        }
        return map;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        int count = this._tile.getItemCount(itemIdent.unsafeMakeNormalStack(1));
        if (count <= (this._hideOnePerStack ? 1 : 0)) {
            return null;
        }
        return this._tile.extractItems(itemIdent.makeNormalStack(1), 1);
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        if (!itemIdent.isDamageable()) {
            int count = this._tile.getItemCount(itemIdent.unsafeMakeNormalStack(1));
            return count > 0;
        }
        for (ItemStack stack : this._tile.getContents()) {
            ItemIdentifier itemId = ItemIdentifier.get(stack).getUndamaged();
            if (!itemId.equals(itemIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        int space = this._tile.getSpaceForItem(itemIdent.unsafeMakeNormalStack(1));
        return space;
    }

    @Override
    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        if (doAdd) {
            ItemStack tst = stack.func_77946_l();
            ItemStack overflow = this._tile.insertItems(tst);
            st.field_77994_a = stack.field_77994_a;
            if (overflow != null) {
                st.field_77994_a -= overflow.field_77994_a;
            }
        } else {
            int space = this.roomForItem(ItemIdentifier.get(stack), 0);
            st.field_77994_a = Math.max(Math.min(space, stack.field_77994_a), 0);
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        return this.cached.size();
    }

    public void initCache() {
        Map<ItemIdentifier, Integer> map = this.getItemsAndCount(true);
        this.cached = new LinkedList();
        for (Map.Entry<ItemIdentifier, Integer> e : map.entrySet()) {
            this.cached.add(e);
        }
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        Map.Entry<ItemIdentifier, Integer> entry;
        if (this.cached == null) {
            this.initCache();
        }
        if ((entry = this.cached.get(i)).getValue() == 0) {
            return null;
        }
        return entry.getKey().makeNormalStack(entry.getValue());
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.cached == null) {
            this.initCache();
        }
        Map.Entry<ItemIdentifier, Integer> entry = this.cached.get(i);
        ItemStack stack = entry.getKey().makeNormalStack(j);
        ItemStack extracted = null;
        int count = this._tile.getItemCount(stack);
        if (count <= (this._hideOnePerStack ? 1 : 0)) {
            return null;
        }
        extracted = this._tile.extractItems(stack, 1);
        entry.setValue(entry.getValue() - j);
        return extracted;
    }
}

