/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.stackinfo;

import codechicken.nei.api.IStackStringifyHandler;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GTFluidStackStringifyHandler
implements IStackStringifyHandler {
    public static Class GTDisplayFluid = null;
    public static Method getFluidDisplayStack = null;
    public static Method getFluidFromDisplayStack = null;

    @Override
    public NBTTagCompound convertItemStackToNBT(ItemStack stack, boolean saveStackSize) {
        FluidStack fluidStack;
        if (GTDisplayFluid != null && GTDisplayFluid.isInstance(stack.func_77973_b()) && (fluidStack = this.getFluid(stack)) != null) {
            NBTTagCompound nbTag = new NBTTagCompound();
            nbTag.func_74778_a("gtFluidName", fluidStack.getFluid().getName());
            nbTag.func_74768_a("Count", saveStackSize ? fluidStack.amount : 1);
            return nbTag;
        }
        return null;
    }

    @Override
    public ItemStack convertNBTToItemStack(NBTTagCompound nbtTag) {
        if (getFluidDisplayStack != null && nbtTag.func_74764_b("gtFluidName")) {
            String fluidName = nbtTag.func_74779_i("gtFluidName");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            int amount = nbtTag.func_74762_e("Count");
            try {
                Object obj = getFluidDisplayStack.invoke(null, new FluidStack(fluid, amount), true);
                if (obj != null) {
                    return (ItemStack)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public FluidStack getFluid(ItemStack stack) {
        if (getFluidFromDisplayStack != null && GTDisplayFluid != null && GTDisplayFluid.isInstance(stack.func_77973_b())) {
            try {
                Object obj = getFluidFromDisplayStack.invoke(null, stack);
                if (obj != null) {
                    return (FluidStack)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            Class<?> gtUtility = Class.forName("gregtech.api.util.GT_Utility");
            GTDisplayFluid = Class.forName("gregtech.common.items.GT_FluidDisplayItem");
            getFluidFromDisplayStack = gtUtility.getMethod("getFluidFromDisplayStack", ItemStack.class);
            getFluidDisplayStack = gtUtility.getMethod("getFluidDisplayStack", FluidStack.class, Boolean.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

