/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import logisticspipes.LPConstants;
import logisticspipes.proxy.computers.wrapper.CCObjectWrapper;
import logisticspipes.proxy.opencomputers.asm.ClassCreator;
import logisticspipes.utils.ModStatusHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class LogisticsPipesClassInjector
implements IClassTransformer {
    private Field fResourceCache = LaunchClassLoader.class.getDeclaredField("resourceCache");
    private Boolean isObfEnv = null;

    public LogisticsPipesClassInjector() throws NoSuchFieldException, SecurityException {
        this.fResourceCache.setAccessible(true);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes != null) {
            if (name.startsWith("logisticspipes.")) {
                ClassReader reader = new ClassReader(bytes);
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                if (node.visibleAnnotations != null) {
                    for (AnnotationNode a : node.visibleAnnotations) {
                        if (!a.desc.equals("Llogisticspipes/asm/ModVersionedClass;")) continue;
                        if (a.values.size() == 8 && a.values.get(0).equals("modId") && a.values.get(2).equals("version") && a.values.get(4).equals("classData") && a.values.get(6).equals("classDataDev")) {
                            String modId = a.values.get(1).toString();
                            String version = a.values.get(3).toString();
                            String classData = a.values.get(5).toString();
                            String classDataDev = a.values.get(7).toString();
                            if (!ModStatusHelper.isModLoaded(modId) || ModStatusHelper.isModVersionEqualsOrHigher(modId, version)) continue;
                            if (this.isObfEnv == null) {
                                try {
                                    this.isObfEnv = Class.forName("net.minecraft.world.World").getDeclaredField("chunkProvider") == null;
                                }
                                catch (Throwable e) {
                                    this.isObfEnv = true;
                                }
                            }
                            bytes = this.transform(name, transformedName, DatatypeConverter.parseBase64Binary((String)(this.isObfEnv != false ? classData : classDataDev)));
                            continue;
                        }
                        throw new UnsupportedOperationException("Can't parse the annotations correctly");
                    }
                }
            }
            return bytes;
        }
        try {
            if (name.startsWith("logisticspipes.proxy.opencomputers.asm.BaseWrapperClass$") && name.endsWith("$OpenComputersWrapper")) {
                String correctName = name.substring(56, name.length() - 21);
                Class clazz = Launch.classLoader.findClass(correctName);
                bytes = ClassCreator.getWrappedClassAsBytes(CCObjectWrapper.getWrapperInformation(clazz), clazz.getName());
                TreeSet<String> set = new TreeSet<String>();
                set.add(name);
                Launch.classLoader.clearNegativeEntries(set);
                Map map = (Map)this.fResourceCache.get(Launch.classLoader);
                map.put(name, bytes);
                return bytes;
            }
        }
        catch (Exception e) {
            if (LPConstants.DEBUG) {
                e.printStackTrace();
                return bytes;
            }
            throw new RuntimeException(e);
        }
        return bytes;
    }
}

