# terminal commands
```lua
newUniqueKey()
-- generates a new unique terminal key
-- all linked glasses have to be repaired after that

removeAll()
-- removes all widgets

removeWidget(Integer:widgetId)
-- removes a specific widget

getWidgetCount()
-- gets the current widget count

requestResolutionEvents(String:userName)
-- requests the screen resolution event from the specified user
-- userName can be empty to request the event from all active glasses

getConnectedPlayers()
-- gets a list of all connected players, their UUID, screen resolution and GUI size
-- `PLAYER_NAME`, `PLAYER_UUID`, `SCREEN_WIDTH`, `SCREEN_HEIGHT`, `GUI_SCALE_FACTOR`

setRenderResolution(String:userName, Integer:width, Integer:height) 
-- set custom overlay render resolution
-- username can be empty to set the resolution for all active glasses
```

### additional methods for new versions
version 2.1+
```lua
getUserPostion([String:userName])
-- returns the current user position relative to the terminal (requires a navigation upgrade on the glasses)

setRenderPosition(String:type)
-- sets the renderposition for world widgets
-- absolute: widgets are rendered relative to 0,0,0
-- relative: widgets are rendered relative to the terminal location (or robot/drone/tablet/case/microcontroller position if its used as upgrade)

getRenderPosition():String:type
-- returns the current setting for render position

setTerminalName(String:name)
-- sets a name for the terminal (which is displayed in the glasses linking gui)

setTerminalName():String:name
-- returns the current terminal name

getUserLookingAt([String:playerName])
-- returns the current block/location the user is looking at (this requires geolyzer and navigation upgrade on the glasses)

startLinking([String:playerName])
-- this requests the player to accept the linking on its glasses (the request will be sent to all users within 64 blocks range if playerName is empty)
```