/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.internal.CCLLog;
import java.util.function.BooleanSupplier;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;

public class OpenGLUtils {
    public static boolean openGL20;
    public static boolean openGL32;
    public static boolean openGL40;
    public static boolean openGL43;
    public static boolean openGL44;
    public static boolean openGL45;

    public static void loadCaps() {
        ContextCapabilities caps = GLContext.getCapabilities();
        openGL20 = caps.OpenGL20;
        openGL32 = caps.OpenGL32;
        openGL40 = OpenGLUtils.tryGet(() -> caps.OpenGL40, "LWJGL Outdated, OpenGL 4.0 is not supported.");
        openGL43 = OpenGLUtils.tryGet(() -> caps.OpenGL43, "LWJGL Outdated, OpenGL 4.3 is not supported.");
        openGL44 = OpenGLUtils.tryGet(() -> caps.OpenGL44, "LWJGL Outdated, OpenGL 4.4 is not supported.");
        openGL45 = OpenGLUtils.tryGet(() -> caps.OpenGL45, "LWJGL Outdated, OpenGL 4.5 is not supported.");
    }

    public static String glGetProgramInfoLog(int program) {
        int maxLength = GL20.glGetProgrami((int)program, (int)35716);
        return GL20.glGetProgramInfoLog((int)program, (int)maxLength);
    }

    public static String glGetShaderInfoLog(int shader) {
        int maxLength = GL20.glGetShaderi((int)shader, (int)35716);
        return GL20.glGetShaderInfoLog((int)shader, (int)maxLength);
    }

    private static boolean tryGet(BooleanSupplier sup, String log) {
        try {
            return sup.getAsBoolean();
        }
        catch (Throwable ignored) {
            CCLLog.log(Level.INFO, log);
            return false;
        }
    }
}

