/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import com.google.common.base.Preconditions;
import java.io.IOException;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class PacketSetHotbarItemStack
extends PacketJei {
    private final ItemStack itemStack;
    private final int hotbarSlot;

    public PacketSetHotbarItemStack(ItemStack itemStack, int hotbarSlot) {
        ErrorUtil.checkNotNull(itemStack, "itemStack");
        Preconditions.checkArgument((boolean)InventoryPlayer.func_184435_e((int)hotbarSlot), (Object)("hotbar slot must be in the hotbar. got: " + hotbarSlot));
        this.itemStack = itemStack;
        this.hotbarSlot = hotbarSlot;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.SET_HOTBAR_ITEM;
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        NBTTagCompound nbt = this.itemStack.serializeNBT();
        buf.func_150786_a(nbt);
        buf.func_150787_b(this.hotbarSlot);
    }

    public static void readPacketData(PacketBuffer buf, EntityPlayer player) throws IOException {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP sender = (EntityPlayerMP)player;
            NBTTagCompound itemStackSerialized = buf.func_150793_b();
            if (itemStackSerialized != null) {
                int hotbarSlot = buf.func_150792_a();
                ItemStack itemStack = new ItemStack(itemStackSerialized);
                if (!itemStack.func_190926_b()) {
                    CommandUtilServer.setHotbarSlot(sender, itemStack, hotbarSlot);
                }
            }
        }
    }
}

