/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.gui;

import ben_mkiv.guitoolkit.client.widget.EnergyBar;
import ben_mkiv.guitoolkit.client.widget.prettyButton;
import ben_mkiv.guitoolkit.client.widget.prettyCheckbox;
import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.gui.NotificationList;
import com.bymarcin.openglasses.gui.TerminalHostsList;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import java.io.IOException;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GlassesGui
extends GuiScreen {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 229;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private prettyCheckbox enablePopupNotifications;
    private ItemStack glassesStack = ItemStack.field_190927_a;
    private TerminalHostsList list;
    private NotificationList notificationList;
    private EnergyBar energyBar;
    private static boolean isNotification = false;
    private static final ResourceLocation background = new ResourceLocation("openglasses", "textures/gui/glasses.png");

    public GlassesGui(boolean notification) {
        isNotification = notification;
        this.xSize = 256;
        this.ySize = 229;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.glassesStack = ItemStack.field_190927_a;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.enablePopupNotifications = new prettyCheckbox(this.field_146292_n.size(), this.guiLeft + 5, this.guiTop + 15, "popup notifications", false);
        this.func_189646_b((GuiButton)this.enablePopupNotifications);
        this.energyBar = new EnergyBar(this.field_146292_n.size(), this.guiLeft + this.xSize - 105, this.guiTop + 5, 100, 7);
        this.func_189646_b((GuiButton)this.energyBar);
        this.list = new TerminalHostsList(245, 100, this.guiTop + 35, this.guiLeft + 5, 80, this.xSize, this.ySize);
        this.notificationList = new NotificationList(245, 73, this.guiTop + 150, this.guiLeft + 5, 45, this.xSize, this.ySize);
        this.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        ItemStack playerGlasses = OpenGlasses.getGlassesStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.list.drawScreen(mouseX, mouseY, partialTicks);
        if (this.notificationList.getSize() > 0) {
            this.notificationList.drawScreen(mouseX, mouseY, partialTicks);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.energyBar.drawBar(0, 0, 1.0 - this.glassesStack.func_77973_b().getDurabilityForDisplay(playerGlasses), null);
        Minecraft.func_71410_x().field_71466_p.func_78276_b("OpenGlasses", this.guiLeft + 5, this.guiTop + 5, 0);
        String energyStored = this.formatNumber((int)OpenGlassesItem.getEnergyStored(playerGlasses)) + " FE";
        Minecraft.func_71410_x().field_71466_p.func_78276_b(energyStored, this.guiLeft - 5 + this.xSize - this.field_146289_q.func_78256_a(energyStored), this.guiTop + 13, 0);
        String hosts = this.list.getSize() + " hosts";
        Minecraft.func_71410_x().field_71466_p.func_78276_b(hosts, this.guiLeft - 5 + this.xSize - this.field_146289_q.func_78256_a(hosts), this.guiTop + 25, 0);
    }

    private String formatNumber(double number) {
        return NumberFormat.getInstance().format(number);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof prettyButton) {
            if (button.equals(this.enablePopupNotifications)) {
                GlassesEventPacket.EventType eventType = this.enablePopupNotifications.isEnabled() ? GlassesEventPacket.EventType.DISABLE_NOTIFICATIONS : GlassesEventPacket.EventType.ENABLE_NOTIFICATIONS;
                NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(null, eventType));
            }
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73876_c() {
        ItemStack newGlassesStack = OCClientSurface.glasses.get();
        boolean glassesChanged = !ItemStack.func_77970_a((ItemStack)this.glassesStack, (ItemStack)newGlassesStack);
        this.glassesStack = newGlassesStack.func_77946_l();
        if (this.glassesStack.func_190926_b()) {
            Minecraft.func_71410_x().field_71462_r = null;
            return;
        }
        super.func_73876_c();
        if (glassesChanged) {
            this.enablePopupNotifications.setEnabled(!this.glassesStack.func_77978_p().func_74764_b("nopopups"));
            this.list.clear();
            this.list.add(OCClientSurface.glasses.getHosts().values());
            this.notificationList.update();
            this.ySize = this.notificationList.getSize() > 0 ? 229 : 144;
        }
    }

    public void func_146278_c(int tint) {
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }
}

