/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj;

import ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj.Face;
import ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj.Shape;
import ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj.Vector;
import ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj.Vertex;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class objParser {
    protected static Pattern linePattern = Pattern.compile("^(?<type>.*?) (?<data>.*)$");
    protected static Pattern facePattern = Pattern.compile("(?<v>\\d+)(/(?<t>\\d+)?(/(?<n>\\d+))?)?");
    protected Matcher matcher;
    protected String currentLine;
    protected int lineNumber;
    protected String currentShape = "Default";
    protected List<Vertex> vertexes = new ArrayList<Vertex>();
    protected List<UV> uvs = new ArrayList<UV>();
    protected List<Vector> normals = new ArrayList<Vector>();
    protected List<Face> faces = new ArrayList<Face>();
    protected Map<String, Shape> shapes = Maps.newHashMap();
    public List<Face> facesTri = new ArrayList<Face>();
    public List<Face> facesQuad = new ArrayList<Face>();

    public objParser(String objData) {
        this.load(objData);
    }

    public Map<String, Shape> getShapes() {
        return this.shapes;
    }

    public void load(String objData) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(objData.getBytes(StandardCharsets.UTF_8.name()));
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((this.currentLine = reader.readLine()) != null) {
                ++this.lineNumber;
                this.currentLine = this.currentLine.replaceAll("\\s+", " ").trim();
                this.matcher = linePattern.matcher(this.currentLine);
                if (!this.matcher.matches()) continue;
                String type = this.matcher.group("type");
                String data = this.matcher.group("data");
                switch (type) {
                    case "v": {
                        this.addVertex(data);
                        break;
                    }
                    case "vn": {
                        this.addNormal(data);
                        break;
                    }
                    case "vt": {
                        this.addUV(data);
                        break;
                    }
                    case "f": {
                        this.addFace(data);
                        break;
                    }
                    case "g": 
                    case "o": {
                        this.addShape(data);
                        break;
                    }
                }
            }
            this.addShape("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addVertex(String data) {
        String[] coords = data.split("\\s+");
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (coords.length != 3) {
            Logger.getLogger("rendertoolkit").info("[ObjFileImporter] Wrong coordinates number " + coords.length + " at line " + this.lineNumber + " : " + this.currentLine);
        } else {
            x = Float.parseFloat(coords[0]);
            y = Float.parseFloat(coords[1]);
            z = Float.parseFloat(coords[2]);
        }
        this.vertexes.add(new Vertex(x, y, z));
    }

    private void addUV(String data) {
        String[] coords = data.split("\\s+");
        float u = 0.0f;
        float v = 0.0f;
        if (coords.length != 2) {
            Logger.getLogger("rendertoolkit").info("[ObjFileImporter] Wrong UV coordinates number " + coords.length + " at line " + this.lineNumber + " : " + this.currentLine);
        } else {
            u = Float.parseFloat(coords[0]);
            v = 1.0f - Float.parseFloat(coords[1]);
        }
        this.uvs.add(new UV(u, v));
    }

    private void addNormal(String data) {
        String[] coords = data.split("\\s+");
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (coords.length != 3) {
            Logger.getLogger("rendertoolkit").info("[ObjFileImporter] Wrong Normal coordinates number " + coords.length + " at line " + this.lineNumber + " : " + this.currentLine);
        } else {
            x = Float.parseFloat(coords[0]);
            y = Float.parseFloat(coords[1]);
            z = Float.parseFloat(coords[2]);
        }
        this.normals.add(new Vector(x, y, z));
    }

    private void addFace(String data) {
        this.matcher = facePattern.matcher(data);
        ArrayList<Vertex> faceVertex = new ArrayList<Vertex>();
        ArrayList<Vector> faceNormals = new ArrayList<Vector>();
        int v = 0;
        int t = 0;
        int n = 0;
        UV uv = null;
        while (this.matcher.find()) {
            Vector normal = null;
            uv = null;
            String strV = this.matcher.group("v");
            String strT = this.matcher.group("t");
            String strN = this.matcher.group("n");
            v = Integer.parseInt(strV);
            Vertex vertex = this.vertexes.get(v > 0 ? v - 1 : this.vertexes.size() - v - 1);
            if (vertex != null) {
                Vertex vertexCopy = new Vertex(vertex);
                if (strT != null && (uv = this.uvs.get((t = Integer.parseInt(strT)) > 0 ? t - 1 : this.uvs.size() - t - 1)) != null) {
                    vertexCopy.setUV(uv.u, uv.v);
                }
                faceVertex.add(vertexCopy);
                if (strN == null) continue;
                n = Integer.parseInt(strN);
                int n2 = n = n > 0 ? n - 1 : this.normals.size() - n - 1;
                if (n >= 0 && n < this.normals.size()) {
                    normal = this.normals.get(n);
                }
                if (normal == null) continue;
                faceNormals.add(new Vector(normal.x, normal.y, normal.z));
                continue;
            }
            Logger.getLogger("rendertoolkit").info("[ObjFileImporter] Wrong vertex reference " + this.lineNumber + " for face at line " + this.currentLine);
        }
        Face f = new Face(faceVertex);
        switch (f.getVertexes().length) {
            case 4: {
                this.facesQuad.add(f);
                break;
            }
            case 3: {
                this.facesTri.add(f);
            }
        }
        this.faces.add(f);
    }

    private void addShape(String data) {
        if (this.faces.size() != 0) {
            Shape s = new Shape(this.faces);
            this.shapes.put(this.currentShape.toLowerCase(), s);
            this.faces.clear();
        }
        if (data != "") {
            this.currentShape = data.indexOf(95) != -1 ? data.substring(0, data.indexOf(95)) : data;
        }
    }

    private class UV {
        float u;
        float v;

        public UV(float u, float v) {
            this.u = u;
            this.v = v;
        }
    }
}

