/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.common;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLOverlay;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLWorld;
import ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj.Face;
import ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj.objParser;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IOBJModel;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class OBJModelOC
extends WidgetGLWorld
implements IOBJModel {
    public Tessellator TESR;
    public BufferBuilder buffer;
    private String objData = "";
    public objParser objFile = null;

    @Override
    public void loadOBJ(String objData) {
        this.objData = objData;
        this.objFile = objData.length() > 0 ? new objParser(objData) : null;
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        buff.writeBoolean(!this.objData.equals("none"));
        if (!this.objData.equals("none")) {
            byte[] utf8Bytes = this.objData.getBytes(Charsets.UTF_8);
            buff.writeInt(utf8Bytes.length);
            buff.writeBytes(utf8Bytes);
        }
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        if (buff.readBoolean()) {
            this.loadOBJ(buff.readBytes(buff.readInt()).toString(Charsets.UTF_8));
        } else {
            this.loadOBJ("");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableOBJModel();
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderableOBJModel
    extends WidgetGLOverlay.RenderableGLWidget {
        public VertexFormat malisisVertexFormat;

        public RenderableOBJModel() {
            super(OBJModelOC.this);
            this.malisisVertexFormat = new VertexFormat(){
                {
                    this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
                    this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.UBYTE, VertexFormatElement.EnumUsage.COLOR, 4));
                    this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2));
                    this.func_181721_a(new VertexFormatElement(1, VertexFormatElement.EnumType.SHORT, VertexFormatElement.EnumUsage.UV, 2));
                    this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.NORMAL, 3));
                    this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.PADDING, 1));
                }
            };
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            if (OBJModelOC.this.objFile == null) {
                return;
            }
            int color = this.preRender(conditionStates);
            this.applyModifiers(conditionStates);
            OBJModelOC.this.TESR = Tessellator.func_178181_a();
            OBJModelOC.this.buffer = OBJModelOC.this.TESR.func_178180_c();
            if (OBJModelOC.this.rendertype == RenderType.WorldLocated) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.addPlayerRotation(player);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (OBJModelOC.this.objFile.facesTri.size() > 0) {
                OBJModelOC.this.buffer.func_181668_a(4, this.malisisVertexFormat);
                this.renderList(OBJModelOC.this.objFile.facesTri, color);
                OBJModelOC.this.TESR.func_78381_a();
            }
            if (OBJModelOC.this.objFile.facesQuad.size() > 0) {
                OBJModelOC.this.buffer.func_181668_a(7, this.malisisVertexFormat);
                this.renderList(OBJModelOC.this.objFile.facesQuad, color);
                OBJModelOC.this.TESR.func_78381_a();
            }
            this.postRender();
        }

        public void renderList(List<Face> faces, int color) {
            for (Face f : faces) {
                for (int i = 0; i < f.getVertexes().length; ++i) {
                    OBJModelOC.this.buffer.func_178981_a(f.getVertexes()[i].setColor(color).setAlpha(color >> 24).getVertexData(this.malisisVertexFormat, null));
                }
            }
        }
    }
}

