/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets;

import ben_mkiv.commons0815.chickenbones.Matrix4;
import ben_mkiv.commons0815.utils.utilsCommon;
import ben_mkiv.rendertoolkit.common.widgets.WidgetModifier;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IEasing;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierAutoTranslate;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierColor;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierRotate;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierScale;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierTexture;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierTranslate;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.vecmath.Vector3f;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class WidgetModifiers {
    public ArrayList<WidgetModifier> modifiers = new ArrayList();
    public long lastConditionStates;
    private Vec3d lastOffset = new Vec3d(0.0, 0.0, 0.0);

    public void setCondition(int modifierIndex, short conditionIndex, boolean state) {
        this.modifiers.get(modifierIndex).configureCondition(conditionIndex, state);
    }

    public void addEasing(int modifierIndex, String type, String typeIO, float duration, String list, float min, float max, String mode) {
        if (!(this.modifiers.get(modifierIndex) instanceof IEasing)) {
            return;
        }
        ((IEasing)((Object)this.modifiers.get(modifierIndex))).addEasing(type, typeIO, duration, list, min, max, mode);
    }

    public void removeEasing(int modifierIndex, String list) {
        if (!(this.modifiers.get(modifierIndex) instanceof IEasing)) {
            return;
        }
        ((IEasing)((Object)this.modifiers.get(modifierIndex))).removeEasing(list);
    }

    public void update(int modifierIndex, float[] args) {
        this.modifiers.get(modifierIndex).update(args);
    }

    public int addTranslate(float x, float y, float z) {
        this.modifiers.add(new WidgetModifierTranslate(x, y, z));
        return this.modifiers.size() - 1;
    }

    public int addAutoTranslate(float x, float y) {
        this.modifiers.add(new WidgetModifierAutoTranslate(x, y));
        return this.modifiers.size() - 1;
    }

    public int addScale(float x, float y, float z) {
        this.modifiers.add(new WidgetModifierScale(x, y, z));
        return this.modifiers.size() - 1;
    }

    public int addRotate(float deg, float x, float y, float z) {
        this.modifiers.add(new WidgetModifierRotate(deg, x, y, z));
        return this.modifiers.size() - 1;
    }

    public int addColor(float r, float g, float b, float alpha) {
        this.modifiers.add(new WidgetModifierColor(r, g, b, alpha));
        return this.modifiers.size() - 1;
    }

    public int addTexture(String texloc) {
        this.modifiers.add(new WidgetModifierTexture(texloc));
        return this.modifiers.size() - 1;
    }

    public void revoke(long conditionStates) {
        int i = this.modifiers.size();
        while (i > 0) {
            this.modifiers.get(--i).revoke(conditionStates);
        }
    }

    public void revoke(long conditionStates, ArrayList<WidgetModifier.WidgetModifierType> modifierTypes) {
        int i = this.modifiers.size();
        while (i > 0) {
            WidgetModifier e = this.modifiers.get(--i);
            for (WidgetModifier.WidgetModifierType x : modifierTypes) {
                if (!e.getType().equals((Object)x)) continue;
                e.revoke(conditionStates);
            }
        }
    }

    public void remove(int element) {
        this.modifiers.remove(element);
    }

    public WidgetModifier.WidgetModifierType getType(int element) {
        return this.modifiers.get(element).getType();
    }

    public int getCurrentColor(long conditionStates, int index) {
        float[] col = this.getCurrentColorFloat(conditionStates, index);
        return utilsCommon.getIntFromColor(col[0], col[1], col[2], col[3]);
    }

    public float[] getCurrentColorFloat(int index) {
        return this.getCurrentColorFloat(this.lastConditionStates, index);
    }

    public float[] getCurrentColorFloat(long conditionStates, int index) {
        for (int i = this.modifiers.size() - 1; i >= 0; --i) {
            if (this.modifiers.get(i).getType() != WidgetModifier.WidgetModifierType.COLOR || !this.modifiers.get(i).shouldApplyModifier(conditionStates)) continue;
            if (index > 0) {
                --index;
                continue;
            }
            Object[] color = this.modifiers.get(i).getValues();
            return new float[]{((Float)color[0]).floatValue(), ((Float)color[1]).floatValue(), ((Float)color[2]).floatValue(), ((Float)color[3]).floatValue()};
        }
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }

    public float[] getCurrentScaleFloat(long conditionStates) {
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        for (int i = 0; i < this.modifiers.size(); ++i) {
            if (this.modifiers.get(i).getType() != WidgetModifier.WidgetModifierType.SCALE || !this.modifiers.get(i).shouldApplyModifier(conditionStates)) continue;
            Object[] scale = this.modifiers.get(i).getValues();
            scaleX *= ((Float)scale[0]).floatValue();
            scaleY *= ((Float)scale[1]).floatValue();
            scaleZ *= ((Float)scale[2]).floatValue();
        }
        return new float[]{scaleX, scaleY, scaleZ};
    }

    public void apply(long conditionStates) {
        this.lastConditionStates = conditionStates;
        int count = this.modifiers.size();
        for (int i = 0; i < count; ++i) {
            this.modifiers.get(i).apply(conditionStates);
        }
    }

    public Vec3d getRenderPosition(long conditionStates, Vec3d offset, int w, int h, int d) {
        Vec3d renderPosition = this.generateGlMatrix(conditionStates, w, h, d);
        this.lastOffset = offset;
        return new Vec3d(renderPosition.field_72450_a + offset.field_72450_a, renderPosition.field_72448_b + offset.field_72448_b, renderPosition.field_72449_c + offset.field_72449_c);
    }

    public Vec3d getRenderPosition(EntityPlayer player) {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public Vec3d generateGlMatrix(long conditionStates, float w, float h, float d) {
        Matrix4 m = new Matrix4();
        int count = this.modifiers.size();
        block6: for (int i = 0; i < count; ++i) {
            if (!this.modifiers.get(i).shouldApplyModifier(conditionStates)) continue;
            switch (this.modifiers.get(i).getType()) {
                case AUTOTRANSLATE: {
                    Object[] b = this.modifiers.get(i).getValues();
                    m.translate(new Vector3f(((Float)b[0]).floatValue() * (w / 100.0f), ((Float)b[1]).floatValue() * (h / 100.0f), d));
                    continue block6;
                }
                case TRANSLATE: {
                    Object[] b = this.modifiers.get(i).getValues();
                    m.translate(new Vector3f(((Float)b[0]).floatValue(), ((Float)b[1]).floatValue(), ((Float)b[2]).floatValue()));
                    continue block6;
                }
                case SCALE: {
                    Object[] b = this.modifiers.get(i).getValues();
                    m.scale(new Vector3f(((Float)b[0]).floatValue(), ((Float)b[1]).floatValue(), ((Float)b[2]).floatValue()));
                    continue block6;
                }
                case ROTATE: {
                    Object[] b = this.modifiers.get(i).getValues();
                    m.rotate(((Float)b[0]).floatValue(), new Vector3f(((Float)b[1]).floatValue(), ((Float)b[2]).floatValue(), ((Float)b[3]).floatValue()));
                }
            }
        }
        return m.apply(new Vec3d(0.0, 0.0, 0.0));
    }

    public void writeData(ByteBuf buff) {
        int modifierCount = this.modifiers.size();
        buff.writeInt(modifierCount);
        for (int i = 0; i < modifierCount; ++i) {
            buff.writeShort(this.modifiers.get(i).getType().ordinal());
            this.modifiers.get(i).writeData(buff);
        }
    }

    public void readData(ByteBuf buff) {
        ArrayList<WidgetModifier> modifiersNew = new ArrayList<WidgetModifier>();
        int modifierCount = buff.readInt();
        for (int i = 0; i < modifierCount; ++i) {
            switch (WidgetModifier.WidgetModifierType.values()[buff.readShort()]) {
                case TRANSLATE: {
                    modifiersNew.add(new WidgetModifierTranslate(0.0f, 0.0f, 0.0f));
                    break;
                }
                case COLOR: {
                    modifiersNew.add(new WidgetModifierColor(0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case SCALE: {
                    modifiersNew.add(new WidgetModifierScale(0.0f, 0.0f, 0.0f));
                    break;
                }
                case ROTATE: {
                    modifiersNew.add(new WidgetModifierRotate(0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case TEXTURE: {
                    modifiersNew.add(new WidgetModifierTexture(null));
                    break;
                }
                case AUTOTRANSLATE: {
                    modifiersNew.add(new WidgetModifierAutoTranslate(0.0f, 0.0f));
                    break;
                }
                default: {
                    modifiersNew.remove(i);
                    return;
                }
            }
            ((WidgetModifier)modifiersNew.get(i)).readData(buff);
        }
        this.modifiers = modifiersNew;
    }
}

