/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.books;

import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import pcl.openprinter.books.BookPage;
import pcl.openprinter.books.GenericBook;

public class VanillaBook
extends GenericBook {
    public Object[] readFromStack(ItemStack book) {
        if (!book.func_77942_o() || !book.func_77978_p().func_74764_b("pages")) {
            return new Object[]{false, "book doesnt have nbt data"};
        }
        if (book.func_77973_b() instanceof ItemWritableBook) {
            this.readUnsignedBookFromStack(book);
        } else if (book.func_77973_b() instanceof ItemWrittenBook) {
            this.readSignedBookFromStack(book);
        }
        return new Object[]{this.get()};
    }

    private void readUnsignedBookFromStack(ItemStack book) {
        NBTTagList tags = book.func_77978_p().func_150295_c("pages", 8);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            BookPage page = new BookPage(i + 1);
            int l = 1;
            for (String line : tags.func_150307_f(i).split("\n")) {
                page.addLine(line, l, 0);
                ++l;
            }
            this.addPage(page);
        }
    }

    private void readSignedBookFromStack(ItemStack book) {
        this.isSigned = true;
        this.title = book.func_77978_p().func_74779_i("title");
        this.author = book.func_77978_p().func_74779_i("author");
        NBTTagList tags = book.func_77978_p().func_150295_c("pages", 8);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            BookPage page = new BookPage(i + 1);
            int l = 1;
            for (String line : ITextComponent.Serializer.func_150699_a((String)tags.func_150307_f(i)).func_150260_c().split("\n")) {
                page.addLine(line, l, 0);
                ++l;
            }
            this.addPage(page);
        }
    }
}

