/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.danknull.blocks.BlockDankNullDock;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.gui.GuiDankNull;
import p455w0rd.danknull.container.ContainerDankNull;
import p455w0rd.danknull.container.ContainerDankNullDock;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModItems;
import p455w0rd.danknull.init.ModKeyBindings;
import p455w0rd.danknull.init.ModLogger;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.items.ItemBlockDankNullDock;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.items.ItemDankNullPanel;
import p455w0rd.danknull.network.PacketConfigSync;
import p455w0rd.danknull.network.PacketSetSelectedItem;
import p455w0rd.danknull.network.PacketSyncDankNull;
import p455w0rd.danknull.network.PacketSyncDankNullDock;
import p455w0rd.danknull.recipes.RecipeDankNullUpgrade;
import p455w0rd.danknull.util.NonNullListSerializable;
import p455w0rd.danknull.util.WeakHashMapSerializable;
import p455w0rdslib.util.GuiUtils;
import p455w0rdslib.util.ItemNBTUtils;
import p455w0rdslib.util.ItemUtils;
import p455w0rdslib.util.NBTUtils;
import p455w0rdslib.util.RenderUtils;
import p455w0rdslib.util.TextUtils;

public class DankNullUtils {
    public static PlayerSlot getDankNullSlot(EntityPlayer player) {
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        if (mainHand.func_77973_b() instanceof ItemDankNull) {
            return new PlayerSlot(playerInv.field_70461_c, PlayerSlot.EnumInvCategory.MAIN);
        }
        if (offHand.func_77973_b() instanceof ItemDankNull) {
            return new PlayerSlot(0, PlayerSlot.EnumInvCategory.OFF_HAND);
        }
        for (int i = 0; i < playerInv.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)playerInv.field_70462_a.get(i);
            if (!(stack.func_77973_b() instanceof ItemDankNull)) continue;
            return new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN);
        }
        return null;
    }

    public static ItemStack getDockedDankNull(ItemStack dankNullDock) {
        NBTTagCompound nbt;
        if (dankNullDock.func_77942_o() && dankNullDock.func_77978_p().func_150297_b("BlockEntityTag", 10) && !(nbt = dankNullDock.func_77978_p().func_74775_l("BlockEntityTag")).func_82582_d()) {
            return new ItemStack(nbt.func_74775_l("DankNullStack"));
        }
        return ItemStack.field_190927_a;
    }

    public static void setDockedDankNull(ItemStack dankNullDock, ItemStack newDankNull) {
        if (!dankNullDock.func_77942_o()) {
            dankNullDock.func_77982_d(new NBTTagCompound());
        }
        if (dankNullDock.func_77978_p().func_150297_b("BlockEntityTag", 10)) {
            NBTTagCompound nbt = dankNullDock.func_77978_p().func_74775_l("BlockEntityTag");
            nbt.func_74782_a("DankNullStack", (NBTBase)newDankNull.serializeNBT());
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("DankNullStack", (NBTBase)newDankNull.serializeNBT());
            dankNullDock.func_77978_p().func_74782_a("BlockEntityTag", (NBTBase)nbt);
        }
    }

    public static ItemStack getDockedDankNull(TileEntity dankDock) {
        if (DankNullUtils.isDankNullDock(dankDock)) {
            return ((TileDankNullDock)dankDock).getDankNull();
        }
        return ItemStack.field_190927_a;
    }

    public static List<PlayerSlot> getAllDankNulls(EntityPlayer player) {
        int i;
        InventoryPlayer playerInv = player.field_71071_by;
        ArrayList dankNullList = Lists.newArrayList();
        for (i = 0; i < playerInv.field_70462_a.size(); ++i) {
            if (!DankNullUtils.isDankNull((ItemStack)playerInv.field_70462_a.get(i))) continue;
            dankNullList.add(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN));
        }
        for (i = 0; i < playerInv.field_184439_c.size(); ++i) {
            if (!DankNullUtils.isDankNull((ItemStack)playerInv.field_184439_c.get(i))) continue;
            dankNullList.add(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN));
        }
        return dankNullList;
    }

    public static PlayerSlot getDankNullForStack(EntityPlayer player, ItemStack stack) {
        List<PlayerSlot> dankNulls = DankNullUtils.getAllDankNulls(player);
        for (PlayerSlot slot : dankNulls) {
            ItemStack itemStack = slot.getStackInSlot(player);
            if (!(itemStack.func_77973_b() instanceof ItemDankNull)) continue;
            if (DankNullUtils.isFiltered(DankNullUtils.getNewDankNullInventory(slot, player), stack)) {
                return slot;
            }
            if (!DankNullUtils.isFilteredOreDict(DankNullUtils.getNewDankNullInventory(slot, player), stack)) continue;
            return slot;
        }
        return null;
    }

    public static void setStackInSlot(ItemStack dankNull, int index, ItemStack stack) {
        InventoryDankNull inv = DankNullUtils.getNewDankNullInventory(dankNull);
        inv.func_70299_a(index, stack);
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        inv.saveInventory(dankNull.func_77978_p());
    }

    public static ItemStack decrStackSize(ItemStack dankNull, int index, int amount) {
        InventoryDankNull inv = DankNullUtils.getNewDankNullInventory(dankNull);
        ItemStack ret = inv.func_70298_a(index, amount);
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        inv.saveInventory(dankNull.func_77978_p());
        return ret;
    }

    public static boolean isDankDock(Object obj) {
        return obj != null && obj instanceof TileDankNullDock || obj instanceof BlockDankNullDock || obj instanceof ItemBlockDankNullDock;
    }

    public static void reArrangeStacks(TileDankNullDock dankDock) {
        if (DankNullUtils.isDankDock(dankDock) && !dankDock.getDankNull().func_190926_b()) {
            InventoryDankNull tmpInv = DankNullUtils.getNewDankNullInventory(dankDock.getDankNull());
            DankNullUtils.reArrangeStacks(dankDock.getDankNull());
        }
    }

    public static void reArrangeStacks(ItemStack dankNull) {
        if (DankNullUtils.isDankNull(dankNull)) {
            InventoryDankNull tmpInv = DankNullUtils.getNewDankNullInventory(dankNull);
            DankNullUtils.reArrangeStacks(tmpInv);
            tmpInv.func_70296_d();
        }
    }

    public static void reArrangeStacks(InventoryDankNull inventory) {
        if (inventory != null) {
            int i;
            int count = 0;
            NonNullList stackList = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                stackList.set(count, (Object)inventory.func_70301_a(i));
                ++count;
            }
            if (stackList.size() == 0) {
                DankNullUtils.setSelectedStackIndex(inventory, -1);
            } else {
                for (i = 0; i < stackList.size(); ++i) {
                    inventory.func_70299_a(i, (ItemStack)stackList.get(i));
                }
                for (i = stackList.size(); i < inventory.func_70302_i_(); ++i) {
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
            DankNullUtils.setSelectedIndexApplicable(inventory);
        }
    }

    public static IMessage getSyncPacket(GuiDankNull gui) {
        if (gui.isTile()) {
            ContainerDankNullDock c = (ContainerDankNullDock)gui.field_147002_h;
            return new PacketSyncDankNullDock(c.getTile(), c.getDankNull());
        }
        return new PacketSyncDankNull((Pair<Integer, ItemStack>)Pair.of((Object)gui.getDankNullInventory().getPlayerSlotIndex(), (Object)gui.getDankNull()));
    }

    public static NonNullList<ItemStack> getInventoryListArray(InventoryDankNull inventory) {
        if (inventory != null) {
            return inventory.getStacks();
        }
        return NonNullList.func_191196_a();
    }

    public static int getSelectedStackIndex(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            return DankNullUtils.getSelectedStackIndex(inventory.getDankNull());
        }
        return -1;
    }

    public static int getSelectedStackIndex(ItemStack dankNull) {
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        if (!dankNull.func_77978_p().func_74764_b("selectedIndex")) {
            dankNull.func_77978_p().func_74768_a("selectedIndex", 0);
        }
        return dankNull.func_77978_p().func_74762_e("selectedIndex");
    }

    public static boolean isDankNull(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemDankNull;
    }

    public static ItemStack makeDankNullCreative(ItemStack dankNull) {
        ItemStack creativeDankNull = dankNull.func_77946_l();
        if (DankNullUtils.isDankNull(creativeDankNull) && !DankNullUtils.isCreativeDankNull(creativeDankNull) && DankNullUtils.getMeta(creativeDankNull) != 6) {
            ItemStack newStack = new ItemStack((Item)ModItems.CREATIVE_DANKNULL);
            if (creativeDankNull.func_77942_o()) {
                newStack.func_77982_d(creativeDankNull.func_77978_p());
            }
            return newStack;
        }
        return creativeDankNull;
    }

    public static boolean isCreativeDankNull(ItemStack stack) {
        return DankNullUtils.isDankNull(stack) && stack.func_77973_b() == ModItems.CREATIVE_DANKNULL;
    }

    public static boolean isDankNullPanel(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemDankNullPanel;
    }

    public static boolean isDankNullDock(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlockDankNullDock;
    }

    public static boolean isDankNullDock(TileEntity tile) {
        return tile instanceof TileDankNullDock;
    }

    public static boolean isDankNullDockEmpty(ItemStack dankDock) {
        return DankNullUtils.isDankNullDock(dankDock) && DankNullUtils.getDockedDankNull(dankDock).func_190926_b();
    }

    public static int getMeta(ItemStack stack) {
        if (DankNullUtils.isDankNull(stack)) {
            return ((ItemDankNull)stack.func_77973_b()).getTier().ordinal();
        }
        if (DankNullUtils.isDankNullPanel(stack)) {
            return ((ItemDankNullPanel)stack.func_77973_b()).getTier().ordinal();
        }
        if (DankNullUtils.isDankNullDock(stack)) {
            return !DankNullUtils.isDankNullDockEmpty(stack) ? ((ItemDankNull)DankNullUtils.getDockedDankNull(stack).func_77973_b()).getTier().ordinal() : -1;
        }
        return -1;
    }

    public static boolean isCreativeDankNullLocked(ItemStack dankNull) {
        if (DankNullUtils.isCreativeDankNull(dankNull)) {
            return dankNull.func_77942_o() && dankNull.func_77978_p().func_150297_b("Locked", 1) && dankNull.func_77978_p().func_74767_n("Locked");
        }
        return false;
    }

    public static void setLocked(ItemStack creativeDankNull, boolean locked) {
        if (DankNullUtils.isCreativeDankNull(creativeDankNull)) {
            if (!creativeDankNull.func_77942_o()) {
                creativeDankNull.func_77982_d(new NBTTagCompound());
            }
            creativeDankNull.func_77978_p().func_74757_a("Locked", locked);
        }
    }

    public static void setSelectedStackIndex(InventoryDankNull inventory, int index) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            ItemStack dankNull = inventory.getDankNull();
            DankNullUtils.setSelectedStackIndex(dankNull, index);
        }
    }

    public static void setSelectedStackIndex(ItemStack dankNull, int index) {
        ItemNBTUtils.setInteger((ItemStack)dankNull, (String)"selectedIndex", (int)index);
    }

    public static void setNextSelectedStack(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            DankNullUtils.setNextSelectedStack(inventory, null);
        }
    }

    public static void setNextSelectedStack(InventoryDankNull inventory, EntityPlayer player) {
        int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
        int totalSize = DankNullUtils.getItemCount(inventory);
        int maxIndex = totalSize - 1;
        int newIndex = 0;
        if (totalSize > 1) {
            if (currentIndex == maxIndex) {
                newIndex = 0;
                ModNetworking.getInstance().sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            } else {
                newIndex = currentIndex + 1;
                ModNetworking.getInstance().sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            }
        }
    }

    public static void setPreviousSelectedStack(InventoryDankNull inventory, EntityPlayer player) {
        int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
        int totalSize = DankNullUtils.getItemCount(inventory);
        int maxIndex = totalSize - 1;
        int newIndex = 0;
        if (totalSize > 1) {
            if (currentIndex == 0) {
                newIndex = maxIndex;
                ModNetworking.getInstance().sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            } else {
                newIndex = currentIndex - 1;
                ModNetworking.getInstance().sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            }
        }
    }

    public static int getItemCount(InventoryDankNull inventory) {
        int count = 0;
        if (inventory != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_190926_b()) continue;
                ++count;
            }
        }
        return count;
    }

    public static void decrSelectedStackSize(InventoryDankNull inventory, int amount) {
        if (inventory == null || inventory.getDankNull().func_190926_b()) {
            return;
        }
        DankNullUtils.getSelectedStack(inventory).func_190918_g(amount);
        DankNullUtils.reArrangeStacks(inventory);
    }

    public static int getSelectedStackSize(InventoryDankNull inventory) {
        ItemStack selectedStack;
        if (inventory != null && !inventory.getDankNull().func_190926_b() && !(selectedStack = DankNullUtils.getSelectedStack(inventory)).func_190926_b()) {
            return selectedStack.func_190916_E();
        }
        return 0;
    }

    public static InventoryDankNull getInventoryFromHeld(EntityPlayer player) {
        if (player != null) {
            if (DankNullUtils.isDankNull(player.func_184614_ca())) {
                return new InventoryDankNull(new PlayerSlot(player.field_71071_by.field_70461_c, PlayerSlot.EnumInvCategory.MAIN), player);
            }
            if (DankNullUtils.isDankNull(player.func_184592_cb())) {
                return new InventoryDankNull(new PlayerSlot(0, PlayerSlot.EnumInvCategory.OFF_HAND), player);
            }
        }
        return null;
    }

    public static ItemStack getSelectedStack(ItemStack dankNull) {
        NBTTagList itemList;
        int selectedIndex;
        if (!dankNull.func_77942_o()) {
            DankNullUtils.setSelectedStackIndex(dankNull, DankNullUtils.isEmpty(dankNull) ? -1 : 0);
        }
        if ((selectedIndex = ItemNBTUtils.getInt((ItemStack)dankNull, (String)"selectedIndex")) > -1 && ItemNBTUtils.hasNBTTagList((ItemStack)dankNull, (String)"danknull-inventory") && selectedIndex < (itemList = ItemNBTUtils.getNBTTagList((ItemStack)dankNull, (String)"danknull-inventory")).func_74745_c()) {
            NBTTagCompound currentNBT = itemList.func_150305_b(selectedIndex);
            ItemStack ret = new ItemStack(currentNBT);
            if (NBTUtils.hasInt((NBTTagCompound)currentNBT, (String)"RealCount")) {
                ret.func_190920_e(NBTUtils.getInt((NBTTagCompound)currentNBT, (String)"RealCount"));
            }
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getSelectedStack(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            int selectedIndex;
            ItemStack dankNull = inventory.getDankNull();
            if (!dankNull.func_77942_o()) {
                DankNullUtils.setSelectedStackIndex(inventory, DankNullUtils.isEmpty(inventory) ? 1 : 0);
            }
            if ((selectedIndex = ItemNBTUtils.getInt((ItemStack)dankNull, (String)"selectedIndex")) > -1) {
                return inventory.func_70301_a(selectedIndex);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isEmpty(InventoryDankNull inventory) {
        return inventory.func_191420_l();
    }

    private static boolean isEmpty(ItemStack dankNull) {
        return DankNullUtils.isEmpty(DankNullUtils.getNewDankNullInventory(dankNull));
    }

    public static boolean isFiltered(ItemStack dankNull, ItemStack filteredStack) {
        return DankNullUtils.isFiltered(DankNullUtils.getNewDankNullInventory(dankNull), filteredStack);
    }

    public static boolean isFiltered(InventoryDankNull inventory, ItemStack filteredStack) {
        if (inventory != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_190926_b() || !ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)inventory.func_70301_a(i), (ItemStack)filteredStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFilteredOreDict(InventoryDankNull inventory, ItemStack filteredStack) {
        if (DankNullUtils.isOreDictBlacklistEnabled() && !DankNullUtils.isItemOreDictBlacklisted(filteredStack) || DankNullUtils.isOreDictWhitelistEnabled() && DankNullUtils.isItemOreDictWhitelisted(filteredStack) || !DankNullUtils.isOreDictBlacklistEnabled() && !DankNullUtils.isOreDictWhitelistEnabled()) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)filteredStack);
            if (inventory != null && ids.length > 0) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i).func_190926_b() || !DankNullUtils.isItemOreDicted(inventory.func_70301_a(i)) || !DankNullUtils.isItemOreDicted(filteredStack) || !DankNullUtils.getOreDictModeForStack(inventory.getDankNull(), inventory.func_70301_a(i))) continue;
                    int[] ids2 = OreDictionary.getOreIDs((ItemStack)inventory.func_70301_a(i));
                    for (int id : ids) {
                        String name = OreDictionary.getOreName((int)id);
                        for (int id2 : ids2) {
                            if (!name.equals(OreDictionary.getOreName((int)id2))) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean isOreDictBlacklistEnabled() {
        return !ModConfig.Options.getOreBlacklist().isEmpty() && !DankNullUtils.isOreDictWhitelistEnabled();
    }

    public static boolean isOreDictWhitelistEnabled() {
        return !ModConfig.Options.getOreWhitelist().isEmpty();
    }

    public static boolean isItemOreDictBlacklisted(ItemStack stack) {
        if (DankNullUtils.isOreDictBlacklistEnabled()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!ModConfig.Options.getOreBlacklist().contains(OreDictionary.getOreName((int)id))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isItemOreDictWhitelisted(ItemStack stack) {
        if (DankNullUtils.isOreDictWhitelistEnabled()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!ModConfig.Options.getOreWhitelist().contains(OreDictionary.getOreName((int)id))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canStackBeAdded(InventoryDankNull inventory, ItemStack stack) {
        if (DankNullUtils.isDankNull(inventory.getDankNull())) {
            return DankNullUtils.canStackBeAdded(inventory.getDankNull(), stack);
        }
        return false;
    }

    public static boolean canStackBeAdded(ItemStack dankNull, ItemStack stack) {
        if (DankNullUtils.isDankNull(dankNull) && DankNullUtils.isCreativeDankNull(dankNull)) {
            NonNullListSerializable<ItemStack> whiteList = null;
            try {
                whiteList = ModConfig.Options.getCreativeWhitelistedItems();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (whiteList != null && !whiteList.isEmpty()) {
                Iterator iterator = whiteList.iterator();
                while (iterator.hasNext()) {
                    ItemStack whiteListedStack = (ItemStack)iterator.next();
                    if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)stack, (ItemStack)whiteListedStack)) continue;
                    return true;
                }
                return false;
            }
            NonNullListSerializable<ItemStack> blackList = null;
            try {
                blackList = ModConfig.Options.getCreativeBlacklistedItems();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (blackList != null && !blackList.isEmpty()) {
                Iterator iterator = blackList.iterator();
                while (iterator.hasNext()) {
                    ItemStack blackListedStack = (ItemStack)iterator.next();
                    if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)stack, (ItemStack)blackListedStack)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean addUnfiliteredStackToDankNull(ContainerDankNull container, ItemStack stack) {
        if (container.getDankNullInventory() != null && DankNullUtils.canStackBeAdded(container.getDankNullInventory(), stack)) {
            ((Slot)container.field_75151_b.get(DankNullUtils.getNextAvailableSlot(container))).func_75215_d(stack);
            return true;
        }
        return false;
    }

    public static boolean addUnfiliteredStackToDankNull(InventoryDankNull inventory, ItemStack stack) {
        if (!inventory.getDankNull().func_190926_b() && DankNullUtils.canStackBeAdded(inventory, stack)) {
            inventory.func_70299_a(DankNullUtils.getNextAvailableSlot(inventory), stack);
            return true;
        }
        return false;
    }

    public static int getNextAvailableSlot(ContainerDankNull container) {
        if (DankNullUtils.isCreativeDankNull(container.getDankNull()) && DankNullUtils.isCreativeDankNullLocked(container.getDankNull())) {
            return -1;
        }
        for (int i = 36; i < container.field_75151_b.size(); ++i) {
            Slot s = (Slot)container.field_75151_b.get(i);
            if (s == null || !s.func_75211_c().func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static int getNextAvailableSlot(InventoryDankNull inventory) {
        if (DankNullUtils.isCreativeDankNull(inventory.getDankNull()) && DankNullUtils.isCreativeDankNullLocked(inventory.getDankNull())) {
            return -1;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static boolean addFilteredStackToDankNull(ItemStack dankNull, ItemStack filteredStack) {
        InventoryDankNull tmpInv;
        if (DankNullUtils.isDankNull(dankNull) && DankNullUtils.canStackBeAdded(dankNull, filteredStack) && DankNullUtils.getIndexForStack(tmpInv = DankNullUtils.getNewDankNullInventory(dankNull), filteredStack) >= 0) {
            ItemStack currentStack = DankNullUtils.getFilteredStack(tmpInv, filteredStack);
            if (!(currentStack.func_190926_b() || filteredStack.func_190926_b() || ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)filteredStack))) {
                filteredStack = DankNullUtils.convertToOreDictedStack(filteredStack, currentStack);
            }
            if (filteredStack.func_190916_E() < Integer.MAX_VALUE) {
                long currentSize = currentStack.func_190916_E();
                long maxDankNullStackSize = DankNullUtils.getTier(dankNull).getMaxStackSize();
                if (currentSize + (long)filteredStack.func_190916_E() > maxDankNullStackSize) {
                    currentStack.func_190920_e((int)maxDankNullStackSize);
                } else {
                    currentStack.func_190920_e((int)currentSize + filteredStack.func_190916_E());
                }
                tmpInv.func_70299_a(DankNullUtils.getIndexForStack(tmpInv, filteredStack), currentStack);
                dankNull = tmpInv.getDankNull();
                return true;
            }
        }
        return false;
    }

    public static boolean addFilteredStackToDankNull(InventoryDankNull inventory, ItemStack filteredStack) {
        if (DankNullUtils.canStackBeAdded(inventory, filteredStack) && DankNullUtils.getIndexForStack(inventory, filteredStack) >= 0) {
            ItemStack currentStack = DankNullUtils.getFilteredStack(inventory, filteredStack);
            if (!(currentStack.func_190926_b() || filteredStack.func_190926_b() || ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)filteredStack))) {
                filteredStack = DankNullUtils.convertToOreDictedStack(filteredStack, currentStack);
            }
            if (filteredStack.func_190916_E() < Integer.MAX_VALUE) {
                long currentSize = currentStack.func_190916_E();
                long maxDankNullStackSize = DankNullUtils.getTier(inventory).getMaxStackSize();
                if (currentSize + (long)filteredStack.func_190916_E() > maxDankNullStackSize) {
                    currentStack.func_190920_e((int)maxDankNullStackSize);
                } else {
                    currentStack.func_190920_e((int)currentSize + filteredStack.func_190916_E());
                }
                inventory.func_70299_a(DankNullUtils.getIndexForStack(inventory, filteredStack), currentStack);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getFilteredStack(InventoryDankNull inventory, ItemStack stack) {
        if (DankNullUtils.isFiltered(inventory, stack) || DankNullUtils.isFilteredOreDict(inventory, stack)) {
            return DankNullUtils.getItemByIndex(inventory, DankNullUtils.getIndexForStack(inventory, stack));
        }
        return ItemStack.field_190927_a;
    }

    public static int getIndexForStack(ItemStack dankNull, ItemStack filteredStack) {
        InventoryDankNull inv = DankNullUtils.getNewDankNullInventory(dankNull);
        return DankNullUtils.getIndexForStack(inv, filteredStack);
    }

    public static int getIndexForStack(InventoryDankNull inventory, ItemStack filteredStack) {
        block5: {
            block6: {
                if (filteredStack.func_190926_b()) break block5;
                if (!DankNullUtils.isFiltered(inventory, filteredStack)) break block6;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i).func_190926_b() || !ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)inventory.func_70301_a(i), (ItemStack)filteredStack)) continue;
                    return i;
                }
                break block5;
            }
            if (!DankNullUtils.isFilteredOreDict(inventory, filteredStack)) break block5;
            int[] ids = OreDictionary.getOreIDs((ItemStack)filteredStack);
            if (inventory != null && ids.length > 0) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i).func_190926_b() || !DankNullUtils.isItemOreDicted(inventory.func_70301_a(i)) || !DankNullUtils.isItemOreDicted(filteredStack) || !DankNullUtils.getOreDictModeForStack(inventory.getDankNull(), inventory.func_70301_a(i))) continue;
                    int[] ids2 = OreDictionary.getOreIDs((ItemStack)inventory.func_70301_a(i));
                    for (int id : ids) {
                        String name = OreDictionary.getOreName((int)id);
                        for (int id2 : ids2) {
                            if (!name.equals(OreDictionary.getOreName((int)id2))) continue;
                            return i;
                        }
                    }
                }
            }
        }
        return -1;
    }

    public static ItemStack getItemByIndex(InventoryDankNull inventory, int index) {
        if (inventory != null && index >= 0) {
            return inventory.func_70301_a(index);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getStackInDankNullSlot(ItemStack dankNull, int slot) {
        NBTTagList itemList = DankNullUtils.getNBTItemList(dankNull);
        if (!itemList.func_82582_d() && itemList.func_74745_c() > slot) {
            return new ItemStack(itemList.func_150305_b(slot));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getStackInDankNullSlotWithSize(ItemStack dankNull, int slot) {
        NBTTagList itemList = DankNullUtils.getNBTItemList(dankNull);
        if (!itemList.func_82582_d() && itemList.func_74745_c() > slot) {
            NBTTagCompound nbt = itemList.func_150305_b(slot);
            ItemStack ret = new ItemStack(nbt);
            if (NBTUtils.hasInt((NBTTagCompound)nbt, (String)"RealCount")) {
                ret.func_190920_e(NBTUtils.getInt((NBTTagCompound)nbt, (String)"RealCount"));
            }
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public static int getSizeInventory(ItemStack dankNull) {
        return !DankNullUtils.getNBTItemList(dankNull).func_82582_d() ? DankNullUtils.getNBTItemList(dankNull).func_74745_c() : 0;
    }

    public static NBTTagList getNBTItemList(ItemStack dankNull) {
        NBTTagCompound nbt;
        if (dankNull.func_77942_o() && NBTUtils.hasNBTTagList((NBTTagCompound)(nbt = dankNull.func_77978_p()), (String)"danknull-inventory")) {
            return NBTUtils.getNBTTagList((NBTTagCompound)nbt, (String)"danknull-inventory");
        }
        return new NBTTagList();
    }

    public static void decrDankNullStackSize(@Nonnull TileDankNullDock dankDock, @Nonnull ItemStack stack, int amount) {
        if (dankDock == null || dankDock.getDankNull().func_190926_b() || stack.func_190926_b()) {
            return;
        }
        ItemStack dankNull = dankDock.getDankNull();
        if (DankNullUtils.isFiltered(dankNull, stack)) {
            InventoryDankNull tmpInv = DankNullUtils.getNewDankNullInventory(dankNull);
            ItemStack currentStack = DankNullUtils.getFilteredStack(tmpInv, stack);
            currentStack.func_190920_e(currentStack.func_190916_E() - amount);
            if (currentStack.func_190916_E() <= 0) {
                currentStack = ItemStack.field_190927_a;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("DankNullStack", (NBTBase)ItemNBTUtils.getRawStack((ItemStack)tmpInv.getDankNull()));
            dankDock.func_145839_a(nbt);
            dankDock.func_70296_d();
        }
    }

    public static void decrDankNullStackSize(@Nonnull InventoryDankNull inventory, @Nonnull ItemStack stack, int amount) {
        if (inventory == null || stack.func_190926_b()) {
            return;
        }
        if (DankNullUtils.isFiltered(inventory, stack)) {
            ItemStack currentStack = DankNullUtils.getFilteredStack(inventory, stack);
            currentStack.func_190920_e(currentStack.func_190916_E() - amount);
            if (currentStack.func_190916_E() <= 0) {
                currentStack = ItemStack.field_190927_a;
            }
            inventory.func_70296_d();
        }
    }

    public static InventoryDankNull getNewDankNullInventory(PlayerSlot slot, EntityPlayer player) {
        ItemStack stack = slot.getStackInSlot(player);
        if (DankNullUtils.isDankNull(stack)) {
            return new InventoryDankNull(slot, player);
        }
        return null;
    }

    public static InventoryDankNull getNewDankNullInventory(ItemStack stack) {
        return new InventoryDankNull(stack);
    }

    public static ModGlobals.DankNullTier getTier(InventoryDankNull inventory) {
        return DankNullUtils.getTier(inventory.getDankNull());
    }

    public static ModGlobals.DankNullTier getTier(ItemStack dankNull) {
        return DankNullUtils.getMeta(dankNull) == -1 ? ModGlobals.DankNullTier.NONE : ModGlobals.DankNullTier.VALUES[DankNullUtils.getMeta(dankNull)];
    }

    public static int getSlotCount(ItemStack stack) {
        return (DankNullUtils.getMeta(stack) + 1) * 9;
    }

    public static int getSlotCount(InventoryDankNull inventory) {
        return inventory.func_70302_i_();
    }

    public static void setSelectedIndexApplicable(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            int i;
            if (DankNullUtils.getSelectedStackIndex(inventory) >= 0 && !DankNullUtils.getItemByIndex(inventory, DankNullUtils.getSelectedStackIndex(inventory)).func_190926_b()) {
                return;
            }
            boolean indexFound = false;
            for (i = DankNullUtils.getSelectedStackIndex(inventory); i > -1; --i) {
                if (DankNullUtils.getItemByIndex(inventory, i).func_190926_b()) continue;
                indexFound = true;
                DankNullUtils.setSelectedStackIndex(inventory, i);
                return;
            }
            for (i = DankNullUtils.getSlotCount(inventory) - 1; i > -1; --i) {
                if (DankNullUtils.getItemByIndex(inventory, i).func_190926_b()) continue;
                indexFound = true;
                DankNullUtils.setSelectedStackIndex(inventory, i);
                return;
            }
            if (!indexFound) {
                DankNullUtils.setSelectedStackIndex(inventory, -1);
            }
        }
    }

    public static EnumActionResult placeBlock(@Nonnull IBlockState state, World world, BlockPos pos) {
        return world.func_180501_a(pos, state, 2) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public static IRecipe addDankNullUpgradeRecipe(String recipeName, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        IRecipe recipe = (IRecipe)new RecipeDankNullUpgrade((NonNullList<Ingredient>)primer.input).setRegistryName(new ResourceLocation("danknull", recipeName));
        return recipe;
    }

    public static Map<ItemStack, Boolean> getOreDictModes(ItemStack dankNull) {
        HashMap modes = Maps.newHashMap();
        if (!ModConfig.Options.disableOreDictMode.booleanValue() && dankNull.func_77942_o() && dankNull.func_77978_p().func_150297_b("OreDictModes", 9)) {
            NBTTagList extractionList = dankNull.func_77978_p().func_150295_c("OreDictModes", 10);
            for (int i = 0; i < extractionList.func_74745_c(); ++i) {
                NBTTagCompound tempNBT = extractionList.func_150305_b(i);
                modes.put(new ItemStack(tempNBT.func_74775_l("Stack")), tempNBT.func_74767_n("OreDict"));
            }
        }
        return modes;
    }

    public static void setOreDictModes(ItemStack dankNull, Map<ItemStack, Boolean> modes) {
        if (ModConfig.Options.disableOreDictMode.booleanValue() || modes.isEmpty()) {
            return;
        }
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound dankNullNBT = dankNull.func_77978_p();
        NBTTagList oreDictList = new NBTTagList();
        for (ItemStack stack : modes.keySet()) {
            NBTTagCompound tempNBT = new NBTTagCompound();
            if (stack.func_190916_E() != 1) {
                stack.func_190920_e(1);
            }
            tempNBT.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
            tempNBT.func_74757_a("OreDict", modes.get(stack).booleanValue());
            oreDictList.func_74742_a((NBTBase)tempNBT);
        }
        dankNullNBT.func_74782_a("OreDictModes", (NBTBase)oreDictList);
    }

    public static boolean getOreDictModeForStack(ItemStack dankNull, ItemStack stack) {
        Map<ItemStack, Boolean> modes;
        if (!ModConfig.Options.disableOreDictMode.booleanValue() && !(modes = DankNullUtils.getOreDictModes(dankNull)).isEmpty()) {
            for (ItemStack currentStack : modes.keySet()) {
                if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
                return modes.get(currentStack);
            }
        }
        return false;
    }

    public static void setOreDictModeForStack(ItemStack dankNull, ItemStack stack, boolean mode) {
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        boolean alreadyAdded = false;
        ItemStack tempStack = stack.func_77946_l();
        tempStack.func_190920_e(1);
        Map<ItemStack, Boolean> currentModes = DankNullUtils.getOreDictModes(dankNull);
        for (ItemStack currentStack : currentModes.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)tempStack, (ItemStack)currentStack)) continue;
            currentModes.put(currentStack, mode);
            alreadyAdded = true;
        }
        if (!alreadyAdded) {
            currentModes.put(tempStack, mode);
        }
        DankNullUtils.setOreDictModes(dankNull, currentModes);
    }

    public static void cycleOreDictModeForStack(ItemStack dankNull, ItemStack stack) {
        DankNullUtils.setOreDictModeForStack(dankNull, stack, !DankNullUtils.getOreDictModeForStack(dankNull, stack));
    }

    public static Map<ItemStack, ItemExtractionMode> getExtractionModes(ItemStack dankNull) {
        HashMap modes = Maps.newHashMap();
        if (ItemNBTUtils.hasTag((ItemStack)dankNull) && ItemNBTUtils.hasNBTTagList((ItemStack)dankNull, (String)"ExtractionModes")) {
            NBTTagList extractionList = ItemNBTUtils.getNBTTagList((ItemStack)dankNull, (String)"ExtractionModes");
            for (int i = 0; i < extractionList.func_74745_c(); ++i) {
                NBTTagCompound tempNBT = extractionList.func_150305_b(i);
                modes.put(new ItemStack(tempNBT.func_74775_l("Stack")), ItemExtractionMode.values()[tempNBT.func_74762_e("Mode")]);
            }
        }
        return modes;
    }

    public static void setExtractionModes(ItemStack dankNull, Map<ItemStack, ItemExtractionMode> modes) {
        if (modes.isEmpty()) {
            return;
        }
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound dankNullNBT = dankNull.func_77978_p();
        NBTTagList extractionList = new NBTTagList();
        for (ItemStack stack : modes.keySet()) {
            NBTTagCompound tempNBT = new NBTTagCompound();
            if (stack.func_190916_E() != 1) {
                stack.func_190920_e(1);
            }
            tempNBT.func_74782_a("Stack", (NBTBase)ItemNBTUtils.getRawStack((ItemStack)stack));
            tempNBT.func_74768_a("Mode", modes.get(stack).ordinal());
            extractionList.func_74742_a((NBTBase)tempNBT);
        }
        dankNullNBT.func_74782_a("ExtractionModes", (NBTBase)extractionList);
    }

    public static ItemExtractionMode getExtractionModeForStack(ItemStack dankNull, ItemStack stack) {
        Map<ItemStack, ItemExtractionMode> modes = DankNullUtils.getExtractionModes(dankNull);
        if (!modes.isEmpty()) {
            for (ItemStack currentStack : modes.keySet()) {
                if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)stack, (ItemStack)currentStack)) continue;
                return modes.get(currentStack);
            }
        }
        return ItemExtractionMode.KEEP_ALL;
    }

    public static void setExtractionModeForStack(ItemStack dankNull, ItemStack stack, ItemExtractionMode mode) {
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        boolean alreadyAdded = false;
        Map<ItemStack, ItemExtractionMode> currentModes = DankNullUtils.getExtractionModes(dankNull);
        for (ItemStack currentStack : currentModes.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)stack, (ItemStack)currentStack)) continue;
            currentModes.put(currentStack, mode);
            alreadyAdded = true;
        }
        if (!alreadyAdded) {
            currentModes.put(stack, mode);
        }
        DankNullUtils.setExtractionModes(dankNull, currentModes);
    }

    public static void cycleExtractionMode(ItemStack dankNull, ItemStack stack) {
        ItemExtractionMode current = DankNullUtils.getExtractionModeForStack(dankNull, stack);
        if (current.ordinal() >= ItemExtractionMode.values().length - 1) {
            DankNullUtils.setExtractionModeForStack(dankNull, stack, ItemExtractionMode.values()[0]);
        } else {
            DankNullUtils.setExtractionModeForStack(dankNull, stack, ItemExtractionMode.values()[current.ordinal() + 1]);
        }
        if (FMLCommonHandler.instance().getSide().isClient() && DankNullUtils.getExtractionModeForStack(dankNull, stack) == null) {
            ModLogger.warn("no extraction mode found");
            return;
        }
    }

    public static Map<ItemStack, ItemPlacementMode> getPlacementModes(ItemStack dankNull) {
        HashMap modes = Maps.newHashMap();
        if (ItemNBTUtils.hasTag((ItemStack)dankNull) && ItemNBTUtils.hasNBTTagList((ItemStack)dankNull, (String)"PlacementModes")) {
            NBTTagList extractionList = ItemNBTUtils.getNBTTagList((ItemStack)dankNull, (String)"PlacementModes");
            for (int i = 0; i < extractionList.func_74745_c(); ++i) {
                NBTTagCompound tempNBT = extractionList.func_150305_b(i);
                modes.put(new ItemStack(tempNBT.func_74775_l("Stack")), ItemPlacementMode.values()[tempNBT.func_74762_e("Mode")]);
            }
        }
        return modes;
    }

    public static void setPlacementModes(ItemStack dankNull, Map<ItemStack, ItemPlacementMode> modes) {
        if (modes.isEmpty()) {
            return;
        }
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound dankNullNBT = dankNull.func_77978_p();
        NBTTagList extractionList = new NBTTagList();
        for (ItemStack stack : modes.keySet()) {
            NBTTagCompound tempNBT = new NBTTagCompound();
            if (stack.func_190916_E() != 1) {
                stack.func_190920_e(1);
            }
            tempNBT.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
            tempNBT.func_74768_a("Mode", modes.get(stack).ordinal());
            extractionList.func_74742_a((NBTBase)tempNBT);
        }
        dankNullNBT.func_74782_a("PlacementModes", (NBTBase)extractionList);
    }

    public static ItemPlacementMode getPlacementModeForStack(ItemStack dankNull, ItemStack stack) {
        Map<ItemStack, ItemPlacementMode> modes = DankNullUtils.getPlacementModes(dankNull);
        if (!modes.isEmpty()) {
            for (ItemStack currentStack : modes.keySet()) {
                if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)stack, (ItemStack)currentStack)) continue;
                return modes.get(currentStack);
            }
        }
        return ItemPlacementMode.KEEP_1;
    }

    public static void setPlacementModeForStack(ItemStack dankNull, ItemStack stack, ItemPlacementMode mode) {
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        boolean alreadyAdded = false;
        Map<ItemStack, ItemPlacementMode> currentModes = DankNullUtils.getPlacementModes(dankNull);
        for (ItemStack currentStack : currentModes.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)stack, (ItemStack)currentStack)) continue;
            currentModes.put(currentStack, mode);
            alreadyAdded = true;
        }
        if (!alreadyAdded) {
            currentModes.put(stack, mode);
        }
        DankNullUtils.setPlacementModes(dankNull, currentModes);
    }

    public static void cyclePlacementMode(ItemStack dankNull, ItemStack stack) {
        ItemPlacementMode current = DankNullUtils.getPlacementModeForStack(dankNull, stack);
        if (current.ordinal() >= ItemPlacementMode.values().length - 1) {
            DankNullUtils.setPlacementModeForStack(dankNull, stack, ItemPlacementMode.values()[0]);
        } else {
            DankNullUtils.setPlacementModeForStack(dankNull, stack, ItemPlacementMode.values()[current.ordinal() + 1]);
        }
        if (FMLCommonHandler.instance().getSide().isClient() && DankNullUtils.getPlacementModeForStack(dankNull, stack) == null) {
            ModLogger.warn("no extraction mode found");
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(Minecraft mc, ScaledResolution scaledRes) {
        ItemStack selectedStack;
        if (!ModConfig.Options.showHUD || !mc.field_71442_b.func_78755_b() && !mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack currentItem = mc.field_71439_g.field_71071_by.func_70448_g();
        if (currentItem.func_190926_b() || !DankNullUtils.isDankNull(currentItem)) {
            currentItem = mc.field_71439_g.func_184592_cb();
        }
        if (!currentItem.func_190926_b() && DankNullUtils.isDankNull(currentItem) && !(selectedStack = DankNullUtils.getSelectedStack(DankNullUtils.getInventoryFromHeld((EntityPlayer)mc.field_71439_g))).func_190926_b()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("danknull", "textures/gui/danknullscreen0.png"));
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GuiUtils.drawTexturedModalRect((int)(scaledRes.func_78326_a() - 106), (int)(scaledRes.func_78328_b() - 45), (int)0, (int)210, (int)106, (int)45, (float)0.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            mc.field_71466_p.func_175063_a(currentItem.func_82833_r(), (float)(scaledRes.func_78326_a() * 2 - 212 + 55), (float)(scaledRes.func_78328_b() * 2 - 83), DankNullUtils.getTier(currentItem).getHexColor(true));
            String selectedStackName = selectedStack.func_82833_r();
            int itemNameWidth = mc.field_71466_p.func_78256_a(selectedStackName);
            if (itemNameWidth >= 88 && selectedStackName.length() >= 14) {
                selectedStackName = selectedStackName.substring(0, 14).trim() + "...";
            }
            ItemPlacementMode placementMode = DankNullUtils.getPlacementModeForStack(currentItem, selectedStack);
            mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.selected_item.desc") + ": " + selectedStackName, (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 72), 0xFFFFFF);
            mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.count.desc") + ": " + (DankNullUtils.isCreativeDankNull(currentItem) ? "Infinite" : Integer.valueOf(selectedStack.func_190916_E())), (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 61), 0xFFFFFF);
            mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.place.desc") + ": " + placementMode.getTooltip().replace(TextUtils.translate((String)"dn.extract.desc").toLowerCase(Locale.ENGLISH), TextUtils.translate((String)"dn.place.desc").toLowerCase(Locale.ENGLISH)).replace(TextUtils.translate((String)"dn.extract.desc"), TextUtils.translate((String)"dn.place.desc")), (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 50), 0xFFFFFF);
            mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.extract.desc") + ": " + DankNullUtils.getExtractionModeForStack(currentItem, selectedStack).getTooltip(), (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 40), 0xFFFFFF);
            String keyBind = ModKeyBindings.getOpenDankNullKeyBind().getDisplayName();
            mc.field_71466_p.func_175063_a(keyBind.equalsIgnoreCase("none") ? TextUtils.translate((String)"dn.no_open_keybind.desc") : TextUtils.translate((String)"dn.open_with.desc") + " " + keyBind, (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 29), 0xFFFFFF);
            String oreDictMode = TextUtils.translate((String)"dn.ore_dictionary.desc") + ": " + (DankNullUtils.getOreDictModeForStack(currentItem, selectedStack) ? TextUtils.translate((String)"dn.enabled.desc") : TextUtils.translate((String)"dn.disabled.desc"));
            if (!DankNullUtils.isItemOreDicted(selectedStack)) {
                oreDictMode = TextUtils.translate((String)"dn.not_oredicted.desc");
            }
            mc.field_71466_p.func_175063_a(oreDictMode, (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 18), 0xFFFFFF);
            RenderHelper.func_74520_c();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.getRenderItem().func_180450_b(currentItem, scaledRes.func_78326_a() - 106 + 5, scaledRes.func_78328_b() - 20);
            GlStateManager.func_179121_F();
            if (DankNullUtils.isItemOreDicted(selectedStack)) {
                for (int i = 0; i < OreDictionary.getOreIDs((ItemStack)selectedStack).length; ++i) {
                }
            }
        }
    }

    public static void toggleHUD() {
        ModConfig.Options.showHUD = !ModConfig.Options.showHUD;
        ModConfig.CONFIG.save();
    }

    public static boolean isItemOreDicted(ItemStack stack) {
        return OreDictionary.getOreIDs((ItemStack)stack).length > 0;
    }

    public static ItemStack convertToOreDictedStack(ItemStack toBeConverted, ItemStack toConvertTo) {
        if (!DankNullUtils.isItemOreDicted(toBeConverted) || !DankNullUtils.isItemOreDicted(toConvertTo) || ModConfig.Options.disableOreDictMode.booleanValue()) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = toConvertTo.func_77946_l();
        newStack.func_190920_e(toBeConverted.func_190916_E());
        return newStack;
    }

    @SideOnly(value=Side.SERVER)
    public static void sendConfigsToClient(EntityPlayerMP player) {
        WeakHashMapSerializable<String, Object> map = new WeakHashMapSerializable<String, Object>();
        map.put("CreativeBlacklist", ModConfig.Options.creativeBlacklist);
        map.put("CreativeWhitelist", ModConfig.Options.creativeWhitelist);
        map.put("OreDictBlacklist", ModConfig.Options.oreBlacklist);
        map.put("OreDictWhitelist", ModConfig.Options.oreWhitelist);
        map.put("DisableOreDictMode", ModConfig.Options.disableOreDictMode);
        ModNetworking.getInstance().sendTo((IMessage)new PacketConfigSync(map), player);
    }

    public static enum ItemPlacementMode {
        KEEP_ALL(Integer.MAX_VALUE, TextUtils.translate((String)"dn.not_extract.desc")),
        KEEP_1(1, TextUtils.translate((String)"dn.extract_all_but.desc") + " 1"),
        KEEP_16(16, TextUtils.translate((String)"dn.extract_all_but.desc") + " 16"),
        KEEP_64(64, TextUtils.translate((String)"dn.extract_all_but.desc") + " 64"),
        KEEP_NONE(0, TextUtils.translate((String)"dn.extract_all.desc"));

        int number = 0;
        String msg;

        private ItemPlacementMode(int numberToKeep, String message) {
            this.number = numberToKeep;
            this.msg = message;
        }

        public int getNumberToKeep() {
            return this.number;
        }

        public String getMessage() {
            return TextUtils.translate((String)"dn.will.desc") + " " + this.msg + " " + TextUtils.translate((String)"dn.from_slot.desc");
        }

        public String getTooltip() {
            if (this.toString().equals("KEEP_ALL")) {
                return TextUtils.translate((String)"dn.do.desc") + " " + this.msg;
            }
            return this.msg.substring(0, 1).toUpperCase() + this.msg.substring(1);
        }
    }

    public static enum ItemExtractionMode {
        KEEP_ALL(Integer.MAX_VALUE, TextUtils.translate((String)"dn.not_extract.desc")),
        KEEP_1(1, TextUtils.translate((String)"dn.extract_all_but.desc") + " 1"),
        KEEP_16(16, TextUtils.translate((String)"dn.extract_all_but.desc") + " 16"),
        KEEP_64(64, TextUtils.translate((String)"dn.extract_all_but.desc") + " 64"),
        KEEP_NONE(0, TextUtils.translate((String)"dn.extract_all.desc"));

        int number = 0;
        String msg;

        private ItemExtractionMode(int numberToKeep, String message) {
            this.number = numberToKeep;
            this.msg = message;
        }

        public int getNumberToKeep() {
            return this.number;
        }

        public String getMessage() {
            return TextUtils.translate((String)"dn.will.desc") + " " + this.msg + " " + TextUtils.translate((String)"dn.from_slot.desc");
        }

        public String getTooltip() {
            if (this.toString().equals("KEEP_ALL")) {
                return TextUtils.translate((String)"dn.do.desc") + " " + this.msg;
            }
            return this.msg.substring(0, 1).toUpperCase() + this.msg.substring(1);
        }
    }
}

