/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.tileentity.shulker;

import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.common.blocks.shulker.BlockIronShulkerBox;
import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.gui.shulker.ContainerIronShulkerBox;
import cpw.mods.ironchest.common.lib.ICShulkerInventoryHandler;
import cpw.mods.ironchest.common.network.MessageCrystalShulkerSync;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityIronShulkerBox
extends TileEntityLockableLoot
implements ITickable,
ISidedInventory {
    private final int[] SLOTS;
    private NonNullList<ItemStack> items;
    private NonNullList<ItemStack> topStacks;
    private EnumFacing facing;
    private boolean inventoryTouched;
    private int ticksSinceSync;
    private boolean hadStuff;
    private boolean hasBeenCleared;
    private int openCount;
    private AnimationStatus animationStatus;
    private float progress;
    private float progressOld;
    private EnumDyeColor color;
    private boolean destroyedByCreativePlayer;
    private boolean hasBeenUpgraded;
    private IronShulkerBoxType shulkerBoxType;
    private IItemHandler itemHandler;

    public TileEntityIronShulkerBox() {
        this(null);
    }

    public TileEntityIronShulkerBox(@Nullable EnumDyeColor colorIn) {
        this(colorIn, IronShulkerBoxType.IRON);
    }

    public TileEntityIronShulkerBox(@Nullable EnumDyeColor colorIn, IronShulkerBoxType typeIn) {
        this.shulkerBoxType = typeIn;
        this.SLOTS = new int[typeIn.size];
        this.items = NonNullList.func_191197_a((int)typeIn.size, (Object)ItemStack.field_190927_a);
        this.topStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        this.animationStatus = AnimationStatus.CLOSED;
        this.color = colorIn;
        this.facing = EnumFacing.UP;
        this.hasBeenUpgraded = false;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.items = NonNullList.func_191197_a((int)this.getType().size, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < contents.size(); ++i) {
            if (i >= this.items.size()) continue;
            this.func_190576_q().set(i, contents.get(i));
        }
        this.inventoryTouched = true;
    }

    public int func_70302_i_() {
        return this.func_190576_q().size();
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public IronShulkerBoxType getType() {
        IBlockState state;
        IronShulkerBoxType type = IronShulkerBoxType.IRON;
        if (this.func_145830_o() && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof BlockIronShulkerBox) {
            type = (IronShulkerBoxType)((Object)state.func_177229_b(BlockIronShulkerBox.VARIANT_PROP));
        }
        return type;
    }

    public ItemStack func_70301_a(int index) {
        this.func_184281_d(null);
        this.inventoryTouched = true;
        return (ItemStack)this.func_190576_q().get(index);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sortTopStacks();
    }

    protected void sortTopStacks() {
        int i;
        if (!this.getType().isTransparent() || this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        NonNullList tempCopy = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = (ItemStack)this.func_190576_q().get(i);
            if (itemStack.func_190926_b()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.func_185132_d((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.func_190916_E() == tempCopyStack.func_190916_E()) continue block0;
                tempCopyStack.func_190917_f(itemStack.func_190916_E());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.func_77946_l());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i = 0; i < this.getTopItems().size(); ++i) {
                this.getTopItems().set(i, (Object)ItemStack.field_190927_a);
            }
            return;
        }
        this.hadStuff = true;
        Collections.sort(tempCopy, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                if (stack1.func_190926_b()) {
                    return 1;
                }
                if (stack2.func_190926_b()) {
                    return -1;
                }
                return stack2.func_190916_E() - stack1.func_190916_E();
            }
        });
        int p = 0;
        for (ItemStack element : tempCopy) {
            if (element.func_190926_b() || element.func_190916_E() <= 0) continue;
            if (p == this.getTopItems().size()) break;
            this.getTopItems().set(p, (Object)element);
            ++p;
        }
        for (int i2 = p; i2 < this.getTopItems().size(); ++i2) {
            this.getTopItems().set(i2, (Object)ItemStack.field_190927_a);
        }
        this.sendTopStacksPacket();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : this.getType().name();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.loadFromNbt(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(NBTTagCompound compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.items);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
        this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
        this.sortTopStacks();
    }

    public NBTTagCompound saveToNbt(NBTTagCompound compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.items, (boolean)false);
        }
        compound.func_74768_a("ShulkerBoxSize", this.func_70302_i_());
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        if (!compound.func_74764_b("Lock") && this.func_174893_q_()) {
            this.func_174891_i().func_180157_a(compound);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_73660_a() {
        this.updateAnimation();
        if (this.animationStatus == AnimationStatus.OPENING || this.animationStatus == AnimationStatus.CLOSING) {
            this.moveCollidedEntities();
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.ticksSinceSync < 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 3, this.openCount << 3 & 0xF8 | this.facing.ordinal() & 7);
        }
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
        ++this.ticksSinceSync;
    }

    protected void updateAnimation() {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.moveCollidedEntities();
                this.animationStatus = AnimationStatus.OPENED;
                this.progress = 1.0f;
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.getBoundingBox(this.getFacing());
    }

    public AxisAlignedBB getBoundingBox(EnumFacing facing) {
        return Block.field_185505_j.func_72321_a((double)(0.5f * this.getProgress(1.0f) * (float)facing.func_82601_c()), (double)(0.5f * this.getProgress(1.0f) * (float)facing.func_96559_d()), (double)(0.5f * this.getProgress(1.0f) * (float)facing.func_82599_e()));
    }

    private AxisAlignedBB getTopBoundingBox(EnumFacing facing) {
        EnumFacing enumfacing = facing.func_176734_d();
        return this.getBoundingBox(facing).func_191195_a((double)enumfacing.func_82601_c(), (double)enumfacing.func_96559_d(), (double)enumfacing.func_82599_e());
    }

    private void moveCollidedEntities() {
        EnumFacing enumfacing;
        AxisAlignedBB axisalignedbb;
        List list;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (iblockstate.func_177230_c() instanceof BlockIronShulkerBox && !(list = this.field_145850_b.func_72839_b((Entity)null, axisalignedbb = this.getTopBoundingBox(enumfacing = this.getFacing()).func_186670_a(this.field_174879_c))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.func_184192_z() == EnumPushReaction.IGNORE) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
                switch (enumfacing.func_176740_k()) {
                    case X: {
                        d0 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72336_d - axisalignedbb1.field_72340_a : axisalignedbb1.field_72336_d - axisalignedbb.field_72340_a;
                        d0 += 0.01;
                        break;
                    }
                    case Y: {
                        d1 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72337_e - axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e - axisalignedbb.field_72338_b;
                        d1 += 0.01;
                        break;
                    }
                    case Z: {
                        d2 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72334_f - axisalignedbb1.field_72339_c : axisalignedbb1.field_72334_f - axisalignedbb.field_72339_c;
                        d2 += 0.01;
                    }
                }
                entity.func_70091_d(MoverType.SHULKER_BOX, d0 * (double)enumfacing.func_82601_c(), d1 * (double)enumfacing.func_96559_d(), d2 * (double)enumfacing.func_82599_e());
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            if (type == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
            }
            if (type == 1) {
                this.animationStatus = AnimationStatus.OPENING;
            }
            return true;
        }
        if (id == 2) {
            this.facing = EnumFacing.field_82609_l[type];
            return true;
        }
        if (id == 3) {
            this.facing = EnumFacing.field_82609_l[type & 7];
            this.openCount = (type & 0xF8) >> 3;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.openCount);
            if (this.openCount == 1) {
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 0) {
            NBTTagCompound compound = pkt.func_148857_g();
            this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
        }
    }

    public NonNullList<ItemStack> buildItemStackDataList() {
        if (this.getType().isTransparent()) {
            NonNullList sortList = NonNullList.func_191197_a((int)this.getTopItems().size(), (Object)ItemStack.field_190927_a);
            int pos = 0;
            for (ItemStack is : this.topStacks) {
                if (!is.func_190926_b()) {
                    sortList.set(pos, (Object)is);
                } else {
                    sortList.set(pos, (Object)ItemStack.field_190927_a);
                }
                ++pos;
            }
            return sortList;
        }
        return NonNullList.func_191197_a((int)this.getTopItems().size(), (Object)ItemStack.field_190927_a);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerIronShulkerBox((IInventory)playerInventory, (IInventory)this, this.shulkerBoxType, this.shulkerBoxType.xSize, this.shulkerBoxType.ySize);
    }

    public String func_174875_k() {
        return "IronChest:" + this.getType().name() + "_shulker_box";
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.items, (boolean)false);
        }
        compound.func_74768_a("ShulkerBoxSize", this.func_70302_i_());
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        if (!compound.func_74764_b("Lock") && this.func_174893_q_()) {
            this.func_174891_i().func_180157_a(compound);
        }
        return compound;
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    public NonNullList<ItemStack> getTopItems() {
        return this.topStacks;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return !(Block.func_149634_a((Item)itemStackIn.func_77973_b()) instanceof BlockIronShulkerBox) && !(Block.func_149634_a((Item)itemStackIn.func_77973_b()) instanceof BlockShulkerBox);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public void func_174888_l() {
        this.hasBeenCleared = true;
        super.func_174888_l();
    }

    public boolean isCleared() {
        return this.hasBeenCleared;
    }

    public void setHasBeenUpgraded() {
        this.hasBeenUpgraded = true;
    }

    public boolean beenUpgraded() {
        return this.hasBeenUpgraded;
    }

    public float getProgress(float partialTicks) {
        return this.progressOld + (this.progress - this.progressOld) * partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        if (this.color == null) {
            this.color = BlockIronShulkerBox.getColorFromBlock(this.func_145838_q());
        }
        return this.color;
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public void setDestroyedByCreativePlayer(boolean destoryedByCreativeUser) {
        this.destroyedByCreativePlayer = destoryedByCreativeUser;
    }

    public boolean shouldDropInBreakBlock() {
        return this.isDestroyedByCreativePlayer() && (!this.func_191420_l() || this.func_145818_k_() || this.field_184284_m != null);
    }

    public ItemStack getDrop(IBlockState state, boolean inBreakBlock) {
        BlockIronShulkerBox block = (BlockIronShulkerBox)state.func_177230_c();
        if (!(this.isCleared() || inBreakBlock && !this.shouldDropInBreakBlock() || this.beenUpgraded())) {
            ItemStack itemstack = new ItemStack(Item.func_150898_a((Block)block), 1, ((IronShulkerBoxType)((Object)state.func_177229_b(BlockIronShulkerBox.VARIANT_PROP))).ordinal());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.func_74782_a("BlockEntityTag", (NBTBase)this.saveToNbt(nbttagcompound1));
            itemstack.func_77982_d(nbttagcompound);
            if (this.func_145818_k_()) {
                itemstack.func_151001_c(this.func_70005_c_());
                this.func_190575_a("");
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected void sendTopStacksPacket() {
        NonNullList<ItemStack> stacks = this.buildItemStackDataList();
        IronChest.packetHandler.sendToAllAround((IMessage)new MessageCrystalShulkerSync(this, stacks), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
    }

    public void receiveMessageFromServer(NonNullList<ItemStack> topStacks) {
        this.topStacks = topStacks;
    }

    public static void registerFixesShulkerBox(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityIronShulkerBox.class, new String[]{"Items"}));
    }

    protected IItemHandler createUnSidedHandler() {
        return new ICShulkerInventoryHandler(this);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

