/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.village.buildingmanagers;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import org.millenaire.common.block.MillBlocks;
import org.millenaire.common.config.MillConfigValues;
import org.millenaire.common.culture.VillagerType;
import org.millenaire.common.entity.MillVillager;
import org.millenaire.common.entity.TileEntityPanel;
import org.millenaire.common.item.InvItem;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.utilities.MillCommonUtilities;
import org.millenaire.common.utilities.MillLog;
import org.millenaire.common.utilities.Point;
import org.millenaire.common.utilities.WorldUtilities;
import org.millenaire.common.village.Building;
import org.millenaire.common.village.VillagerRecord;

public class VisitorManager {
    private final Building building;
    private boolean nightActionPerformed = false;

    public VisitorManager(Building building) {
        this.building = building;
    }

    public void update(boolean forceAttempt) throws MillLog.MillenaireException {
        if (this.building.isMarket) {
            this.updateMarket(forceAttempt);
        } else {
            this.updateVisitors(forceAttempt);
        }
    }

    private void updateMarket(boolean forceAttempt) throws MillLog.MillenaireException {
        if (this.building.world.func_72935_r() && !forceAttempt) {
            this.nightActionPerformed = false;
        } else if (!this.nightActionPerformed || forceAttempt) {
            int maxMerchants = this.building.getResManager().stalls.size();
            if (this.building.getAllVillagerRecords().size() < maxMerchants) {
                if (MillConfigValues.LogMerchant >= 1) {
                    MillLog.major(this, "Attempting to create a foreign merchant.");
                }
                ArrayList<VillagerType> merchantTypesOtherVillages = new ArrayList<VillagerType>();
                for (Point p : this.building.getTownHall().getRelations().keySet()) {
                    Building distantVillage;
                    if (this.building.getTownHall().getRelations().get(p) <= 70 || (distantVillage = this.building.mw.getBuilding(p)) == null || distantVillage.culture == this.building.getTownHall().culture || distantVillage.getBuildingsWithTag("market").size() <= 0) continue;
                    merchantTypesOtherVillages.add(distantVillage.culture.getRandomForeignMerchant());
                }
                int foreignChance = Math.min(1 + merchantTypesOtherVillages.size(), 5);
                VillagerType type = merchantTypesOtherVillages.size() > 0 && MillCommonUtilities.randomInt(11) < foreignChance ? (merchantTypesOtherVillages.size() == 0 ? this.building.culture.getRandomForeignMerchant() : (VillagerType)merchantTypesOtherVillages.get(MillCommonUtilities.randomInt(merchantTypesOtherVillages.size()))) : this.building.culture.getRandomForeignMerchant();
                VillagerRecord merchantRecord = VillagerRecord.createVillagerRecord(type.culture, type.key, this.building.mw, this.building.getPos(), this.building.getTownHall().getPos(), null, null, -1L, false);
                MillVillager merchant = MillVillager.createVillager(merchantRecord, this.building.world, this.building.getResManager().getSleepingPos(), false);
                this.building.world.func_72838_d((Entity)merchant);
                for (InvItem iv : merchant.vtype.foreignMerchantStock.keySet()) {
                    this.building.storeGoods(iv.getItem(), iv.meta, (int)merchant.vtype.foreignMerchantStock.get(iv));
                }
                if (MillConfigValues.LogMerchant >= 1) {
                    MillLog.major(this, "Created foreign merchant: " + merchantRecord);
                }
            }
            this.nightActionPerformed = true;
        }
    }

    public void updateSigns() {
        EntityPlayer player = this.building.world.func_184137_a((double)this.building.getPos().getiX(), (double)this.building.getPos().getiY(), (double)this.building.getPos().getiZ(), 20.0, false);
        if (player == null) {
            return;
        }
        if (this.building.getResManager().signs.size() == 0 || this.building.getResManager().signs.get(0) == null) {
            return;
        }
        for (int i = 0; i < this.building.getResManager().signs.size(); ++i) {
            EnumFacing facing;
            Point p = this.building.getResManager().signs.get(i);
            if (p == null || WorldUtilities.getBlock(this.building.world, p) == MillBlocks.PANEL || (facing = WorldUtilities.guessPanelFacing(this.building.world, p)) == null) continue;
            WorldUtilities.setBlockstate(this.building.world, p, MillBlocks.PANEL.func_176223_P().func_177226_a((IProperty)BlockWallSign.field_176412_a, (Comparable)facing), true, false);
        }
        TileEntityPanel sign = this.building.getResManager().signs.get(0).getPanel(this.building.world);
        if (sign != null) {
            String[][] lines;
            if (this.building.isMarket) {
                lines = new String[][]{{this.building.getNativeBuildingName()}, {""}, {"ui.merchants"}, {"" + this.building.getAllVillagerRecords().size()}};
                ServerSender.updatePanel(this.building.mw, this.building.getResManager().signs.get(0), lines, 12, this.building.getPos(), 0L);
            } else {
                lines = new String[][]{{this.building.getNativeBuildingName()}, {""}, {"ui.visitors"}, {"" + this.building.getAllVillagerRecords().size()}};
                ServerSender.updatePanel(this.building.mw, this.building.getResManager().signs.get(0), lines, 14, this.building.getPos(), 0L);
            }
        }
    }

    private void updateVisitors(boolean forceAttempt) throws MillLog.MillenaireException {
        if (this.building.world.func_72935_r() && !forceAttempt) {
            this.nightActionPerformed = false;
        } else if (!this.nightActionPerformed || forceAttempt) {
            HashMap<String, Integer> targetCount = new HashMap<String, Integer>();
            for (String visitorType : this.building.location.visitors) {
                if (targetCount.containsKey(visitorType)) {
                    targetCount.put(visitorType, (Integer)targetCount.get(visitorType) + 1);
                    continue;
                }
                targetCount.put(visitorType, 1);
            }
            for (String visitorType : targetCount.keySet()) {
                int currentCount = 0;
                for (VillagerRecord vr : this.building.getAllVillagerRecords()) {
                    if (!vr.type.equals(visitorType)) continue;
                    ++currentCount;
                }
                VillagerType type = this.building.culture.getVillagerType(visitorType);
                for (int i = currentCount; i < (Integer)targetCount.get(visitorType); ++i) {
                    if (!MillCommonUtilities.chanceOn(2)) continue;
                    VillagerRecord visitorRecord = VillagerRecord.createVillagerRecord(type.culture, type.key, this.building.mw, this.building.getPos(), this.building.getTownHall().getPos(), null, null, -1L, false);
                    MillVillager visitor = MillVillager.createVillager(visitorRecord, this.building.world, this.building.getResManager().getSleepingPos(), false);
                    this.building.world.func_72838_d((Entity)visitor);
                    if (MillConfigValues.LogMerchant < 1) continue;
                    MillLog.major(this, "Created visitor: " + visitorRecord);
                }
            }
            this.nightActionPerformed = true;
        }
    }
}

