/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import pcl.opensecurity.common.interfaces.IOwner;
import pcl.opensecurity.common.tileentity.TileEntityOSSound;
import pcl.opensecurity.common.tileentity.logic.EnergyTurret;
import pcl.opensecurity.util.ItemUtils;

public class TileEntityEnergyTurret
extends TileEntityOSSound
implements IOwner {
    private UUID owner;
    private EnergyTurret energyTurret = new EnergyTurret(this);

    public TileEntityEnergyTurret() {
        super("os_energyturret");
        this.setSound("turretMove");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    public void onLoad() {
        this.energyTurret.onLoad();
    }

    @Override
    public void func_73660_a() {
        this.energyTurret.update();
        super.func_73660_a();
    }

    public boolean consumeEnergy(double amount) {
        return this.func_145831_w().field_72995_K || this.node != null && this.node.tryChangeBuffer(-amount);
    }

    public EnergyTurret getEnergyTurret() {
        return this.energyTurret;
    }

    @Callback(doc="function():number -- Current real yaw", direct=true)
    public Object[] getYaw(Context context, Arguments args) {
        return new Object[]{Float.valueOf(this.energyTurret.yaw())};
    }

    @Callback(doc="function():number -- Current real pitch", direct=true)
    public Object[] getPitch(Context context, Arguments args) {
        return new Object[]{Float.valueOf(this.energyTurret.pitch())};
    }

    @Callback(doc="function():boolean -- Returns whether the gun has reached the set position", direct=true)
    public Object[] isOnTarget(Context context, Arguments args) {
        return this.energyTurret.isOnTarget();
    }

    @Callback(doc="function():boolean -- Returns whether the gun is ready to fire again (cooled down and armed)", direct=true)
    public Object[] isReady(Context context, Arguments args) {
        return new Object[]{this.energyTurret.isReady()};
    }

    @Callback(doc="function():boolean -- Returns whether the gun is powered", direct=true)
    public Object[] isPowered(Context context, Arguments args) {
        return new Object[]{this.energyTurret.isPowered()};
    }

    @Callback(doc="function(length:boolean):number -- Extends gun shaft (0-2)")
    public Object[] extendShaft(Context context, Arguments args) {
        float setTo = this.energyTurret.setShaft((float)args.checkDouble(0));
        return new Object[]{Float.valueOf(setTo)};
    }

    @Callback(doc="function():boolean -- Get gun shaft extension", direct=true)
    public Object[] getShaftLength(Context context, Arguments args) {
        return new Object[]{Float.valueOf(this.energyTurret.getShaftLength())};
    }

    @Callback(doc="function(yaw:number, pitch:number) -- Changes the gun's setpoint (Yaw ranges (0.0..360) Pitch ranges (-45..90))")
    public Object[] moveTo(Context context, Arguments args) {
        if (!this.energyTurret.isPowered()) {
            return new Object[]{false, "powered off"};
        }
        this.energyTurret.setYawPitch((float)args.checkDouble(0), (float)args.checkDouble(1));
        return new Object[]{true};
    }

    @Callback(doc="function(yaw:number, pitch:number) -- Changes the gun's setpoint (Yaw ranges (0.0..360) Pitch ranges (-45..90))")
    public Object[] moveBy(Context context, Arguments args) {
        if (!this.energyTurret.isPowered()) {
            return new Object[]{false, "powered off"};
        }
        float yaw = (float)args.checkDouble(0) + this.energyTurret.yaw();
        float pitch = (float)args.checkDouble(1) + this.energyTurret.pitch();
        this.energyTurret.setYawPitch(yaw, pitch);
        return new Object[]{true};
    }

    @Callback(doc="function(yaw:number, pitch:number) -- Changes the gun's setpoint in radians")
    public Object[] moveToRadians(Context context, Arguments args) {
        if (!this.energyTurret.isPowered()) {
            return new Object[]{false, "powered off"};
        }
        double rad = args.checkDouble(0);
        double deg = rad * 180.0 / Math.PI;
        double rad2 = args.checkDouble(1);
        double deg2 = rad2 * 180.0 / Math.PI;
        this.energyTurret.setYawPitch((float)deg, (float)deg2);
        return new Object[]{true};
    }

    @Callback
    public Object[] setArmed(Context context, Arguments args) {
        this.energyTurret.setArmed(args.checkBoolean(0));
        return new Object[]{true};
    }

    @Callback
    public Object[] powerOn(Context context, Arguments args) {
        this.energyTurret.setPowered(true);
        return new Object[]{true};
    }

    @Callback
    public Object[] powerOff(Context context, Arguments args) {
        this.energyTurret.setPowered(false);
        return new Object[]{true};
    }

    @Callback(doc="function():table -- Fires the gun.  More damage means longer cooldown and more energy draw. Returns true for success and throws error with a message for failure")
    public Object[] fire(Context context, Arguments args) {
        return this.energyTurret.fire();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.energyTurret.getInventory();
        }
        return (T)super.getCapability(capability, facing);
    }

    public void remove() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        for (int slot = 0; slot < this.energyTurret.getInventory().getSlots(); ++slot) {
            ItemUtils.dropItem(this.energyTurret.getInventory().getStackInSlot(slot), this.func_145831_w(), this.func_174877_v(), false, 10);
        }
    }

    @Override
    public void setOwner(UUID newOwner) {
        this.owner = newOwner;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energyTurret.readFromNBT(tag.func_74775_l("energyTurret"));
        if (tag.func_186855_b("owner")) {
            this.owner = tag.func_186857_a("owner");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("energyTurret", (NBTBase)this.energyTurret.writeToNBT(new NBTTagCompound()));
        if (this.owner != null) {
            tag.func_186854_a("owner", this.owner);
        }
        return super.func_189515_b(tag);
    }

    public void markDirtyClient() {
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_189517_E_();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

