/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.util;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemResourceLocation
extends ResourceLocation {
    private final int metadata;

    protected ItemResourceLocation(int unused, String domain, String path, int metadata) {
        super(0, new String[]{domain, path});
        this.metadata = metadata;
    }

    public ItemResourceLocation(String domain, String path, int metadata) {
        this(0, domain, path, metadata);
    }

    public ItemResourceLocation(ResourceLocation location, int metadata) {
        this(0, location.func_110624_b(), location.func_110623_a(), metadata);
    }

    public ItemResourceLocation(String combined) {
        super(0, ItemResourceLocation.extractPathParts(combined));
        this.metadata = ItemResourceLocation.extractMetadata(combined);
    }

    public int getMetadata() {
        return this.metadata;
    }

    @Nonnull
    public ItemStack getItemStack() {
        Block block;
        Item item = Item.func_111206_d((String)super.toString());
        if (item == null && (block = Block.func_149684_b((String)super.toString())) != null) {
            item = Item.func_150898_a((Block)block);
        }
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, 1, this.metadata);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ItemResourceLocation && super.equals(object)) {
            return this.metadata == ((ItemResourceLocation)((Object)object)).metadata;
        }
        return false;
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.metadata;
    }

    public String toString() {
        return super.toString() + ':' + this.metadata;
    }

    private static String[] extractPathParts(String combined) {
        String[] parts = combined.split(":");
        switch (parts.length) {
            case 1: {
                return new String[]{null, parts[0]};
            }
            case 2: {
                return parts;
            }
        }
        String[] arr2 = new String[2];
        System.arraycopy(parts, 0, arr2, 0, 2);
        return arr2;
    }

    private static int extractMetadata(String combined) {
        String[] parts = combined.split(":");
        if (parts.length < 3) {
            return Short.MAX_VALUE;
        }
        try {
            return Integer.parseInt(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            return Short.MAX_VALUE;
        }
    }
}

