# Widget Modifiers

## methods
```lua
widget.addColor(Double: red, Double:green, Double:blue, Double:alpha):Integer:index

widget.addColor(1, 0, 0, 0.5)
-- adds red color with 50% opacity
```
### addRotation
```lua
widget.addRotation(Double:degree, Double:x, Double:y, Double:z):Integer:index

widget.addRotation(90, 0, 1, 0)
-- rotates the widget by 90° on the Y-Axis
```
### addScale
```lua
widget.addScale(Double:scaleX, Double:scaleY, Double:scaleZ):Integer:index

widget.addScale(2, 2, 2)
-- scales widget by factor 2 on all axis
```
### addTranslation
```lua
widget.addTranslation(Double:x, Double:y, Double:z):Integer:index

widget.addTranslation(0, 1, 0)
-- moves widget on y axis by 1
```
### addAutoTranslation
```lua
widget.addAutoTranslation(Double:percentX, Double:percentY):Integer:index
-- allows alignment for overlay widgets in percent

widget.addAutoTranslation(50, 50)
-- moves widget to the center of the screen
```
### updateModifier
version 2.1+
```lua
widget.modifiers()[index].set(1, 0, 0)
-- updates the values of a modifier, r/g/b for color or x/y/z for translate/scale modifiers

widget.modifiers()[index].set(10, 0, 0, 1)
-- updates the values of a modifier, r/g/b/a for color or deg/x/y/z for rotate modifier
```

```lua
widget.modifiers()[index].get()
-- returns the current values of a modifier
```

```lua
widget.modifiers()[index].type()
-- returns the type of a modifier
```

```lua
-- create a cube
widget = require("component").glasses.addCube3D()
-- add black color to the cube
myColorModifier = widget.addColor(0, 0, 0, 0)
-- set the color modifier from before to green
widget.modifiers()[myColorModifier].set(0, 1, 0)
os.sleep(5)
-- set the color modifier from before to red
widget.modifiers()[myColorModifier].set(1, 0, 0)
```


version 2.0+ (old syntax is still supported by new versions)
```lua
widget.updateModifier(index, 0, 1, 0)
-- updates red/green/blue or x/y/z

widget.updateModifier(index, 1, 0, 1, 0)
-- updates red/green/blue/alpha or deg/x/y/z
```
```lua
-- create a cube
widget = require("component").glasses.addCube3D()
-- add black color to the cube
myColorModifier = widget.addColor(0, 0, 0, 0)
-- set the color modifier from before to green
widget.updateModifier(myColorModifier, 0, 1, 0)
os.sleep(5)
-- set the color modifier from before to red
widget.updateModifier(myColorModifier, 1, 0, 0)
```

# Animation
Widgets can be animated by binding an easing function to a modifier. So you can animate color / scale changes, movement and rotation with a simple syntax

### setEasing
```lua
widget.setEasing(Integer:modifierIndex, String:easingFunction, String:easingType, Double:duration, String:variableName, Double:minValue, Double:maxValue, String:mode)
```
```lua
rotModifier = widget.addRotation(0, 0, 1, 0)
widget.setEasing(rotModifier, "LINEAR", "IN", 3000, "deg", 0, 360, "repeat")
-- rotate widget around the y-axis, one rotation takes 3seconds
```

### removeEasing
```lua
widget.removeEasing(Integer:modifierIndex, String:variableName)
-- removes easing from a modifier
```
```lua
widget.removeEasing(4, "x")
-- removes easing from list "x" of modifier 4
```
## easing function names [previews](http://easings.net/)
* `BACK`, `BOUNCE`, `CIRC`, `CUBIC`, `ELASTIC`, `EXPO`, `LINEAR`, `QUAD`, `QUART`, `QUINT`, `SINE`
## easing types
* `IN`, `OUT`, `INOUT`
## loop/repeat modes
* `DEFAULT` only run once 
* `LOOP` loop/playback the easing back and forth
* `REPEAT` repeat the easing
