/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage.network;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ControllerSearch {
    private final Queue<BlockPos> searchQueue = new LinkedList<BlockPos>();
    private final Set<BlockPos> searchDiscovered = new HashSet<BlockPos>();
    private final int range;

    public ControllerSearch(int range) {
        this.range = range;
    }

    public BlockPos search(TileEntity tile) {
        BlockPos root = tile.func_174877_v();
        this.searchQueue.clear();
        this.searchQueue.add(root);
        this.searchDiscovered.clear();
        this.searchDiscovered.add(root);
        World world = tile.func_145831_w();
        while (!this.searchQueue.isEmpty()) {
            BlockPos[] neighbors;
            Block block;
            BlockPos coord = this.searchQueue.remove();
            int depth = this.maxAxisDistance(coord, root);
            if (depth > this.range || !((block = world.func_180495_p(coord).func_177230_c()) instanceof INetworked)) continue;
            if (block instanceof BlockController) {
                return coord;
            }
            for (BlockPos n : neighbors = new BlockPos[]{coord.func_177976_e(), coord.func_177974_f(), coord.func_177968_d(), coord.func_177978_c(), coord.func_177984_a(), coord.func_177977_b()}) {
                if (this.searchDiscovered.contains(n)) continue;
                this.searchQueue.add(n);
                this.searchDiscovered.add(n);
            }
        }
        return null;
    }

    private int maxAxisDistance(BlockPos coord1, BlockPos coord2) {
        return Math.max(Math.max(Math.abs(coord1.func_177958_n() - coord2.func_177958_n()), Math.abs(coord1.func_177956_o() - coord2.func_177956_o())), Math.abs(coord1.func_177952_p() - coord2.func_177952_p()));
    }
}

