/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.common.lib.SoundsTC;
import thaumicperiphery.items.ItemAttributeBauble;

public class ItemPauldronRepulsion
extends ItemAttributeBauble {
    public static final String TAG_COOLDOWN = "cooldown";
    protected static final UUID ARMOR_MODIFIER = UUID.fromString("371929FC-4CBC-11E8-842F-0ED5F89F718B");
    protected static final UUID TOUGHNESS_MODIFIER = UUID.fromString("22E6BD72-4CBD-11E8-842F-0ED5F89F718B");

    public ItemPauldronRepulsion() {
        super("pauldron_repulsion");
        this.attributeMap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIER, "pauldron armor", 2.0, 0));
        this.attributeMap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(TOUGHNESS_MODIFIER, "pauldron armor toughness", 1.0, 0));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        int cooldown = this.getCooldown(stack);
        if (cooldown > 0) {
            this.setCooldown(stack, cooldown - 1);
        }
    }

    protected int getCooldown(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b(TAG_COOLDOWN, 3)) {
            return tag.func_74762_e(TAG_COOLDOWN);
        }
        return 0;
    }

    protected void setCooldown(ItemStack stack, int cooldown) {
        NBTTagCompound tag;
        if (cooldown < 0) {
            cooldown = 0;
        }
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (cooldown <= 0) {
            tag.func_82580_o(TAG_COOLDOWN);
            if (tag.func_82582_d()) {
                tag = null;
            }
        } else {
            tag.func_74768_a(TAG_COOLDOWN, cooldown);
        }
        stack.func_77982_d(tag);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @SubscribeEvent
    public void onPlayerDamaged(LivingDamageEvent event) {
        EntityPlayer player;
        ItemStack body;
        EntityLivingBase entity = event.getEntityLiving();
        Entity source = event.getSource().func_76364_f();
        if (source != null && source instanceof EntityLivingBase && entity instanceof EntityPlayer && !(body = BaublesApi.getBaublesHandler((EntityPlayer)(player = (EntityPlayer)entity)).getStackInSlot(5)).func_190926_b() && body.func_77973_b() == this && this.getCooldown(body) <= 0) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundsTC.poof, SoundCategory.PLAYERS, 1.0f, 1.0f + (float)player.func_130014_f_().field_73012_v.nextGaussian() * 0.05f);
                List entities = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b(4.5, 2.0, 4.5));
                for (Entity e : entities) {
                    if (!(e instanceof EntityLivingBase)) continue;
                    EntityLivingBase mob = (EntityLivingBase)e;
                    mob.func_70653_a((Entity)player, 2.0f, player.field_70165_t - mob.field_70165_t, player.field_70161_v - mob.field_70161_v);
                }
            }
            this.setCooldown(body, 50);
        }
    }
}

