/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.blocks;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.openprinter.OpenPrinter;
import pcl.openprinter.tileentity.PrinterTE;
import pcl.openprinter.util.AABBHelper;

public class BlockPrinter
extends BlockContainer {
    private static final AxisAlignedBB emptyBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.6);
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockPrinter() {
        super(Material.field_151573_f);
        this.func_149647_a(OpenPrinter.CreativeTab);
        this.func_149663_c("printer");
        this.func_149711_c(0.5f);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        PrinterTE tileEntity = (PrinterTE)world.func_175625_s(pos);
        tileEntity.removed();
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)OpenPrinter.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return Minecraft.func_71410_x().field_71439_g.func_70093_af() ? super.func_180640_a(state, worldIn, pos) : emptyBB;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        return AABBHelper.rotateHorizontal(boundingBox, facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        int facingbits = facing.func_176736_b();
        return facingbits;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)PROPERTYFACING, (Comparable)placer.func_174811_aO());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new PrinterTE();
    }
}

