/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import se.rupy.http.Event;
import se.rupy.http.Failure;
import se.rupy.http.Reply;
import se.rupy.http.Session;

public abstract class Output
extends OutputStream
implements Event.Block {
    public static final String EOL = "\r\n";
    private static final byte[] server = "Server: Rupy/0.4.3\r\n".getBytes();
    private static final byte[] close = "Connection: Close\r\n".getBytes();
    private static final byte[] alive = "Connection: Keep-Alive\r\n".getBytes();
    private static final byte[] chunked = "Transfer-Encoding: Chunked\r\n".getBytes();
    private byte[] one = new byte[1];
    protected int length;
    protected int size;
    protected Reply reply;
    protected boolean init;
    protected boolean push;
    protected boolean fixed;
    protected boolean done;

    Output(Reply reply) throws IOException {
        this.reply = reply;
        this.size = reply.event().daemon().size;
    }

    public boolean complete() {
        return !this.push && this.done;
    }

    protected int length() {
        return this.length;
    }

    protected boolean push() {
        return this.push;
    }

    public void println(Object o) throws IOException {
        this.write((o.toString() + EOL).getBytes("UTF-8"));
    }

    public void println(long l) throws IOException {
        this.write((String.valueOf(l) + EOL).getBytes("UTF-8"));
    }

    public void println(boolean b) throws IOException {
        this.write((String.valueOf(b) + EOL).getBytes("UTF-8"));
    }

    public void print(Object o) throws IOException {
        this.write(o.toString().getBytes("UTF-8"));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l).getBytes("UTF-8"));
    }

    public void print(boolean b) throws IOException {
        this.write(String.valueOf(b).getBytes("UTF-8"));
    }

    protected void init(long length) throws IOException {
        if (this.init) {
            this.reply.event().log("already inited", Event.DEBUG);
            return;
        }
        this.reply.event().log("init " + this.reply.event().query().version() + " " + length, Event.DEBUG);
        this.done = false;
        this.reply.event().interest(Event.WRITE);
        this.init = true;
        if (length > 0L) {
            this.fixed = true;
            this.headers(length);
        } else if (this.zero()) {
            this.headers(0L);
        } else {
            this.headers(-1L);
        }
    }

    protected void end() throws IOException {
        if (this.reply.event().daemon().debug) {
            this.reply.event().log("end", Event.DEBUG);
        }
        this.done = true;
        this.flush();
        if (this.reply.event().daemon().verbose && this.length > 0) {
            this.reply.event().log("reply " + this.length, Event.VERBOSE);
        }
        this.reply.event().interest(Event.READ);
        this.fixed = false;
        this.init = false;
        this.length = 0;
    }

    protected void headers(long length) throws IOException {
        if (this.reply.event().daemon().verbose) {
            this.reply.event().log("code " + this.reply.code(), Event.VERBOSE);
        }
        this.wrote((this.reply.event().query().version() + " " + this.reply.code() + EOL).getBytes());
        this.wrote(("Date: " + this.reply.event().worker().date().format(new Date()) + EOL).getBytes());
        this.wrote(server);
        if (!this.zero()) {
            this.wrote(("Content-Type: " + this.reply.type() + EOL).getBytes());
        }
        if (length > -1L) {
            this.wrote(("Content-Length: " + length + EOL).getBytes());
        } else {
            this.wrote(chunked);
        }
        if (this.reply.modified() > 0L) {
            this.wrote(("Last-Modified: " + this.reply.event().worker().date().format(new Date(this.reply.modified())) + EOL).getBytes());
        }
        if (this.fixed && this.reply.event().daemon().properties.getProperty("live") != null) {
            this.wrote("Cache-Control: no-cache\r\n".getBytes());
            this.wrote(("Expires: " + this.reply.event().worker().date().format(new Date(System.currentTimeMillis() + 31536000000L)) + EOL).getBytes());
        }
        if (this.reply.event().session() != null && !this.reply.event().session().set()) {
            Session session = this.reply.event().session();
            String cookie = "Set-Cookie: key=" + session.key() + ";" + (session.expires() > 0L ? " expires=" + this.reply.event().worker().date().format(new Date(session.expires())) + ";" : "") + (session.domain() != null ? " domain=" + session.domain() + ";" : "") + " path=/;";
            this.wrote((cookie + EOL).getBytes());
            this.reply.event().session().set(true);
            if (this.reply.event().daemon().verbose) {
                this.reply.event().log("cookie " + cookie, Event.VERBOSE);
            }
        }
        if (this.reply.event().close()) {
            this.wrote(close);
        } else {
            this.wrote(alive);
        }
        HashMap headers = this.reply.headers();
        if (headers != null) {
            for (String name : headers.keySet()) {
                String value = (String)this.reply.headers().get(name);
                this.wrote((name + ": " + value + EOL).getBytes());
            }
        }
        this.wrote(EOL.getBytes());
    }

    protected void wrote(int b) throws IOException {
        this.one[0] = (byte)b;
        this.wrote(this.one);
    }

    protected void wrote(byte[] b) throws IOException {
        this.wrote(b, 0, b.length);
    }

    protected void wrote(byte[] b, int off, int len) throws IOException {
        try {
            ByteBuffer out = this.reply.event().worker().out();
            int remaining = out.remaining();
            while (len > remaining) {
                out.put(b, off, remaining);
                this.internal(false);
                off += remaining;
                len -= remaining;
                remaining = out.remaining();
            }
            if (len > 0) {
                out.put(b, off, len);
            }
        }
        catch (Failure.Close c) {
            throw c;
        }
        catch (IOException e) {
            Failure.chain(e);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected void internal(boolean debug) throws Exception {
        ByteBuffer out = this.reply.event().worker().out();
        if (out.remaining() < this.size) {
            out.flip();
            while (out.remaining() > 0) {
                int sent = this.fill(debug);
                if (debug) {
                    this.reply.event().log("sent " + sent + " remaining " + out.remaining(), Event.DEBUG);
                }
                if (sent != 0) continue;
                this.reply.event().block(this);
                if (!debug) continue;
                this.reply.event().log("still in buffer " + out.remaining(), Event.DEBUG);
            }
        }
        out.clear();
    }

    @Override
    public void flush() throws IOException {
        if (this.reply.event().daemon().debug) {
            this.reply.event().log("flush " + this.length, Event.DEBUG);
        }
        try {
            this.internal(true);
        }
        catch (Exception e) {
            throw (Failure.Close)new Failure.Close("No flush!").initCause(e);
        }
    }

    @Override
    public int fill(boolean debug) throws IOException {
        ByteBuffer out = this.reply.event().worker().out();
        int remaining = 0;
        if (debug) {
            remaining = out.remaining();
        }
        int sent = 0;
        try {
            sent = this.reply.event().channel().write(out);
        }
        catch (IOException e) {
            throw (Failure.Close)new Failure.Close().initCause(e);
        }
        if (debug) {
            this.reply.event().log("filled " + sent + " out of " + remaining, Event.DEBUG);
        }
        return sent;
    }

    public abstract void finish() throws IOException;

    protected boolean zero() {
        return this.reply.code().startsWith("302") || this.reply.code().startsWith("304") || this.reply.code().startsWith("505");
    }

    static class Chunked
    extends Output {
        public static int OFFSET = 6;
        private int cursor = OFFSET;
        private int count = 0;

        Chunked(Reply reply) throws IOException {
            super(reply);
        }

        @Override
        public void write(int b) throws IOException {
            this.reply.event().worker().chunk()[this.cursor++] = (byte)b;
            ++this.count;
            if (this.count == this.size) {
                this.write();
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.length += len;
            if (this.fixed) {
                this.wrote(b, off, len);
                return;
            }
            byte[] chunk = this.reply.event().worker().chunk();
            int remain = this.size - this.count;
            if (len > remain) {
                System.arraycopy(b, off, chunk, this.cursor, remain);
                this.count = this.size;
                this.write();
                len -= remain;
                off += remain;
                while (len > this.size) {
                    System.arraycopy(b, off, chunk, OFFSET, this.size);
                    len -= this.size;
                    off += this.size;
                    this.count = this.size;
                    this.write();
                }
                this.cursor = OFFSET;
            }
            if (len > 0) {
                System.arraycopy(b, off, chunk, this.cursor, len);
                this.count += len;
                this.cursor += len;
            }
        }

        protected void write() throws IOException {
            int cursor;
            byte[] chunk = this.reply.event().worker().chunk();
            char[] header = Integer.toHexString(this.count).toCharArray();
            int length = header.length;
            int start = 4 - length;
            for (cursor = 0; cursor < length; ++cursor) {
                chunk[start + cursor] = (byte)header[cursor];
            }
            chunk[start + cursor++] = 13;
            chunk[start + cursor++] = 10;
            chunk[start + cursor++ + this.count] = 13;
            chunk[start + cursor++ + this.count] = 10;
            this.wrote(chunk, start, cursor + this.count);
            this.count = 0;
            this.cursor = OFFSET;
        }

        @Override
        public void finish() throws IOException {
            if (this.complete()) {
                throw new IOException("Reply already complete.");
            }
            this.push = false;
        }

        @Override
        public void flush() throws IOException {
            if (this.init) {
                if (this.zero()) {
                    if (this.reply.event().daemon().debug) {
                        this.reply.event().log("length " + this.length, Event.DEBUG);
                    }
                } else if (!this.fixed) {
                    if (this.reply.event().daemon().debug) {
                        this.reply.event().log("chunk flush " + this.count + " " + this.complete(), Event.DEBUG);
                    }
                    if (this.count > 0) {
                        this.write();
                    }
                    if (this.complete()) {
                        this.write();
                    }
                }
            } else if (!this.fixed) {
                if (this.reply.event().daemon().debug) {
                    this.reply.event().log("asynchronous push " + this.count, Event.DEBUG);
                }
                this.push = true;
            }
            super.flush();
        }
    }
}

