# OpenPrinter

The printer requires [Ink Cartridges](inkCartridges) in the left slots and paper in the right slot to print. The top Slot is the input Slot for scanning Pages/Books. The 9 Slots on the bottom are the printer output.

![](https://i.imgur.com/NqtIXM6.png)
* 4x Iron Nugget
* 2x Redstone
* 2x OpenComputers Microchip Tier1
* 1x OpenComputers PCB

## Methods

```lua
op = require("component").openprinter
op.writeln("String",[0xHEXCOLOR],["center"])
```
 
Color, and center are optional, format is 0xRRGGBB, using this will add one use of your color ink cartridge, center will attempt to render the string in the center of the page, instead of left justified.  you CAN use Minecraft's chat formatting control codes with calls to writeln, [Minecraft Color Codes](https://minecraft.gamepedia.com/Formatting_codes)  EACH CALL to a COLOR set will add one use of the color ink cartridge, calls to format codes will NOT.

```lua
op.setTitle("String")
```
Sets the "name" of the printed page, this also effects the item display in your inventory, never forget which page is which!

```lua
op.getPaperLevel()
```
Returns the amount of paper in your printer, 0-64 for Normal MC paper, or 0-256 for a paper roll.

```lua
op.getColorInkLevel() 
op.getBlackInkLevel()
```
returns the number of uses left in the ink cartridge 0-4000 (default)

```lua
op.clear()
```
Will clear everything set by previous calls to op.writeln()

```lua
op.print():boolean
```
Calling this method will print all previous calls to writeln to the printer.

```lua
op.scan():table
```
scans a printed page and returns the lines as table

```lua
op.scanLine(Integer:lineNumber):String
```
scans the given line from a printed page

```lua
op.scanBook():table
```
scans a book and returns its as table (vanilla and bibliocraft BigBook are currently supported)
