/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.AnnotationWriter;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ByteVector;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.CurrentFrame;
import org.spongepowered.asm.lib.Edge;
import org.spongepowered.asm.lib.Frame;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Handler;
import org.spongepowered.asm.lib.Item;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;

class MethodWriter
extends MethodVisitor {
    static final int ACC_CONSTRUCTOR = 524288;
    static final int SAME_FRAME = 0;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
    static final int RESERVED = 128;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
    static final int CHOP_FRAME = 248;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int APPEND_FRAME = 252;
    static final int FULL_FRAME = 255;
    static final int FRAMES = 0;
    static final int INSERTED_FRAMES = 1;
    static final int MAXS = 2;
    static final int NOTHING = 3;
    final ClassWriter cw;
    private int access;
    private final int name;
    private final int desc;
    private final String descriptor;
    String signature;
    int classReaderOffset;
    int classReaderLength;
    int exceptionCount;
    int[] exceptions;
    private ByteVector annd;
    private AnnotationWriter anns;
    private AnnotationWriter ianns;
    private AnnotationWriter tanns;
    private AnnotationWriter itanns;
    private AnnotationWriter[] panns;
    private AnnotationWriter[] ipanns;
    private int synthetics;
    private Attribute attrs;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;
    private int currentLocals;
    private int frameCount;
    private ByteVector stackMap;
    private int previousFrameOffset;
    private int[] previousFrame;
    private int[] frame;
    private int handlerCount;
    private Handler firstHandler;
    private Handler lastHandler;
    private int methodParametersCount;
    private ByteVector methodParameters;
    private int localVarCount;
    private ByteVector localVar;
    private int localVarTypeCount;
    private ByteVector localVarType;
    private int lineNumberCount;
    private ByteVector lineNumber;
    private int lastCodeOffset;
    private AnnotationWriter ctanns;
    private AnnotationWriter ictanns;
    private Attribute cattrs;
    private int subroutines;
    private final int compute;
    private Label labels;
    private Label previousBlock;
    private Label currentBlock;
    private int stackSize;
    private int maxStackSize;

    MethodWriter(ClassWriter cw2, int access, String name, String desc, String signature, String[] exceptions, int compute) {
        super(327680);
        if (cw2.firstMethod == null) {
            cw2.firstMethod = this;
        } else {
            cw2.lastMethod.mv = this;
        }
        cw2.lastMethod = this;
        this.cw = cw2;
        this.access = access;
        if ("<init>".equals(name)) {
            this.access |= 0x80000;
        }
        this.name = cw2.newUTF8(name);
        this.desc = cw2.newUTF8(desc);
        this.descriptor = desc;
        this.signature = signature;
        if (exceptions != null && exceptions.length > 0) {
            this.exceptionCount = exceptions.length;
            this.exceptions = new int[this.exceptionCount];
            for (int i2 = 0; i2 < this.exceptionCount; ++i2) {
                this.exceptions[i2] = cw2.newClass(exceptions[i2]);
            }
        }
        this.compute = compute;
        if (compute != 3) {
            int size = Type.getArgumentsAndReturnSizes(this.descriptor) >> 2;
            if ((access & 8) != 0) {
                --size;
            }
            this.maxLocals = size;
            this.currentLocals = size;
            this.labels = new Label();
            this.labels.status |= 8;
            this.visitLabel(this.labels);
        }
    }

    public void visitParameter(String name, int access) {
        if (this.methodParameters == null) {
            this.methodParameters = new ByteVector();
        }
        ++this.methodParametersCount;
        this.methodParameters.putShort(name == null ? 0 : this.cw.newUTF8(name)).putShort(access);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.annd = new ByteVector();
        return new AnnotationWriter(this.cw, false, this.annd, null, 0);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, 2);
        if (visible) {
            aw2.next = this.anns;
            this.anns = aw2;
        } else {
            aw2.next = this.ianns;
            this.ianns = aw2;
        }
        return aw2;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        AnnotationWriter.putTarget(typeRef, typePath, bv2);
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, bv2.length - 2);
        if (visible) {
            aw2.next = this.tanns;
            this.tanns = aw2;
        } else {
            aw2.next = this.itanns;
            this.itanns = aw2;
        }
        return aw2;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        if ("Ljava/lang/Synthetic;".equals(desc)) {
            this.synthetics = Math.max(this.synthetics, parameter + 1);
            return new AnnotationWriter(this.cw, false, bv2, null, 0);
        }
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, 2);
        if (visible) {
            if (this.panns == null) {
                this.panns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            aw2.next = this.panns[parameter];
            this.panns[parameter] = aw2;
        } else {
            if (this.ipanns == null) {
                this.ipanns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            aw2.next = this.ipanns[parameter];
            this.ipanns[parameter] = aw2;
        }
        return aw2;
    }

    public void visitAttribute(Attribute attr) {
        if (attr.isCodeAttribute()) {
            attr.next = this.cattrs;
            this.cattrs = attr;
        } else {
            attr.next = this.attrs;
            this.attrs = attr;
        }
    }

    public void visitCode() {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (this.compute == 0) {
            return;
        }
        if (this.compute == 1) {
            if (this.currentBlock.frame == null) {
                this.currentBlock.frame = new CurrentFrame();
                this.currentBlock.frame.owner = this.currentBlock;
                this.currentBlock.frame.initInputFrame(this.cw, this.access, Type.getArgumentTypes(this.descriptor), nLocal);
                this.visitImplicitFirstFrame();
            } else {
                if (type == -1) {
                    this.currentBlock.frame.set(this.cw, nLocal, local, nStack, stack);
                }
                this.visitFrame(this.currentBlock.frame);
            }
        } else if (type == -1) {
            int i2;
            if (this.previousFrame == null) {
                this.visitImplicitFirstFrame();
            }
            this.currentLocals = nLocal;
            int frameIndex = this.startFrame(this.code.length, nLocal, nStack);
            for (i2 = 0; i2 < nLocal; ++i2) {
                this.frame[frameIndex++] = local[i2] instanceof String ? 0x1700000 | this.cw.addType((String)local[i2]) : (local[i2] instanceof Integer ? (Integer)local[i2] : 0x1800000 | this.cw.addUninitializedType("", ((Label)local[i2]).position));
            }
            for (i2 = 0; i2 < nStack; ++i2) {
                this.frame[frameIndex++] = stack[i2] instanceof String ? 0x1700000 | this.cw.addType((String)stack[i2]) : (stack[i2] instanceof Integer ? (Integer)stack[i2] : 0x1800000 | this.cw.addUninitializedType("", ((Label)stack[i2]).position));
            }
            this.endFrame();
        } else {
            int delta;
            if (this.stackMap == null) {
                this.stackMap = new ByteVector();
                delta = this.code.length;
            } else {
                delta = this.code.length - this.previousFrameOffset - 1;
                if (delta < 0) {
                    if (type == 3) {
                        return;
                    }
                    throw new IllegalStateException();
                }
            }
            switch (type) {
                case 0: {
                    int i3;
                    this.currentLocals = nLocal;
                    this.stackMap.putByte(255).putShort(delta).putShort(nLocal);
                    for (i3 = 0; i3 < nLocal; ++i3) {
                        this.writeFrameType(local[i3]);
                    }
                    this.stackMap.putShort(nStack);
                    for (i3 = 0; i3 < nStack; ++i3) {
                        this.writeFrameType(stack[i3]);
                    }
                    break;
                }
                case 1: {
                    this.currentLocals += nLocal;
                    this.stackMap.putByte(251 + nLocal).putShort(delta);
                    for (int i4 = 0; i4 < nLocal; ++i4) {
                        this.writeFrameType(local[i4]);
                    }
                    break;
                }
                case 2: {
                    this.currentLocals -= nLocal;
                    this.stackMap.putByte(251 - nLocal).putShort(delta);
                    break;
                }
                case 3: {
                    if (delta < 64) {
                        this.stackMap.putByte(delta);
                        break;
                    }
                    this.stackMap.putByte(251).putShort(delta);
                    break;
                }
                case 4: {
                    if (delta < 64) {
                        this.stackMap.putByte(64 + delta);
                    } else {
                        this.stackMap.putByte(247).putShort(delta);
                    }
                    this.writeFrameType(stack[0]);
                }
            }
            this.previousFrameOffset = this.code.length;
            ++this.frameCount;
        }
        this.maxStack = Math.max(this.maxStack, nStack);
        this.maxLocals = Math.max(this.maxLocals, this.currentLocals);
    }

    public void visitInsn(int opcode) {
        this.lastCodeOffset = this.code.length;
        this.code.putByte(opcode);
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(opcode, 0, null, null);
            } else {
                int size = this.stackSize + Frame.SIZE[opcode];
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
            if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                this.noSuccessor();
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        this.lastCodeOffset = this.code.length;
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(opcode, operand, null, null);
            } else if (opcode != 188) {
                int size = this.stackSize + 1;
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
        }
        if (opcode == 17) {
            this.code.put12(opcode, operand);
        } else {
            this.code.put11(opcode, operand);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        int n2;
        this.lastCodeOffset = this.code.length;
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(opcode, var, null, null);
            } else if (opcode == 169) {
                this.currentBlock.status |= 0x100;
                this.currentBlock.inputStackTop = this.stackSize;
                this.noSuccessor();
            } else {
                int size = this.stackSize + Frame.SIZE[opcode];
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
        }
        if (this.compute != 3 && (n2 = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1) > this.maxLocals) {
            this.maxLocals = n2;
        }
        if (var < 4 && opcode != 169) {
            int opt = opcode < 54 ? 26 + (opcode - 21 << 2) + var : 59 + (opcode - 54 << 2) + var;
            this.code.putByte(opt);
        } else if (var >= 256) {
            this.code.putByte(196).put12(opcode, var);
        } else {
            this.code.put11(opcode, var);
        }
        if (opcode >= 54 && this.compute == 0 && this.handlerCount > 0) {
            this.visitLabel(new Label());
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        this.lastCodeOffset = this.code.length;
        Item i2 = this.cw.newClassItem(type);
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(opcode, this.code.length, this.cw, i2);
            } else if (opcode == 187) {
                int size = this.stackSize + 1;
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
        }
        this.code.put12(opcode, i2.index);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.lastCodeOffset = this.code.length;
        Item i2 = this.cw.newFieldItem(owner, name, desc);
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(opcode, 0, this.cw, i2);
            } else {
                int size;
                char c2 = desc.charAt(0);
                switch (opcode) {
                    case 178: {
                        size = this.stackSize + (c2 == 'D' || c2 == 'J' ? 2 : 1);
                        break;
                    }
                    case 179: {
                        size = this.stackSize + (c2 == 'D' || c2 == 'J' ? -2 : -1);
                        break;
                    }
                    case 180: {
                        size = this.stackSize + (c2 == 'D' || c2 == 'J' ? 1 : 0);
                        break;
                    }
                    default: {
                        size = this.stackSize + (c2 == 'D' || c2 == 'J' ? -3 : -2);
                    }
                }
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
        }
        this.code.put12(opcode, i2.index);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.lastCodeOffset = this.code.length;
        Item i2 = this.cw.newMethodItem(owner, name, desc, itf);
        int argSize = i2.intVal;
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(opcode, 0, this.cw, i2);
            } else {
                int size;
                if (argSize == 0) {
                    i2.intVal = argSize = Type.getArgumentsAndReturnSizes(desc);
                }
                if ((size = opcode == 184 ? this.stackSize - (argSize >> 2) + (argSize & 3) + 1 : this.stackSize - (argSize >> 2) + (argSize & 3)) > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
        }
        if (opcode == 185) {
            if (argSize == 0) {
                i2.intVal = argSize = Type.getArgumentsAndReturnSizes(desc);
            }
            this.code.put12(185, i2.index).put11(argSize >> 2, 0);
        } else {
            this.code.put12(opcode, i2.index);
        }
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.lastCodeOffset = this.code.length;
        Item i2 = this.cw.newInvokeDynamicItem(name, desc, bsm, bsmArgs);
        int argSize = i2.intVal;
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(186, 0, this.cw, i2);
            } else {
                int size;
                if (argSize == 0) {
                    i2.intVal = argSize = Type.getArgumentsAndReturnSizes(desc);
                }
                if ((size = this.stackSize - (argSize >> 2) + (argSize & 3) + 1) > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
        }
        this.code.put12(186, i2.index);
        this.code.putShort(0);
    }

    public void visitJumpInsn(int opcode, Label label) {
        boolean isWide = opcode >= 200;
        opcode = isWide ? opcode - 33 : opcode;
        this.lastCodeOffset = this.code.length;
        Label nextInsn = null;
        if (this.currentBlock != null) {
            if (this.compute == 0) {
                this.currentBlock.frame.execute(opcode, 0, null, null);
                label.getFirst().status |= 0x10;
                this.addSuccessor(0, label);
                if (opcode != 167) {
                    nextInsn = new Label();
                }
            } else if (this.compute == 1) {
                this.currentBlock.frame.execute(opcode, 0, null, null);
            } else if (opcode == 168) {
                if ((label.status & 0x200) == 0) {
                    label.status |= 0x200;
                    ++this.subroutines;
                }
                this.currentBlock.status |= 0x80;
                this.addSuccessor(this.stackSize + 1, label);
                nextInsn = new Label();
            } else {
                this.stackSize += Frame.SIZE[opcode];
                this.addSuccessor(this.stackSize, label);
            }
        }
        if ((label.status & 2) != 0 && label.position - this.code.length < Short.MIN_VALUE) {
            if (opcode == 167) {
                this.code.putByte(200);
            } else if (opcode == 168) {
                this.code.putByte(201);
            } else {
                if (nextInsn != null) {
                    nextInsn.status |= 0x10;
                }
                this.code.putByte(opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1);
                this.code.putShort(8);
                this.code.putByte(200);
            }
            label.put(this, this.code, this.code.length - 1, true);
        } else if (isWide) {
            this.code.putByte(opcode + 33);
            label.put(this, this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(opcode);
            label.put(this, this.code, this.code.length - 1, false);
        }
        if (this.currentBlock != null) {
            if (nextInsn != null) {
                this.visitLabel(nextInsn);
            }
            if (opcode == 167) {
                this.noSuccessor();
            }
        }
    }

    public void visitLabel(Label label) {
        this.cw.hasAsmInsns |= label.resolve(this, this.code.length, this.code.data);
        if ((label.status & 1) != 0) {
            return;
        }
        if (this.compute == 0) {
            if (this.currentBlock != null) {
                if (label.position == this.currentBlock.position) {
                    this.currentBlock.status |= label.status & 0x10;
                    label.frame = this.currentBlock.frame;
                    return;
                }
                this.addSuccessor(0, label);
            }
            this.currentBlock = label;
            if (label.frame == null) {
                label.frame = new Frame();
                label.frame.owner = label;
            }
            if (this.previousBlock != null) {
                if (label.position == this.previousBlock.position) {
                    this.previousBlock.status |= label.status & 0x10;
                    label.frame = this.previousBlock.frame;
                    this.currentBlock = this.previousBlock;
                    return;
                }
                this.previousBlock.successor = label;
            }
            this.previousBlock = label;
        } else if (this.compute == 1) {
            if (this.currentBlock == null) {
                this.currentBlock = label;
            } else {
                this.currentBlock.frame.owner = label;
            }
        } else if (this.compute == 2) {
            if (this.currentBlock != null) {
                this.currentBlock.outputStackMax = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
            if (this.previousBlock != null) {
                this.previousBlock.successor = label;
            }
            this.previousBlock = label;
        }
    }

    public void visitLdcInsn(Object cst) {
        this.lastCodeOffset = this.code.length;
        Item i2 = this.cw.newConstItem(cst);
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(18, 0, this.cw, i2);
            } else {
                int size = i2.type == 5 || i2.type == 6 ? this.stackSize + 2 : this.stackSize + 1;
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
        }
        int index = i2.index;
        if (i2.type == 5 || i2.type == 6) {
            this.code.put12(20, index);
        } else if (index >= 256) {
            this.code.put12(19, index);
        } else {
            this.code.put11(18, index);
        }
    }

    public void visitIincInsn(int var, int increment) {
        int n2;
        this.lastCodeOffset = this.code.length;
        if (this.currentBlock != null && (this.compute == 0 || this.compute == 1)) {
            this.currentBlock.frame.execute(132, var, null, null);
        }
        if (this.compute != 3 && (n2 = var + 1) > this.maxLocals) {
            this.maxLocals = n2;
        }
        if (var > 255 || increment > 127 || increment < -128) {
            this.code.putByte(196).put12(132, var).putShort(increment);
        } else {
            this.code.putByte(132).put11(var, increment);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.lastCodeOffset = this.code.length;
        int source = this.code.length;
        this.code.putByte(170);
        this.code.putByteArray(null, 0, (4 - this.code.length % 4) % 4);
        dflt.put(this, this.code, source, true);
        this.code.putInt(min).putInt(max);
        for (int i2 = 0; i2 < labels.length; ++i2) {
            labels[i2].put(this, this.code, source, true);
        }
        this.visitSwitchInsn(dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.lastCodeOffset = this.code.length;
        int source = this.code.length;
        this.code.putByte(171);
        this.code.putByteArray(null, 0, (4 - this.code.length % 4) % 4);
        dflt.put(this, this.code, source, true);
        this.code.putInt(labels.length);
        for (int i2 = 0; i2 < labels.length; ++i2) {
            this.code.putInt(keys[i2]);
            labels[i2].put(this, this.code, source, true);
        }
        this.visitSwitchInsn(dflt, labels);
    }

    private void visitSwitchInsn(Label dflt, Label[] labels) {
        if (this.currentBlock != null) {
            if (this.compute == 0) {
                this.currentBlock.frame.execute(171, 0, null, null);
                this.addSuccessor(0, dflt);
                dflt.getFirst().status |= 0x10;
                for (int i2 = 0; i2 < labels.length; ++i2) {
                    this.addSuccessor(0, labels[i2]);
                    labels[i2].getFirst().status |= 0x10;
                }
            } else {
                --this.stackSize;
                this.addSuccessor(this.stackSize, dflt);
                for (int i3 = 0; i3 < labels.length; ++i3) {
                    this.addSuccessor(this.stackSize, labels[i3]);
                }
            }
            this.noSuccessor();
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.lastCodeOffset = this.code.length;
        Item i2 = this.cw.newClassItem(desc);
        if (this.currentBlock != null) {
            if (this.compute == 0 || this.compute == 1) {
                this.currentBlock.frame.execute(197, dims, this.cw, i2);
            } else {
                this.stackSize += 1 - dims;
            }
        }
        this.code.put12(197, i2.index).putByte(dims);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        typeRef = typeRef & 0xFF0000FF | this.lastCodeOffset << 8;
        AnnotationWriter.putTarget(typeRef, typePath, bv2);
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, bv2.length - 2);
        if (visible) {
            aw2.next = this.ctanns;
            this.ctanns = aw2;
        } else {
            aw2.next = this.ictanns;
            this.ictanns = aw2;
        }
        return aw2;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        ++this.handlerCount;
        Handler h2 = new Handler();
        h2.start = start;
        h2.end = end;
        h2.handler = handler;
        h2.desc = type;
        int n2 = h2.type = type != null ? this.cw.newClass(type) : 0;
        if (this.lastHandler == null) {
            this.firstHandler = h2;
        } else {
            this.lastHandler.next = h2;
        }
        this.lastHandler = h2;
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        AnnotationWriter.putTarget(typeRef, typePath, bv2);
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, bv2.length - 2);
        if (visible) {
            aw2.next = this.ctanns;
            this.ctanns = aw2;
        } else {
            aw2.next = this.ictanns;
            this.ictanns = aw2;
        }
        return aw2;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        char c2;
        int n2;
        if (signature != null) {
            if (this.localVarType == null) {
                this.localVarType = new ByteVector();
            }
            ++this.localVarTypeCount;
            this.localVarType.putShort(start.position).putShort(end.position - start.position).putShort(this.cw.newUTF8(name)).putShort(this.cw.newUTF8(signature)).putShort(index);
        }
        if (this.localVar == null) {
            this.localVar = new ByteVector();
        }
        ++this.localVarCount;
        this.localVar.putShort(start.position).putShort(end.position - start.position).putShort(this.cw.newUTF8(name)).putShort(this.cw.newUTF8(desc)).putShort(index);
        if (this.compute != 3 && (n2 = index + ((c2 = desc.charAt(0)) == 'J' || c2 == 'D' ? 2 : 1)) > this.maxLocals) {
            this.maxLocals = n2;
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        bv2.putByte(typeRef >>> 24).putShort(start.length);
        for (int i2 = 0; i2 < start.length; ++i2) {
            bv2.putShort(start[i2].position).putShort(end[i2].position - start[i2].position).putShort(index[i2]);
        }
        if (typePath == null) {
            bv2.putByte(0);
        } else {
            int length = typePath.b[typePath.offset] * 2 + 1;
            bv2.putByteArray(typePath.b, typePath.offset, length);
        }
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, bv2.length - 2);
        if (visible) {
            aw2.next = this.ctanns;
            this.ctanns = aw2;
        } else {
            aw2.next = this.ictanns;
            this.ictanns = aw2;
        }
        return aw2;
    }

    public void visitLineNumber(int line, Label start) {
        if (this.lineNumber == null) {
            this.lineNumber = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumber.putShort(start.position);
        this.lineNumber.putShort(line);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.compute == 0) {
            Label l2;
            Handler handler = this.firstHandler;
            while (handler != null) {
                Label l3 = handler.start.getFirst();
                Label h2 = handler.handler.getFirst();
                Label e2 = handler.end.getFirst();
                String t2 = handler.desc == null ? "java/lang/Throwable" : handler.desc;
                int kind = 0x1700000 | this.cw.addType(t2);
                h2.status |= 0x10;
                while (l3 != e2) {
                    Edge b2 = new Edge();
                    b2.info = kind;
                    b2.successor = h2;
                    b2.next = l3.successors;
                    l3.successors = b2;
                    l3 = l3.successor;
                }
                handler = handler.next;
            }
            Frame f2 = this.labels.frame;
            f2.initInputFrame(this.cw, this.access, Type.getArgumentTypes(this.descriptor), this.maxLocals);
            this.visitFrame(f2);
            int max = 0;
            Label changed = this.labels;
            while (changed != null) {
                l2 = changed;
                changed = changed.next;
                l2.next = null;
                f2 = l2.frame;
                if ((l2.status & 0x10) != 0) {
                    l2.status |= 0x20;
                }
                l2.status |= 0x40;
                int blockMax = f2.inputStack.length + l2.outputStackMax;
                if (blockMax > max) {
                    max = blockMax;
                }
                Edge e3 = l2.successors;
                while (e3 != null) {
                    Label n2 = e3.successor.getFirst();
                    boolean change = f2.merge(this.cw, n2.frame, e3.info);
                    if (change && n2.next == null) {
                        n2.next = changed;
                        changed = n2;
                    }
                    e3 = e3.next;
                }
            }
            l2 = this.labels;
            while (l2 != null) {
                int start;
                Label k2;
                int end;
                f2 = l2.frame;
                if ((l2.status & 0x20) != 0) {
                    this.visitFrame(f2);
                }
                if ((l2.status & 0x40) == 0 && (end = ((k2 = l2.successor) == null ? this.code.length : k2.position) - 1) >= (start = l2.position)) {
                    max = Math.max(max, 1);
                    for (int i2 = start; i2 < end; ++i2) {
                        this.code.data[i2] = 0;
                    }
                    this.code.data[end] = -65;
                    int frameIndex = this.startFrame(start, 0, 1);
                    this.frame[frameIndex] = 0x1700000 | this.cw.addType("java/lang/Throwable");
                    this.endFrame();
                    this.firstHandler = Handler.remove(this.firstHandler, l2, k2);
                }
                l2 = l2.successor;
            }
            handler = this.firstHandler;
            this.handlerCount = 0;
            while (handler != null) {
                ++this.handlerCount;
                handler = handler.next;
            }
            this.maxStack = max;
        } else if (this.compute == 2) {
            Handler handler = this.firstHandler;
            while (handler != null) {
                Label l4 = handler.start;
                Label h3 = handler.handler;
                Label e4 = handler.end;
                while (l4 != e4) {
                    Edge b3 = new Edge();
                    b3.info = Integer.MAX_VALUE;
                    b3.successor = h3;
                    if ((l4.status & 0x80) == 0) {
                        b3.next = l4.successors;
                        l4.successors = b3;
                    } else {
                        b3.next = l4.successors.next.next;
                        l4.successors.next.next = b3;
                    }
                    l4 = l4.successor;
                }
                handler = handler.next;
            }
            if (this.subroutines > 0) {
                int id = 0;
                this.labels.visitSubroutine(null, 1L, this.subroutines);
                Label l5 = this.labels;
                while (l5 != null) {
                    if ((l5.status & 0x80) != 0) {
                        Label subroutine = l5.successors.next.successor;
                        if ((subroutine.status & 0x400) == 0) {
                            subroutine.visitSubroutine(null, (long)(++id) / 32L << 32 | 1L << id % 32, this.subroutines);
                        }
                    }
                    l5 = l5.successor;
                }
                l5 = this.labels;
                while (l5 != null) {
                    if ((l5.status & 0x80) != 0) {
                        Label L = this.labels;
                        while (L != null) {
                            L.status &= 0xFFFFF7FF;
                            L = L.successor;
                        }
                        Label subroutine = l5.successors.next.successor;
                        subroutine.visitSubroutine(l5, 0L, this.subroutines);
                    }
                    l5 = l5.successor;
                }
            }
            int max = 0;
            Label stack = this.labels;
            while (stack != null) {
                Label l6 = stack;
                stack = stack.next;
                int start = l6.inputStackTop;
                int blockMax = start + l6.outputStackMax;
                if (blockMax > max) {
                    max = blockMax;
                }
                Edge b4 = l6.successors;
                if ((l6.status & 0x80) != 0) {
                    b4 = b4.next;
                }
                while (b4 != null) {
                    l6 = b4.successor;
                    if ((l6.status & 8) == 0) {
                        l6.inputStackTop = b4.info == Integer.MAX_VALUE ? 1 : start + b4.info;
                        l6.status |= 8;
                        l6.next = stack;
                        stack = l6;
                    }
                    b4 = b4.next;
                }
            }
            this.maxStack = Math.max(maxStack, max);
        } else {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
        }
    }

    public void visitEnd() {
    }

    private void addSuccessor(int info, Label successor) {
        Edge b2 = new Edge();
        b2.info = info;
        b2.successor = successor;
        b2.next = this.currentBlock.successors;
        this.currentBlock.successors = b2;
    }

    private void noSuccessor() {
        if (this.compute == 0) {
            Label l2 = new Label();
            l2.frame = new Frame();
            l2.frame.owner = l2;
            l2.resolve(this, this.code.length, this.code.data);
            this.previousBlock.successor = l2;
            this.previousBlock = l2;
        } else {
            this.currentBlock.outputStackMax = this.maxStackSize;
        }
        if (this.compute != 1) {
            this.currentBlock = null;
        }
    }

    private void visitFrame(Frame f2) {
        int t2;
        int i2;
        int nTop = 0;
        int nLocal = 0;
        int nStack = 0;
        int[] locals = f2.inputLocals;
        int[] stacks = f2.inputStack;
        for (i2 = 0; i2 < locals.length; ++i2) {
            t2 = locals[i2];
            if (t2 == 0x1000000) {
                ++nTop;
            } else {
                nLocal += nTop + 1;
                nTop = 0;
            }
            if (t2 != 0x1000004 && t2 != 0x1000003) continue;
            ++i2;
        }
        for (i2 = 0; i2 < stacks.length; ++i2) {
            t2 = stacks[i2];
            ++nStack;
            if (t2 != 0x1000004 && t2 != 0x1000003) continue;
            ++i2;
        }
        int frameIndex = this.startFrame(f2.owner.position, nLocal, nStack);
        i2 = 0;
        while (nLocal > 0) {
            t2 = locals[i2];
            this.frame[frameIndex++] = t2;
            if (t2 == 0x1000004 || t2 == 0x1000003) {
                ++i2;
            }
            ++i2;
            --nLocal;
        }
        for (i2 = 0; i2 < stacks.length; ++i2) {
            t2 = stacks[i2];
            this.frame[frameIndex++] = t2;
            if (t2 != 0x1000004 && t2 != 0x1000003) continue;
            ++i2;
        }
        this.endFrame();
    }

    private void visitImplicitFirstFrame() {
        int frameIndex = this.startFrame(0, this.descriptor.length() + 1, 0);
        if ((this.access & 8) == 0) {
            this.frame[frameIndex++] = (this.access & 0x80000) == 0 ? 0x1700000 | this.cw.addType(this.cw.thisName) : 6;
        }
        int i2 = 1;
        block8: while (true) {
            int j2 = i2;
            switch (this.descriptor.charAt(i2++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.frame[frameIndex++] = 1;
                    continue block8;
                }
                case 'F': {
                    this.frame[frameIndex++] = 2;
                    continue block8;
                }
                case 'J': {
                    this.frame[frameIndex++] = 4;
                    continue block8;
                }
                case 'D': {
                    this.frame[frameIndex++] = 3;
                    continue block8;
                }
                case '[': {
                    while (this.descriptor.charAt(i2) == '[') {
                        ++i2;
                    }
                    if (this.descriptor.charAt(i2) == 'L') {
                        ++i2;
                        while (this.descriptor.charAt(i2) != ';') {
                            ++i2;
                        }
                    }
                    this.frame[frameIndex++] = 0x1700000 | this.cw.addType(this.descriptor.substring(j2, ++i2));
                    continue block8;
                }
                case 'L': {
                    while (this.descriptor.charAt(i2) != ';') {
                        ++i2;
                    }
                    this.frame[frameIndex++] = 0x1700000 | this.cw.addType(this.descriptor.substring(j2 + 1, i2++));
                    continue block8;
                }
            }
            break;
        }
        this.frame[1] = frameIndex - 3;
        this.endFrame();
    }

    private int startFrame(int offset, int nLocal, int nStack) {
        int n2 = 3 + nLocal + nStack;
        if (this.frame == null || this.frame.length < n2) {
            this.frame = new int[n2];
        }
        this.frame[0] = offset;
        this.frame[1] = nLocal;
        this.frame[2] = nStack;
        return 3;
    }

    private void endFrame() {
        if (this.previousFrame != null) {
            if (this.stackMap == null) {
                this.stackMap = new ByteVector();
            }
            this.writeFrame();
            ++this.frameCount;
        }
        this.previousFrame = this.frame;
        this.frame = null;
    }

    private void writeFrame() {
        int clocalsSize = this.frame[1];
        int cstackSize = this.frame[2];
        if ((this.cw.version & 0xFFFF) < 50) {
            this.stackMap.putShort(this.frame[0]).putShort(clocalsSize);
            this.writeFrameTypes(3, 3 + clocalsSize);
            this.stackMap.putShort(cstackSize);
            this.writeFrameTypes(3 + clocalsSize, 3 + clocalsSize + cstackSize);
            return;
        }
        int localsSize = this.previousFrame[1];
        int type = 255;
        int k2 = 0;
        int delta = this.frameCount == 0 ? this.frame[0] : this.frame[0] - this.previousFrame[0] - 1;
        if (cstackSize == 0) {
            k2 = clocalsSize - localsSize;
            switch (k2) {
                case -3: 
                case -2: 
                case -1: {
                    type = 248;
                    localsSize = clocalsSize;
                    break;
                }
                case 0: {
                    type = delta < 64 ? 0 : 251;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    type = 252;
                }
            }
        } else if (clocalsSize == localsSize && cstackSize == 1) {
            int n2 = type = delta < 63 ? 64 : 247;
        }
        if (type != 255) {
            int l2 = 3;
            for (int j2 = 0; j2 < localsSize; ++j2) {
                if (this.frame[l2] != this.previousFrame[l2]) {
                    type = 255;
                    break;
                }
                ++l2;
            }
        }
        switch (type) {
            case 0: {
                this.stackMap.putByte(delta);
                break;
            }
            case 64: {
                this.stackMap.putByte(64 + delta);
                this.writeFrameTypes(3 + clocalsSize, 4 + clocalsSize);
                break;
            }
            case 247: {
                this.stackMap.putByte(247).putShort(delta);
                this.writeFrameTypes(3 + clocalsSize, 4 + clocalsSize);
                break;
            }
            case 251: {
                this.stackMap.putByte(251).putShort(delta);
                break;
            }
            case 248: {
                this.stackMap.putByte(251 + k2).putShort(delta);
                break;
            }
            case 252: {
                this.stackMap.putByte(251 + k2).putShort(delta);
                this.writeFrameTypes(3 + localsSize, 3 + clocalsSize);
                break;
            }
            default: {
                this.stackMap.putByte(255).putShort(delta).putShort(clocalsSize);
                this.writeFrameTypes(3, 3 + clocalsSize);
                this.stackMap.putShort(cstackSize);
                this.writeFrameTypes(3 + clocalsSize, 3 + clocalsSize + cstackSize);
            }
        }
    }

    private void writeFrameTypes(int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            int t2 = this.frame[i2];
            int d2 = t2 & 0xF0000000;
            if (d2 == 0) {
                int v2 = t2 & 0xFFFFF;
                switch (t2 & 0xFF00000) {
                    case 0x1700000: {
                        this.stackMap.putByte(7).putShort(this.cw.newClass(this.cw.typeTable[v2].strVal1));
                        break;
                    }
                    case 0x1800000: {
                        this.stackMap.putByte(8).putShort(this.cw.typeTable[v2].intVal);
                        break;
                    }
                    default: {
                        this.stackMap.putByte(v2);
                        break;
                    }
                }
                continue;
            }
            StringBuilder sb = new StringBuilder();
            d2 >>= 28;
            while (d2-- > 0) {
                sb.append('[');
            }
            if ((t2 & 0xFF00000) == 0x1700000) {
                sb.append('L');
                sb.append(this.cw.typeTable[t2 & 0xFFFFF].strVal1);
                sb.append(';');
            } else {
                switch (t2 & 0xF) {
                    case 1: {
                        sb.append('I');
                        break;
                    }
                    case 2: {
                        sb.append('F');
                        break;
                    }
                    case 3: {
                        sb.append('D');
                        break;
                    }
                    case 9: {
                        sb.append('Z');
                        break;
                    }
                    case 10: {
                        sb.append('B');
                        break;
                    }
                    case 11: {
                        sb.append('C');
                        break;
                    }
                    case 12: {
                        sb.append('S');
                        break;
                    }
                    default: {
                        sb.append('J');
                    }
                }
            }
            this.stackMap.putByte(7).putShort(this.cw.newClass(sb.toString()));
        }
    }

    private void writeFrameType(Object type) {
        if (type instanceof String) {
            this.stackMap.putByte(7).putShort(this.cw.newClass((String)type));
        } else if (type instanceof Integer) {
            this.stackMap.putByte((Integer)type);
        } else {
            this.stackMap.putByte(8).putShort(((Label)type).position);
        }
    }

    final int getSize() {
        int i2;
        if (this.classReaderOffset != 0) {
            return 6 + this.classReaderLength;
        }
        int size = 8;
        if (this.code.length > 0) {
            if (this.code.length > 65535) {
                throw new RuntimeException("Method code too large!");
            }
            this.cw.newUTF8("Code");
            size += 18 + this.code.length + 8 * this.handlerCount;
            if (this.localVar != null) {
                this.cw.newUTF8("LocalVariableTable");
                size += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                this.cw.newUTF8("LocalVariableTypeTable");
                size += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                this.cw.newUTF8("LineNumberTable");
                size += 8 + this.lineNumber.length;
            }
            if (this.stackMap != null) {
                boolean zip = (this.cw.version & 0xFFFF) >= 50;
                this.cw.newUTF8(zip ? "StackMapTable" : "StackMap");
                size += 8 + this.stackMap.length;
            }
            if (this.ctanns != null) {
                this.cw.newUTF8("RuntimeVisibleTypeAnnotations");
                size += 8 + this.ctanns.getSize();
            }
            if (this.ictanns != null) {
                this.cw.newUTF8("RuntimeInvisibleTypeAnnotations");
                size += 8 + this.ictanns.getSize();
            }
            if (this.cattrs != null) {
                size += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            size += 8 + 2 * this.exceptionCount;
        }
        if ((this.access & 0x1000) != 0 && ((this.cw.version & 0xFFFF) < 49 || (this.access & 0x40000) != 0)) {
            this.cw.newUTF8("Synthetic");
            size += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            size += 6;
        }
        if (this.signature != null) {
            this.cw.newUTF8("Signature");
            this.cw.newUTF8(this.signature);
            size += 8;
        }
        if (this.methodParameters != null) {
            this.cw.newUTF8("MethodParameters");
            size += 7 + this.methodParameters.length;
        }
        if (this.annd != null) {
            this.cw.newUTF8("AnnotationDefault");
            size += 6 + this.annd.length;
        }
        if (this.anns != null) {
            this.cw.newUTF8("RuntimeVisibleAnnotations");
            size += 8 + this.anns.getSize();
        }
        if (this.ianns != null) {
            this.cw.newUTF8("RuntimeInvisibleAnnotations");
            size += 8 + this.ianns.getSize();
        }
        if (this.tanns != null) {
            this.cw.newUTF8("RuntimeVisibleTypeAnnotations");
            size += 8 + this.tanns.getSize();
        }
        if (this.itanns != null) {
            this.cw.newUTF8("RuntimeInvisibleTypeAnnotations");
            size += 8 + this.itanns.getSize();
        }
        if (this.panns != null) {
            this.cw.newUTF8("RuntimeVisibleParameterAnnotations");
            size += 7 + 2 * (this.panns.length - this.synthetics);
            for (i2 = this.panns.length - 1; i2 >= this.synthetics; --i2) {
                size += this.panns[i2] == null ? 0 : this.panns[i2].getSize();
            }
        }
        if (this.ipanns != null) {
            this.cw.newUTF8("RuntimeInvisibleParameterAnnotations");
            size += 7 + 2 * (this.ipanns.length - this.synthetics);
            for (i2 = this.ipanns.length - 1; i2 >= this.synthetics; --i2) {
                size += this.ipanns[i2] == null ? 0 : this.ipanns[i2].getSize();
            }
        }
        if (this.attrs != null) {
            size += this.attrs.getSize(this.cw, null, 0, -1, -1);
        }
        return size;
    }

    final void put(ByteVector out) {
        int FACTOR = 64;
        int mask = 0xE0000 | (this.access & 0x40000) / 64;
        out.putShort(this.access & ~mask).putShort(this.name).putShort(this.desc);
        if (this.classReaderOffset != 0) {
            out.putByteArray(this.cw.cr.b, this.classReaderOffset, this.classReaderLength);
            return;
        }
        int attributeCount = 0;
        if (this.code.length > 0) {
            ++attributeCount;
        }
        if (this.exceptionCount > 0) {
            ++attributeCount;
        }
        if ((this.access & 0x1000) != 0 && ((this.cw.version & 0xFFFF) < 49 || (this.access & 0x40000) != 0)) {
            ++attributeCount;
        }
        if ((this.access & 0x20000) != 0) {
            ++attributeCount;
        }
        if (this.signature != null) {
            ++attributeCount;
        }
        if (this.methodParameters != null) {
            ++attributeCount;
        }
        if (this.annd != null) {
            ++attributeCount;
        }
        if (this.anns != null) {
            ++attributeCount;
        }
        if (this.ianns != null) {
            ++attributeCount;
        }
        if (this.tanns != null) {
            ++attributeCount;
        }
        if (this.itanns != null) {
            ++attributeCount;
        }
        if (this.panns != null) {
            ++attributeCount;
        }
        if (this.ipanns != null) {
            ++attributeCount;
        }
        if (this.attrs != null) {
            attributeCount += this.attrs.getCount();
        }
        out.putShort(attributeCount);
        if (this.code.length > 0) {
            int size = 12 + this.code.length + 8 * this.handlerCount;
            if (this.localVar != null) {
                size += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                size += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                size += 8 + this.lineNumber.length;
            }
            if (this.stackMap != null) {
                size += 8 + this.stackMap.length;
            }
            if (this.ctanns != null) {
                size += 8 + this.ctanns.getSize();
            }
            if (this.ictanns != null) {
                size += 8 + this.ictanns.getSize();
            }
            if (this.cattrs != null) {
                size += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
            out.putShort(this.cw.newUTF8("Code")).putInt(size);
            out.putShort(this.maxStack).putShort(this.maxLocals);
            out.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            out.putShort(this.handlerCount);
            if (this.handlerCount > 0) {
                Handler h2 = this.firstHandler;
                while (h2 != null) {
                    out.putShort(h2.start.position).putShort(h2.end.position).putShort(h2.handler.position).putShort(h2.type);
                    h2 = h2.next;
                }
            }
            attributeCount = 0;
            if (this.localVar != null) {
                ++attributeCount;
            }
            if (this.localVarType != null) {
                ++attributeCount;
            }
            if (this.lineNumber != null) {
                ++attributeCount;
            }
            if (this.stackMap != null) {
                ++attributeCount;
            }
            if (this.ctanns != null) {
                ++attributeCount;
            }
            if (this.ictanns != null) {
                ++attributeCount;
            }
            if (this.cattrs != null) {
                attributeCount += this.cattrs.getCount();
            }
            out.putShort(attributeCount);
            if (this.localVar != null) {
                out.putShort(this.cw.newUTF8("LocalVariableTable"));
                out.putInt(this.localVar.length + 2).putShort(this.localVarCount);
                out.putByteArray(this.localVar.data, 0, this.localVar.length);
            }
            if (this.localVarType != null) {
                out.putShort(this.cw.newUTF8("LocalVariableTypeTable"));
                out.putInt(this.localVarType.length + 2).putShort(this.localVarTypeCount);
                out.putByteArray(this.localVarType.data, 0, this.localVarType.length);
            }
            if (this.lineNumber != null) {
                out.putShort(this.cw.newUTF8("LineNumberTable"));
                out.putInt(this.lineNumber.length + 2).putShort(this.lineNumberCount);
                out.putByteArray(this.lineNumber.data, 0, this.lineNumber.length);
            }
            if (this.stackMap != null) {
                boolean zip = (this.cw.version & 0xFFFF) >= 50;
                out.putShort(this.cw.newUTF8(zip ? "StackMapTable" : "StackMap"));
                out.putInt(this.stackMap.length + 2).putShort(this.frameCount);
                out.putByteArray(this.stackMap.data, 0, this.stackMap.length);
            }
            if (this.ctanns != null) {
                out.putShort(this.cw.newUTF8("RuntimeVisibleTypeAnnotations"));
                this.ctanns.put(out);
            }
            if (this.ictanns != null) {
                out.putShort(this.cw.newUTF8("RuntimeInvisibleTypeAnnotations"));
                this.ictanns.put(out);
            }
            if (this.cattrs != null) {
                this.cattrs.put(this.cw, this.code.data, this.code.length, this.maxLocals, this.maxStack, out);
            }
        }
        if (this.exceptionCount > 0) {
            out.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            out.putShort(this.exceptionCount);
            for (int i2 = 0; i2 < this.exceptionCount; ++i2) {
                out.putShort(this.exceptions[i2]);
            }
        }
        if ((this.access & 0x1000) != 0 && ((this.cw.version & 0xFFFF) < 49 || (this.access & 0x40000) != 0)) {
            out.putShort(this.cw.newUTF8("Synthetic")).putInt(0);
        }
        if ((this.access & 0x20000) != 0) {
            out.putShort(this.cw.newUTF8("Deprecated")).putInt(0);
        }
        if (this.signature != null) {
            out.putShort(this.cw.newUTF8("Signature")).putInt(2).putShort(this.cw.newUTF8(this.signature));
        }
        if (this.methodParameters != null) {
            out.putShort(this.cw.newUTF8("MethodParameters"));
            out.putInt(this.methodParameters.length + 1).putByte(this.methodParametersCount);
            out.putByteArray(this.methodParameters.data, 0, this.methodParameters.length);
        }
        if (this.annd != null) {
            out.putShort(this.cw.newUTF8("AnnotationDefault"));
            out.putInt(this.annd.length);
            out.putByteArray(this.annd.data, 0, this.annd.length);
        }
        if (this.anns != null) {
            out.putShort(this.cw.newUTF8("RuntimeVisibleAnnotations"));
            this.anns.put(out);
        }
        if (this.ianns != null) {
            out.putShort(this.cw.newUTF8("RuntimeInvisibleAnnotations"));
            this.ianns.put(out);
        }
        if (this.tanns != null) {
            out.putShort(this.cw.newUTF8("RuntimeVisibleTypeAnnotations"));
            this.tanns.put(out);
        }
        if (this.itanns != null) {
            out.putShort(this.cw.newUTF8("RuntimeInvisibleTypeAnnotations"));
            this.itanns.put(out);
        }
        if (this.panns != null) {
            out.putShort(this.cw.newUTF8("RuntimeVisibleParameterAnnotations"));
            AnnotationWriter.put(this.panns, this.synthetics, out);
        }
        if (this.ipanns != null) {
            out.putShort(this.cw.newUTF8("RuntimeInvisibleParameterAnnotations"));
            AnnotationWriter.put(this.ipanns, this.synthetics, out);
        }
        if (this.attrs != null) {
            this.attrs.put(this.cw, null, 0, -1, -1, out);
        }
    }
}

