/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.IntermittentAnimation;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.IntermittentAnimatableEntity;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemSpawnEgg;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class MowzieEntity
extends EntityCreature
implements IEntityAdditionalSpawnData,
IAnimatedEntity,
IntermittentAnimatableEntity {
    private static final byte START_IA_HEALTH_UPDATE_ID = 4;
    public int frame;
    public float targetDistance;
    public float targetAngle;
    public AnimationAI currentAnim = null;
    public boolean active;
    public EntityLivingBase blockingEntity = null;
    private int animationTick;
    private Animation animation = NO_ANIMATION;
    private List<IntermittentAnimation> intermittentAnimations = new ArrayList<IntermittentAnimation>();
    public Vec3d moveVec = new Vec3d(0.0, 0.0, 0.0);
    public boolean playsHurtAnimation = true;
    public Vec3d[] socketPosArray = new Vec3d[0];
    protected boolean prevOnGround;
    protected boolean prevPrevOnGround;
    protected boolean willLandSoon;

    public MowzieEntity(World world) {
        super(world);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        String id = this.getPickedEntityId();
        if (id == null) {
            return ItemStack.field_190927_a;
        }
        ResourceLocation res = new ResourceLocation(id);
        if (EntityHandler.INSTANCE.hasEntityEggInfo(res)) {
            ItemStack stack = new ItemStack((Item)ItemHandler.SPAWN_EGG);
            ItemSpawnEgg.applyEntityIdToItemStack(stack, res);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    protected String getPickedEntityId() {
        return this.func_70022_Q();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean func_70601_bi() {
        boolean flag = this.field_70170_p.field_73011_w.getDimension() == 0;
        return super.func_70601_bi() && flag;
    }

    public void func_70071_h_() {
        this.prevPrevOnGround = this.prevOnGround;
        this.prevOnGround = this.field_70122_E;
        super.func_70071_h_();
        ++this.frame;
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.field_70170_p.field_72995_K && this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
        if (this.func_70638_az() != null) {
            this.targetDistance = this.func_70032_d((Entity)this.func_70638_az());
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.func_70638_az());
        }
        this.willLandSoon = !this.field_70122_E && this.field_70170_p.func_184143_b(this.func_174813_aQ().func_191194_a(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y)));
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public void writeSpawnData(ByteBuf buf) {
    }

    public void readSpawnData(ByteBuf buf) {
        this.field_70126_B = this.field_70177_z;
        this.field_70761_aq = this.field_70758_at = this.field_70759_as;
        this.field_70760_ar = this.field_70758_at;
    }

    public int getAttack() {
        return 0;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean attackEntityAsMob(Entity entityIn, float damageMultiplier) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * damageMultiplier;
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.field_70161_v - first.field_70161_v, second.field_70165_t - first.field_70165_t) * 57.29577951308232 + 90.0;
    }

    public List<EntityPlayer> getPlayersNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<EntityPlayer> listEntityPlayers = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof EntityPlayer && (double)this.func_70032_d((Entity)entityNeighbor) <= radius).map(entityNeighbor -> (EntityPlayer)entityNeighbor).collect(Collectors.toList());
        return listEntityPlayers;
    }

    public List<EntityLivingBase> getAttackableEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<EntityLivingBase> listEntityLivingBase = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof EntityLivingBase && ((EntityLivingBase)entityNeighbor).func_190631_cK() && (!(entityNeighbor instanceof EntityPlayer) || !((EntityPlayer)entityNeighbor).func_184812_l_()) && (double)this.func_70032_d((Entity)entityNeighbor) <= radius).map(entityNeighbor -> (EntityLivingBase)entityNeighbor).collect(Collectors.toList());
        return listEntityLivingBase;
    }

    public List<EntityLivingBase> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(EntityLivingBase.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(r, r, r), e -> e != this && (double)this.func_70032_d((Entity)e) <= r);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != this && (double)this.func_70032_d((Entity)e) <= r && e.field_70163_u <= this.field_70163_u + dY);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_110143_aJ() <= 0.0f) {
            Animation death = this.getDeathAnimation();
            if (death != null) {
                this.onDeathUpdate(death.getDuration() - 20);
            } else {
                this.onDeathUpdate(20);
            }
        }
    }

    private void onDeathUpdate(int deathDuration) {
        this.onDeathAIUpdate();
        if (++this.field_70725_aQ >= deathDuration) {
            boolean isPlayerKill;
            boolean bl = isPlayerKill = this.field_70718_bc > 0;
            if (!this.field_70170_p.field_72995_K && isPlayerKill && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int value;
                for (int remaining = this.func_70693_a(this.field_70717_bb); remaining > 0; remaining -= value) {
                    value = EntityXPOrb.func_70527_a((int)remaining);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, value));
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.dropLoot();
            }
            this.func_70106_y();
            for (int n = 0; n < 20; ++n) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    protected void onDeathAIUpdate() {
    }

    protected final void func_70609_aI() {
    }

    protected final void func_184610_a(boolean isPlayerKill, int lootingModifier, DamageSource source) {
    }

    protected final void func_70628_a(boolean isPlayerKill, int lootingModifier) {
    }

    protected final void func_82160_b(boolean isPlayerKill, int lootingModifier) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean attack = super.func_70097_a(source, damage);
        if (attack) {
            if (this.func_110143_aJ() > 0.0f && this.getAnimation() == NO_ANIMATION && this.playsHurtAnimation) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, this.getHurtAnimation());
            } else if (this.func_110143_aJ() <= 0.0f) {
                if (this.currentAnim != null) {
                    this.currentAnim.func_75251_c();
                }
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, this.getDeathAnimation());
            }
        }
        return attack;
    }

    protected void addIntermittentAnimation(IntermittentAnimation animation) {
        animation.setID((byte)this.intermittentAnimations.size());
        this.intermittentAnimations.add(animation);
    }

    public void func_70103_a(byte id) {
        if (id >= 4 && id - 4 < this.intermittentAnimations.size()) {
            this.intermittentAnimations.get(id - 4).start();
            return;
        }
        super.func_70103_a(id);
    }

    @Override
    public byte getOffsetEntityState() {
        return 4;
    }

    public void circleEntity(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        this.func_70661_as().func_75492_a(target.field_70165_t + (double)radius * Math.cos((double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset), target.field_70163_u, target.field_70161_v + (double)radius * Math.sin((double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset), (double)(speed * moveSpeedMultiplier));
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<EntityLivingBase> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.field_70159_w = -0.1 * Math.cos(angle);
            entity.field_70179_y = -0.1 * Math.sin(angle);
        }
    }

    protected void dropLoot() {
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (animation == NO_ANIMATION) {
            this.onAnimationFinish(this.animation);
        }
        this.animation = animation;
        this.setAnimationTick(0);
    }

    public abstract Animation getDeathAnimation();

    public abstract Animation getHurtAnimation();
}

