/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pcl.opensecurity.common.interfaces.IOwner;
import pcl.opensecurity.common.protection.IProtection;
import pcl.opensecurity.common.protection.Protection;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntitySecurityTerminal
extends TileEntityOSBase
implements IProtection,
IOwner {
    private UUID ownerUUID;
    private ArrayList<UUID> allowedUsers = new ArrayList();
    private String password = "";
    public Block block;
    private Boolean enabled = false;
    private boolean enableParticles = false;
    public int rangeMod = 1;
    int ticksExisted = 0;

    @Override
    public void setOwner(UUID uuid) {
        this.ownerUUID = uuid;
        this.allowedUsers.add(this.ownerUUID);
    }

    @Override
    public UUID getOwner() {
        return this.ownerUUID;
    }

    public TileEntitySecurityTerminal() {
        super("os_securityterminal");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32000.0).create();
    }

    public void func_145829_t() {
        super.func_145829_t();
        Protection.addArea(this.func_145831_w(), this.getArea(), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        Protection.removeArea(this.func_145831_w(), this.func_174877_v());
        super.func_145843_s();
    }

    @Override
    public boolean isProtected(Entity entityIn, Protection.UserAction action) {
        if (!this.enabled.booleanValue()) {
            return false;
        }
        if (!action.equals((Object)Protection.UserAction.explode) && this.isUserAllowedToBypass(entityIn.func_110124_au())) {
            return false;
        }
        if (!this.usePower().booleanValue()) {
            return false;
        }
        if (entityIn != null && entityIn instanceof EntityPlayer) {
            ((EntityPlayer)entityIn).func_146105_b((ITextComponent)new TextComponentString("this block is protected"), false);
        }
        return true;
    }

    private AxisAlignedBB getArea() {
        int rangeMod = this.rangeMod * 8;
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-rangeMod, -rangeMod, -rangeMod), this.func_174877_v().func_177982_a(rangeMod, rangeMod, rangeMod).func_177982_a(1, 1, 1));
    }

    public boolean isUserAllowedToBypass(UUID uuid) {
        return this.allowedUsers.contains(uuid);
    }

    @Callback(doc="function():boolean; Returns the status of the block", direct=true)
    public Object[] isEnabled(Context context, Arguments args) {
        return new Object[]{this.isEnabled()};
    }

    @Callback(doc="function(String:Password, String:Username):boolean; Adds the Minecraft User as an allowed user.", direct=true)
    public Object[] addUser(Context context, Arguments args) {
        if (args.checkString(0).equals(this.getPass())) {
            if (args.checkString(1).matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")) {
                this.allowedUsers.add(UUID.fromString(args.checkString(1)));
            } else {
                GameProfile gameprofile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(args.checkString(1));
                if (gameprofile == null) {
                    return new Object[]{true, "Failed to get UUID from username"};
                }
                this.allowedUsers.add(gameprofile.getId());
            }
            return new Object[]{true, "User added"};
        }
        return new Object[]{false, "Password was incorrect"};
    }

    @Callback(doc="function(String:Username):boolean; Removes the Minecraft User as an allowed user.", direct=true)
    public Object[] delUser(Context context, Arguments args) {
        if (args.checkString(0).equals(this.getPass())) {
            if (args.checkString(1).matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")) {
                this.allowedUsers.remove(UUID.fromString(args.checkString(1)));
            } else {
                GameProfile gameprofile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(args.checkString(1));
                if (gameprofile == null) {
                    return new Object[]{true, "Failed to get UUID from username"};
                }
                this.allowedUsers.remove(gameprofile.getId());
            }
            return new Object[]{true, "User removed"};
        }
        return new Object[]{false, "Password was incorrect"};
    }

    @Callback(doc="function(String:password):boolean; Sets the block password, required to enable/disable and other actions", direct=true)
    public Object[] setPassword(Context context, Arguments args) {
        if (this.getPass().isEmpty()) {
            this.setPass(args.checkString(0));
            return new Object[]{true, "Password set"};
        }
        if (args.checkString(0).equals(this.getPass())) {
            this.setPass(args.checkString(1));
            return new Object[]{true, "Password Changed"};
        }
        return new Object[]{false, "Password was not changed"};
    }

    @Callback(doc="function():boolean; Switches particles to show the corners of the protected area", direct=true)
    public Object[] toggleParticle(Context context, Arguments args) {
        if (args.optString(0, "").equals(this.getPass())) {
            this.enableParticles = !this.enableParticles;
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
            this.func_70296_d();
            return new Object[]{this.enableParticles};
        }
        return new Object[]{false, "Password incorrect"};
    }

    @Callback(doc="function(Int:range):boolean; Sets the range of the protction area 8*range max 4 min 1, increasing range increases energy cost.", direct=true)
    public Object[] setRange(Context context, Arguments args) {
        if (args.optString(0, "").equals(this.getPass())) {
            if (args.checkInteger(1) >= 1 && args.checkInteger(1) <= 4) {
                if (this.rangeMod != args.checkInteger(1)) {
                    this.rangeMod = args.checkInteger(1);
                    Protection.updateArea(this.func_145831_w(), this.func_174877_v(), this.getArea());
                    this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                    this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
                    this.func_70296_d();
                }
                return new Object[]{true};
            }
            return new Object[]{false, "Range out of bounds 1-4"};
        }
        return new Object[]{false, "Password incorrect"};
    }

    @Callback(doc="function(String:password):boolean; Enables the block, requires the correct password", direct=true)
    public Object[] enable(Context context, Arguments args) {
        if (args.optString(0, "").equals(this.getPass())) {
            this.enabled = true;
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
            this.func_70296_d();
            return new Object[]{true};
        }
        return new Object[]{false, "Password incorrect"};
    }

    @Callback(doc="function(String:password):boolean; Disables the block, requires the correct password", direct=true)
    public Object[] disable(Context context, Arguments args) {
        if (args.optString(0, "").equals(this.getPass())) {
            this.enabled = false;
            return new Object[]{true};
        }
        return new Object[]{false, "Password incorrect"};
    }

    @Callback(doc="function(String:password):boolean; returns a comma delimited string of current allowed users.", direct=true)
    public Object[] getAllowedUsers(Context context, Arguments args) {
        if (args.optString(0, "").equals(this.getPass())) {
            HashMap<UUID, String> users = new HashMap<UUID, String>();
            for (UUID uuid : this.allowedUsers) {
                GameProfile gameProfile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(uuid);
                if (gameProfile == null) continue;
                users.put(uuid, gameProfile.getName());
            }
            return new Object[]{users.values().toArray()};
        }
        return new Object[]{false, "Password incorrect"};
    }

    public void setPass(String pass) {
        this.password = pass;
    }

    public String getPass() {
        return this.password;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
        if (!this.field_145850_b.field_72995_K && this.ticksExisted % 40 == 0 && this.isParticleEnabled()) {
            double motionX = this.field_145850_b.field_73012_v.nextGaussian() * 0.02;
            double motionY = this.field_145850_b.field_73012_v.nextGaussian() * 0.02;
            double motionZ = this.field_145850_b.field_73012_v.nextGaussian() * 0.02;
            WorldServer wServer = (WorldServer)this.field_145850_b;
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() + 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() - 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() - 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() + 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() - 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() + 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() - 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            wServer.func_175739_a(EnumParticleTypes.BARRIER, (double)((float)(this.field_174879_c.func_177958_n() + 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() - 8 * this.rangeMod) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() + 8 * this.rangeMod) + 0.5f), 25, motionX, motionY, motionZ, 0.5, new int[0]);
            this.ticksExisted = 0;
        }
        ++this.ticksExisted;
    }

    public boolean isParticleEnabled() {
        return this.enableParticles;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ownerUUID = nbt.func_186855_b("owner") ? nbt.func_186857_a("owner") : (nbt.func_74764_b("owner") ? UUID.fromString(nbt.func_74779_i("owner")) : null);
        this.password = nbt.func_74779_i("password");
        this.enabled = nbt.func_74767_n("enabled");
        this.rangeMod = nbt.func_74762_e("rangeMod");
        this.enableParticles = nbt.func_74767_n("particles");
        this.allowedUsers.clear();
        int i = 0;
        while (nbt.func_186855_b("allowedUser" + i)) {
            this.allowedUsers.add(nbt.func_186857_a("allowedUser" + i));
            ++i;
        }
        if (nbt.func_74764_b("allowedUsers")) {
            for (String user : Arrays.asList(nbt.func_74779_i("allowedUsers").replaceAll(", $", "").split(", "))) {
                this.allowedUsers.add(UUID.fromString(user));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.ownerUUID != null) {
            nbt.func_186854_a("owner", this.ownerUUID);
        }
        nbt.func_74778_a("password", this.password);
        nbt.func_74757_a("enabled", this.isEnabled());
        nbt.func_74768_a("rangeMod", this.rangeMod);
        nbt.func_74757_a("particles", this.isParticleEnabled());
        for (int i = 0; i < this.allowedUsers.size(); ++i) {
            nbt.func_186854_a("allowedUser" + i, this.allowedUsers.get(i));
        }
        return nbt;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Boolean usePower() {
        return this.node.tryChangeBuffer((double)(-10 * this.rangeMod));
    }
}

