/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import li.cil.oc.api.network.EnvironmentHost;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.client.sounds.MachineSound;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntityOSSound
extends TileEntityOSBase {
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    private Boolean shouldPlay = false;
    private ResourceLocation soundRes;
    private float volume = 1.0f;
    private String soundName = "";

    TileEntityOSSound(String name) {
        super(name);
    }

    TileEntityOSSound(String name, EnvironmentHost host) {
        super(name, host);
    }

    @Override
    public void func_145843_s() {
        this.setShouldPlay(false);
        if (this.func_145831_w().field_72995_K) {
            this.updateSound();
        }
        super.func_145843_s();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K) {
            this.updateSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (!this.hasSound() || this.isUpgrade) {
            return;
        }
        if (this.getShouldPlay()) {
            this.playSoundNow();
        } else if (this.sound != null) {
            this.sound.endPlaying();
            this.sound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    void playSoundNow() {
        if (this.sound == null) {
            this.sound = new MachineSound(this.getSoundRes(), this.func_174877_v(), this.getVolume(), this.getPitch(), this.shouldRepeat());
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isUpgrade = tag.func_74767_n("isUpgrade");
        this.setSound(tag.func_74779_i("soundName"));
        this.setVolume(tag.func_74760_g("volume"));
        this.setShouldPlay(tag.func_74767_n("shouldPlay"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("isUpgrade", this.isUpgrade);
        tag.func_74757_a("shouldPlay", this.getShouldPlay());
        tag.func_74778_a("soundName", this.getSoundName());
        tag.func_74776_a("volume", this.getVolume());
        return tag;
    }

    void setSound(String sound) {
        this.soundName = sound;
        this.soundRes = new ResourceLocation("opensecurity", sound);
    }

    String getSoundName() {
        return this.soundName;
    }

    private ResourceLocation getSoundRes() {
        return this.soundRes;
    }

    private boolean getShouldPlay() {
        return this.shouldPlay;
    }

    public void setShouldPlay(boolean b) {
        if (this.shouldPlay == b) {
            return;
        }
        this.shouldPlay = b;
        if (!this.isUpgrade && !this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.func_189517_E_();
            this.func_70296_d();
        }
    }

    private boolean hasSound() {
        return this.getSoundName().length() > 0;
    }

    private float getPitch() {
        return 1.0f;
    }

    private boolean shouldRepeat() {
        return this.getShouldPlay();
    }

    void setVolume(float vol) {
        this.volume = vol;
    }

    float getVolume() {
        return this.volume;
    }
}

