/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.world;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.WidgetModifier;
import ben_mkiv.rendertoolkit.common.widgets.WidgetType;
import ben_mkiv.rendertoolkit.common.widgets.component.common.OBJModelOC;
import ben_mkiv.rendertoolkit.common.widgets.component.world.OBJModel3D;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.ITracker;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class EntityTracker3D
extends OBJModel3D
implements ITracker {
    private static ArrayList<WidgetModifier.WidgetModifierType> applyModifiersList = new ArrayList();
    private static int maximumRange;
    private int trackingRange = 0;
    private EntityType trackingType = EntityType.ALL;
    private String trackingEntityName = "";
    private int trackingEntityMetaIndex = 0;
    private UUID uniqueEntityID = null;

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        buff.writeInt(this.trackingRange);
        buff.writeInt(this.trackingType.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.trackingEntityName);
        buff.writeInt(this.trackingEntityMetaIndex);
        if (this.uniqueEntityID == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)"none");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.uniqueEntityID.toString());
        }
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.trackingRange = Math.min(buff.readInt(), ClientSurface.instances.maxTrackingRange);
        this.trackingType = EntityType.values()[buff.readInt()];
        this.setupTracking(this.trackingType, this.trackingRange);
        this.trackingEntityName = ByteBufUtils.readUTF8String((ByteBuf)buff);
        this.trackingEntityMetaIndex = buff.readInt();
        this.setupTrackingFilter(this.trackingEntityName, this.trackingEntityMetaIndex);
        this.uniqueEntityID = this.string2UUID(ByteBufUtils.readUTF8String((ByteBuf)buff));
        this.setupTrackingEntity(this.uniqueEntityID);
    }

    private void setupTracking(int tT, int range) {
        this.setupTracking(EntityType.values()[tT], range);
    }

    @Override
    public void setupTracking(EntityType tT, int range) {
        this.trackingType = tT;
        this.trackingRange = Math.min(range, maximumRange);
    }

    @Override
    public void setupTrackingFilter(String type, int metaindex) {
        this.trackingEntityName = type.toLowerCase();
        this.trackingEntityMetaIndex = metaindex;
    }

    @Override
    public void setupTrackingEntity(UUID uuid) {
        this.uniqueEntityID = uuid;
    }

    private HashSet<? extends Entity> getAllEntities(Vec3d origin, int distance, World world, Class<? extends Entity> eClass, AxisAlignedBB bounds) {
        HashSet<Entity> entities = new HashSet<Entity>();
        for (Entity entity : world.func_72872_a(eClass, bounds)) {
            if (!EntityTracker3D.checkDistance(origin, new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), distance)) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public WidgetType getType() {
        return WidgetType.ENTITYTRACKER3D;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderEntityTracker();
    }

    private static boolean checkDistance(Vec3d src, Vec3d target, int range) {
        return src.func_72438_d(target) <= (double)range;
    }

    static {
        applyModifiersList.add(WidgetModifier.WidgetModifierType.ROTATE);
        applyModifiersList.add(WidgetModifier.WidgetModifierType.TRANSLATE);
        maximumRange = 128;
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderEntityTracker
    extends OBJModelOC.RenderableOBJModel {
        public RenderEntityTracker() {
            super(EntityTracker3D.this);
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            if (EntityTracker3D.this.objFile == null) {
                return;
            }
            if (!ClientSurface.instances.entityTrackerEnabled) {
                return;
            }
            if (EntityTracker3D.this.trackingType.equals((Object)EntityType.NONE)) {
                return;
            }
            RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
            Entity focusedEntity = objectMouseOver != null && objectMouseOver.field_72313_a.equals((Object)RayTraceResult.Type.ENTITY) ? objectMouseOver.field_72308_g : null;
            Vec3d playerPos = player.func_174791_d();
            AxisAlignedBB bounds = new AxisAlignedBB(playerPos, playerPos).func_186662_g((double)EntityTracker3D.this.trackingRange);
            GL11.glTranslated((double)renderOffset.field_72450_a, (double)renderOffset.field_72448_b, (double)renderOffset.field_72449_c);
            this.preRender(conditionStates);
            EntityTracker3D.this.TESR = Tessellator.func_178181_a();
            EntityTracker3D.this.buffer = EntityTracker3D.this.TESR.func_178180_c();
            switch (EntityTracker3D.this.trackingType) {
                case ALL: 
                case ITEM: {
                    for (Entity e : EntityTracker3D.this.getAllEntities(player.func_174791_d(), EntityTracker3D.this.trackingRange, player.field_70170_p, EntityItem.class, bounds)) {
                        if (!this.checkRender(e)) continue;
                        this.renderTarget(e, player, this.customRenderConditions(conditionStates, e, focusedEntity));
                    }
                    break;
                }
            }
            switch (EntityTracker3D.this.trackingType) {
                case ALL: 
                case PLAYER: 
                case LIVING: {
                    for (Entity e : EntityTracker3D.this.getAllEntities(player.func_174791_d(), EntityTracker3D.this.trackingRange, player.field_70170_p, EntityPlayer.class, bounds)) {
                        if (!this.checkRender(e) || e == player) continue;
                        this.renderTarget(e, player, this.customRenderConditions(conditionStates, e, focusedEntity));
                    }
                    break;
                }
            }
            switch (EntityTracker3D.this.trackingType) {
                case ALL: 
                case LIVING: 
                case NEUTRAL: 
                case HOSTILE: {
                    for (Entity e : EntityTracker3D.this.getAllEntities(player.func_174791_d(), EntityTracker3D.this.trackingRange, player.field_70170_p, EntityLiving.class, bounds)) {
                        if (!this.checkRender(e)) continue;
                        this.renderTarget(e, player, this.customRenderConditions(conditionStates, e, focusedEntity));
                    }
                    break;
                }
            }
            this.postRender();
        }

        long customRenderConditions(long customConditions, Entity e, Entity focusedEntity) {
            if (focusedEntity != null && focusedEntity.getPersistentID().equals(e.getPersistentID())) {
                customConditions |= 0x20000000000L;
            }
            if (e instanceof EntityMob) {
                customConditions |= 0x100000000000L;
            }
            if (!(e instanceof EntityMob) && e instanceof EntityLivingBase) {
                customConditions |= 0x200000000000L;
            }
            if (e instanceof EntityLivingBase) {
                customConditions |= 0x80000000000L;
            }
            if (e instanceof EntityItem) {
                customConditions |= 0x800000000000L;
            }
            if (e instanceof EntityPlayer) {
                customConditions |= 0x400000000000L;
            }
            return customConditions;
        }

        boolean checkRender(Entity e) {
            switch (EntityTracker3D.this.trackingType) {
                case ALL: {
                    return true;
                }
                case UNIQUE: {
                    return e.func_110124_au().equals(EntityTracker3D.this.uniqueEntityID);
                }
                case HOSTILE: {
                    if (!(e instanceof EntityMob)) {
                        return false;
                    }
                    if (EntityTracker3D.this.trackingEntityName.length() > 0) {
                        return e.func_70005_c_().toLowerCase().equals(EntityTracker3D.this.trackingEntityName);
                    }
                    return true;
                }
                case PLAYER: 
                case LIVING: {
                    if (!(e instanceof EntityLivingBase)) {
                        return false;
                    }
                    if (EntityTracker3D.this.trackingEntityName.length() > 0) {
                        return e.func_70005_c_().toLowerCase().equals(EntityTracker3D.this.trackingEntityName);
                    }
                    return true;
                }
                case NEUTRAL: {
                    if (!(e instanceof EntityLivingBase)) {
                        return false;
                    }
                    if (e instanceof EntityMob) {
                        return false;
                    }
                    if (EntityTracker3D.this.trackingEntityName.length() > 0) {
                        return e.func_70005_c_().toLowerCase().equals(EntityTracker3D.this.trackingEntityName);
                    }
                    return true;
                }
                case ITEM: {
                    if (!(e instanceof EntityItem)) {
                        return false;
                    }
                    if (EntityTracker3D.this.trackingEntityName.length() == 0) {
                        return true;
                    }
                    if (EntityTracker3D.this.trackingEntityMetaIndex != -1 && ((EntityItem)e).func_92059_d().func_77960_j() != EntityTracker3D.this.trackingEntityMetaIndex) {
                        return false;
                    }
                    return EntityTracker3D.this.trackingEntityName.equalsIgnoreCase(((EntityItem)e).func_92059_d().func_77973_b().getRegistryName().toString());
                }
            }
            return false;
        }

        void renderTarget(Entity entity, EntityPlayer player, long conditionStates) {
            GlStateManager.func_179094_E();
            Vec3d pos = entity.func_174791_d();
            GL11.glTranslated((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
            this.applyModifierList(conditionStates, applyModifiersList);
            int color = EntityTracker3D.this.WidgetModifierList.getCurrentColor(conditionStates, 0);
            if (EntityTracker3D.this.faceWidgetToPlayer) {
                GL11.glRotated((double)(180.0f - player.field_70177_z), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)(-player.field_70125_A), (double)1.0, (double)0.0, (double)0.0);
            }
            if (EntityTracker3D.this.objFile.facesTri.size() > 0) {
                EntityTracker3D.this.buffer.func_181668_a(4, this.malisisVertexFormat);
                this.renderList(EntityTracker3D.this.objFile.facesTri, color);
                EntityTracker3D.this.TESR.func_78381_a();
            }
            if (EntityTracker3D.this.objFile.facesQuad.size() > 0) {
                EntityTracker3D.this.buffer.func_181668_a(7, this.malisisVertexFormat);
                this.renderList(EntityTracker3D.this.objFile.facesQuad, color);
                EntityTracker3D.this.TESR.func_78381_a();
            }
            GlStateManager.func_179121_F();
        }
    }

    public static enum EntityType {
        NONE,
        ALL,
        ITEM,
        LIVING,
        PLAYER,
        HOSTILE,
        NEUTRAL,
        UNIQUE;

    }
}

