/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.common;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLOverlay;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLWorld;
import ben_mkiv.rendertoolkit.common.widgets.WidgetModifier;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IEntity;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierColor;
import ben_mkiv.rendertoolkit.common.widgets.core.modifiers.WidgetModifierRotate;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class EntityWidget
extends WidgetGLWorld
implements IEntity {
    EntityLivingBase entity = null;

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        if (this.entity != null) {
            ByteBufUtils.writeTag((ByteBuf)buff, (NBTTagCompound)this.entity.serializeNBT());
        } else {
            ByteBufUtils.writeTag((ByteBuf)buff, (NBTTagCompound)new NBTTagCompound());
        }
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        NBTTagCompound entityNBT = ByteBufUtils.readTag((ByteBuf)buff);
        if (!entityNBT.equals((Object)new NBTTagCompound())) {
            this.setEntity(entityNBT, Minecraft.func_71410_x().field_71439_g.field_70170_p);
        } else {
            this.entity = null;
        }
    }

    @Override
    public boolean setEntity(EntityLivingBase entity) {
        try {
            NBTTagCompound nbt;
            if (entity instanceof EntityPlayer) {
                nbt = entity.func_189511_e(new NBTTagCompound());
                nbt.func_74757_a("isPlayer", true);
                NBTTagCompound gameProfileNBT = NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)((EntityPlayer)entity).func_146103_bH());
                nbt.func_74782_a("gameProfile", (NBTBase)gameProfileNBT);
            } else {
                nbt = entity.serializeNBT();
                nbt.func_74757_a("isPlayer", false);
            }
            this.setEntity(nbt, entity.field_70170_p);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setEntity(NBTTagCompound entityNBT, World world) {
        try {
            if (!entityNBT.func_74767_n("isPlayer")) {
                this.entity = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)world);
            } else {
                GameProfile gameProfile = NBTUtil.func_152459_a((NBTTagCompound)entityNBT.func_74775_l("gameProfile"));
                this.setGameProfile(gameProfile);
                this.entity = new RenderPlayer((World)DimensionManager.getWorld((int)0), gameProfile);
                this.entity.func_70020_e(entityNBT);
            }
            this.entity.field_70125_A = 0.0f;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableEntity();
    }

    private void setGameProfile(GameProfile profile) {
        if (!profile.isComplete() || !profile.getProperties().containsKey((Object)"textures")) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_147130_as().fillProfileProperties(profile, false);
        }
    }

    public class RenderableEntity
    extends WidgetGLOverlay.RenderableGLWidget {
        public RenderableEntity() {
            super(EntityWidget.this);
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            if (EntityWidget.this.entity == null) {
                return;
            }
            this.preRender(conditionStates);
            GlStateManager.func_179137_b((double)renderOffset.field_72450_a, (double)renderOffset.field_72448_b, (double)70.0);
            this.applyModifiers(conditionStates);
            float rotationY = 0.0f;
            boolean hasColor = false;
            for (WidgetModifier modifier : EntityWidget.this.WidgetModifierList.modifiers) {
                if (modifier instanceof WidgetModifierRotate) {
                    float rotY = ((WidgetModifierRotate)modifier).Y;
                    GlStateManager.func_179114_b((float)(-rotY), (float)0.0f, (float)1.0f, (float)0.0f);
                    rotationY += rotY;
                }
                if (!(modifier instanceof WidgetModifierColor)) continue;
                hasColor = true;
            }
            if (!hasColor) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (EntityWidget.this.rendertype == RenderType.WorldLocated) {
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (EntityWidget.this.faceWidgetToPlayer) {
                    GlStateManager.func_179114_b((float)player.field_70177_z, (float)0.0f, (float)-1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            } else {
                this.applyAlignments();
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            this.renderEntity(renderOffset, rotationY);
            this.postRender();
        }

        private void applyAlignments() {
            switch (this.getHorizontalAlign()) {
                case CENTER: {
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
                    break;
                }
                case RIGHT: {
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
                }
            }
            switch (this.getVerticalAlign()) {
                case MIDDLE: {
                    GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                    break;
                }
                case BOTTOM: {
                    GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                }
            }
        }

        void renderEntity(Vec3d location, float rotation) {
            if (EntityWidget.this.entity == null) {
                return;
            }
            GlStateManager.func_179142_g();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)50.0f, (float)50.0f, (float)50.0f);
            GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            EntityWidget.this.entity.field_70177_z = EntityWidget.this.entity.field_70761_aq = -180.0f + rotation * 360.0f;
            EntityWidget.this.entity.field_70758_at = EntityWidget.this.entity.field_70761_aq;
            EntityWidget.this.entity.field_70759_as = EntityWidget.this.entity.field_70761_aq;
            RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
            rendermanager.func_178633_a(false);
            rendermanager.func_188391_a((Entity)EntityWidget.this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            rendermanager.func_178633_a(true);
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
        }
    }

    @SideOnly(value=Side.CLIENT)
    class RenderPlayer
    extends EntityOtherPlayerMP {
        public RenderPlayer(World world, GameProfile gameProfile) {
            super(world, gameProfile);
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentString("");
        }
    }
}

