/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.WidgetModifiers;
import ben_mkiv.rendertoolkit.common.widgets.WidgetType;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IAttribute;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Widget
implements IAttribute {
    boolean isVisible = true;
    private UUID widgetOwner = null;
    public WidgetModifiers WidgetModifierList = new WidgetModifiers();

    public static Widget create(int index) {
        try {
            return WidgetType.values()[index].clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract WidgetType getType();

    public abstract void writeData(ByteBuf var1);

    public abstract void readData(ByteBuf var1);

    public UUID string2UUID(String input) {
        try {
            return UUID.fromString(input);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final void write(ByteBuf buff) {
        buff.writeBoolean(this.isVisible);
        if (this.widgetOwner != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.widgetOwner.toString());
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)"@NONE");
        }
        this.writeData(buff);
    }

    public final void read(ByteBuf buff) {
        this.isVisible = buff.readBoolean();
        this.widgetOwner = this.string2UUID(ByteBufUtils.readUTF8String((ByteBuf)buff));
        this.readData(buff);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        ByteBuf buff = Unpooled.buffer();
        this.write(buff);
        nbt.func_74773_a("WidgetData", buff.array());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("WidgetData")) {
            return;
        }
        byte[] b = nbt.func_74770_j("WidgetData");
        ByteBuf buff = Unpooled.copiedBuffer((byte[])b);
        this.read(buff);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IRenderableWidget getRenderable();

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public UUID getOwnerUUID() {
        return this.widgetOwner;
    }

    public String getOwner() {
        if (this.widgetOwner != null) {
            return UsernameCache.getLastKnownUsername((UUID)this.widgetOwner);
        }
        return "";
    }

    public UUID setOwner(String playerName) {
        if (playerName.length() == 0) {
            this.widgetOwner = null;
        } else {
            EntityPlayerMP newOwner = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
            if (newOwner != null) {
                this.widgetOwner = newOwner.func_146103_bH().getId();
            }
        }
        return this.getOwnerUUID();
    }
}

