/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.client.thermalvision;

import ben_mkiv.rendertoolkit.client.thermalvision.VazkiiShaderHelper;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.ARBShaderObjects;

public class ThermalEntityRender {
    private static double currentDistance = 0.0;
    private static boolean isDead = false;
    static HashSet<Entity> forceGlowingEntities = new HashSet();
    public static final VazkiiShaderHelper.ShaderCallback callback = shader -> {
        if (isDead) {
            ThermalEntityRender.setShaderColor(shader, "red", 0.0f);
            ThermalEntityRender.setShaderColor(shader, "blue", 1.0f / (float)(currentDistance / 8.0));
        } else {
            ThermalEntityRender.setShaderColor(shader, "red", 1.0f / (float)(currentDistance / 8.0));
            ThermalEntityRender.setShaderColor(shader, "blue", 0.0f);
        }
        ThermalEntityRender.setShaderColor(shader, "green", 1.0f - (float)(8.0 / currentDistance));
        ThermalEntityRender.setShaderColor(shader, "alpha", 1.0f);
    };

    ThermalEntityRender() {
        VazkiiShaderHelper.initShaders();
    }

    private static void setShaderColor(int shader, String name, float val) {
        ARBShaderObjects.glUniform1fARB((int)OpenGlHelper.func_153194_a((int)shader, (CharSequence)name), (float)val);
    }

    @SubscribeEvent
    public void preRender(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (!event.getEntity().func_184202_aL()) {
            forceGlowingEntities.add((Entity)event.getEntity());
            event.getEntity().func_184195_f(true);
        }
        isDead = false;
        if (event.getEntity() instanceof EntityMob) {
            switch (event.getEntity().func_70668_bt()) {
                case UNDEFINED: 
                case ARTHROPOD: {
                    break;
                }
                case UNDEAD: 
                case ILLAGER: {
                    isDead = true;
                }
            }
        }
        currentDistance = event.getEntity().func_174791_d().func_72438_d(Minecraft.func_71410_x().field_71439_g.func_174791_d());
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        VazkiiShaderHelper.useShader(VazkiiShaderHelper.thermalColorShader, callback);
    }

    @SubscribeEvent
    public void postRender(RenderLivingEvent.Post<EntityLivingBase> event) {
        VazkiiShaderHelper.releaseShader();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderFogEvent(EntityViewRenderEvent.FogDensity event) {
        event.setDensity(0.1f);
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderFogEvent(EntityViewRenderEvent.FogColors event) {
        event.setBlue(0.0f);
        event.setGreen(1.0f);
        event.setRed(0.0f);
    }
}

